/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.openapi.project.Project;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlParametrizedType;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeCastExpression;
import org.jetbrains.annotations.NotNull;

public class CassExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @Override
    @NotNull
    protected String generateSelectStatement(@NotNull String text, @NotNull SqlElement sqlElement) {
        if (text == null) {
            CassExecutionEnvironmentHelper.$$$reportNull$$$0(0);
        }
        if (sqlElement == null) {
            CassExecutionEnvironmentHelper.$$$reportNull$$$0(1);
        }
        if (sqlElement instanceof SqlTypeCastExpression) {
            String string = String.format("SELECT %s FROM system.local", text);
            if (string == null) {
                CassExecutionEnvironmentHelper.$$$reportNull$$$0(2);
            }
            return string;
        }
        String type = "???";
        if (sqlElement instanceof SqlExpression) {
            SqlType sqlType = ((SqlExpression)sqlElement).getSqlType();
            if (sqlType instanceof SqlPrimitiveType && sqlType != SqlType.UNKNOWN) {
                type = sqlType.getDisplayName();
            } else if (sqlType instanceof SqlParametrizedType) {
                type = sqlType.getDataType().getSpecification();
            }
        }
        String string = String.format("SELECT (%s) %s FROM system.local", type, text);
        if (string == null) {
            CassExecutionEnvironmentHelper.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getKeepAliveQuery(@NotNull Project project, @NotNull LocalDataSource dataSource) {
        if (project == null) {
            CassExecutionEnvironmentHelper.$$$reportNull$$$0(4);
        }
        if (dataSource == null) {
            CassExecutionEnvironmentHelper.$$$reportNull$$$0(5);
        }
        return "select * from system.local";
    }

    @Override
    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        ExecutionEnvironmentHelper.TimeZoneManager timeZoneManager = ExecutionEnvironmentHelper.TimeZoneManager.UNSUPPORTED;
        if (timeZoneManager == null) {
            CassExecutionEnvironmentHelper.$$$reportNull$$$0(6);
        }
        return timeZoneManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlElement";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/cassandra/CassExecutionEnvironmentHelper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/cassandra/CassExecutionEnvironmentHelper";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSelectStatement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeZoneManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateSelectStatement";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKeepAliveQuery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

