/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.clickhouse.introspector;

import com.intellij.database.dialects.base.introspector.BaseIntroQueries;
import com.intellij.database.dialects.clickhouse.generator.CHouseNamingService;
import com.intellij.database.dialects.clickhouse.introspector.CHouseIntroQueries;
import com.intellij.database.dialects.clickhouse.model.CHouseLikeTable;
import com.intellij.database.dialects.clickhouse.model.CHouseRoot;
import com.intellij.database.dialects.clickhouse.model.CHouseSchema;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.util.Version;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u001b\u001c\u001d\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nJ\"\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\nJ\"\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\nJ*\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\nJ\"\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\nJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001a\u001a\u00020\u0016*\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0016*\u00020\bH\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries;", "Lcom/intellij/database/dialects/base/introspector/BaseIntroQueries;", "()V", "processColumns", "", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "sc", "Lcom/intellij/database/dialects/clickhouse/model/CHouseSchema;", "action", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$ColumnInfo;", "processFunctions", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$FunctionInfo;", "processRoles", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$RoleInfo;", "processTables", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$TableInfo;", "processUsers", "Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$UserInfo;", "retrieveSchemas", "", "", "retrieveTableSource", "tab", "Lcom/intellij/database/dialects/clickhouse/model/CHouseLikeTable;", "fqName", "ColumnInfo", "FunctionInfo", "RoleInfo", "TableInfo", "UserInfo", "intellij.database.dialects.clickhouse"})
public final class CHouseIntroQueries
extends BaseIntroQueries {
    @NotNull
    public static final CHouseIntroQueries INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> retrieveSchemas(@NotNull DBTransaction transaction) {
        void $this$retrieveList$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String query$iv = "select name from system.databases order by name != currentDatabase()";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        return BaseIntroQueries.access$retrieveList((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveList$iv, String.class, query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTables(@NotNull DBTransaction transaction, @NotNull CHouseSchema sc2, @NotNull Function1<? super TableInfo, Unit> action) {
        void parameters$iv;
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sc2, (String)"sc");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        CHouseRoot cHouseRoot = sc2.getRoot();
        if (cHouseRoot == null || (cHouseRoot = cHouseRoot.getServerVersion()) == null) {
            cHouseRoot = Version.ZERO;
        }
        CHouseRoot ver = cHouseRoot;
        boolean hasUuid = ver.isOrGreater(new int[]{20, 4});
        boolean hasComments = ver.isOrGreater(new int[]{21, 6});
        boolean hasTemp = ver.isOrGreater(new int[]{1, 1, 54356});
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select t.name name, t.engine engine, " + (hasUuid ? "if(i1.engine = '', i2.engine, i1.engine)" : "i1.engine") + " mv_engine,\n          " + (hasTemp ? "t.is_temporary" : "0") + " is_temporary,\n          " + (hasComments ? "t." : "null ") + "comment\n        from system.tables t\n          any left join system.tables i1 on i1.name = '.inner.' || t.name " + (hasUuid ? "any left join system.tables i2 on i2.name = '.inner_id.' || toString(t.uuid)" : "") + "\n        where t.name not like '.inner.%' and t.name not like '.inner\\\\_id.%' and t.database = ?\n        ";
        String[] stringArray = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, TableInfo.class, (String)query$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processColumns(@NotNull DBTransaction transaction, @NotNull CHouseSchema sc2, @NotNull Function1<? super ColumnInfo, Unit> action) {
        void parameters$iv;
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sc2, (String)"sc");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        CHouseRoot cHouseRoot = sc2.getRoot();
        boolean hasComments = cHouseRoot == null || (cHouseRoot = cHouseRoot.getServerVersion()) == null || cHouseRoot.isOrGreater(new int[]{18, 16});
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select table, name, type, " + (hasComments ? "" : "null ") + "comment, default_kind, default_expression\n            from system.columns\n            where name not like '.inner.%' and name not like '.inner\\\\_id.%' and database = ?\n            ";
        String[] stringArray = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ColumnInfo.class, (String)query$iv, (Object[])parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processFunctions(@NotNull DBTransaction transaction, @NotNull Function1<? super FunctionInfo, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select name, is_aggregate from system.functions";
        Object[] parameters$iv = null;
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, FunctionInfo.class, (String)query$iv, parameters$iv, null, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processUsers(@NotNull DBTransaction transaction, @NotNull Function1<? super UserInfo, Unit> action) {
        void queryExtraHandler$iv;
        void exceptionHandler$iv;
        void parameters$iv;
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select name, auth_type,\n         host_ip, host_names, host_names_regexp, host_names_like,\n         default_roles_all, default_roles_list, default_roles_except\n    from system.users";
        Object var6_6 = null;
        Function1 function1 = processUsers.1.INSTANCE;
        Object var8_8 = null;
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, UserInfo.class, (String)query$iv, (Object[])parameters$iv, (Function1)exceptionHandler$iv, (Function1)queryExtraHandler$iv, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoles(@NotNull DBTransaction transaction, @NotNull Function1<? super RoleInfo, Unit> action) {
        void queryExtraHandler$iv;
        void exceptionHandler$iv;
        void parameters$iv;
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select name from system.roles";
        Object var6_6 = null;
        Function1 function1 = processRoles.1.INSTANCE;
        Object var8_8 = null;
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, RoleInfo.class, (String)query$iv, (Object[])parameters$iv, (Function1)exceptionHandler$iv, (Function1)queryExtraHandler$iv, action);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String retrieveTableSource(@NotNull DBTransaction transaction, @NotNull CHouseLikeTable tab) {
        void $this$retrieveOne$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String query$iv = "show create table " + this.fqName(tab);
        Object[] parameters$iv = null;
        boolean $i$f$retrieveOne = false;
        return (String)BaseIntroQueries.access$retrieveOne((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveOne$iv, String.class, query$iv, parameters$iv);
    }

    private final String fqName(CHouseSchema $this$fqName) {
        String string = $this$fqName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return CHouseNamingService.INSTANCE.enquote(string, $this$fqName.getKind());
    }

    private final String fqName(CHouseLikeTable $this$fqName) {
        BasicSchema basicSchema = $this$fqName.getSchema();
        if (basicSchema == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.clickhouse.model.CHouseSchema");
        }
        StringBuilder stringBuilder = new StringBuilder().append(this.fqName((CHouseSchema)basicSchema)).append('.');
        String string = $this$fqName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return stringBuilder.append(CHouseNamingService.INSTANCE.enquote(string, $this$fqName.getKind())).toString();
    }

    private CHouseIntroQueries() {
    }

    static {
        CHouseIntroQueries cHouseIntroQueries;
        INSTANCE = cHouseIntroQueries = new CHouseIntroQueries();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$TableInfo;", "", "()V", "comment", "", "engine", "is_temporary", "", "mv_engine", "name", "intellij.database.dialects.clickhouse"})
    public static final class TableInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public String engine;
        @JvmField
        @Nullable
        public String mv_engine;
        @JvmField
        public boolean is_temporary;
        @JvmField
        @Nullable
        public String comment;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$ColumnInfo;", "", "()V", "comment", "", "default_expression", "default_kind", "name", "table", "type", "intellij.database.dialects.clickhouse"})
    public static final class ColumnInfo {
        @JvmField
        @NotNull
        public String table = "";
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @NotNull
        public String type = "";
        @JvmField
        @NotNull
        public String comment = "";
        @JvmField
        @Nullable
        public String default_kind;
        @JvmField
        @Nullable
        public String default_expression;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$FunctionInfo;", "", "()V", "is_aggregate", "", "Ljava/lang/Boolean;", "name", "", "intellij.database.dialects.clickhouse"})
    public static final class FunctionInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @Nullable
        public Boolean is_aggregate;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0012\u0010\u000f\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$UserInfo;", "", "()V", "auth_type", "", "default_roles_all", "", "default_roles_except", "", "[Ljava/lang/String;", "default_roles_list", "host_ip", "host_names", "host_names_like", "host_names_regexp", "name", "intellij.database.dialects.clickhouse"})
    public static final class UserInfo {
        @JvmField
        @NotNull
        public String name = "";
        @JvmField
        @NotNull
        public String auth_type = "";
        @JvmField
        @NotNull
        public String[] host_ip = new String[0];
        @JvmField
        @NotNull
        public String[] host_names = new String[0];
        @JvmField
        @NotNull
        public String[] host_names_regexp = new String[0];
        @JvmField
        @NotNull
        public String[] host_names_like = new String[0];
        @JvmField
        public boolean default_roles_all;
        @JvmField
        @NotNull
        public String[] default_roles_list = new String[0];
        @JvmField
        @NotNull
        public String[] default_roles_except = new String[0];
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/clickhouse/introspector/CHouseIntroQueries$RoleInfo;", "", "()V", "name", "", "intellij.database.dialects.clickhouse"})
    public static final class RoleInfo {
        @JvmField
        @NotNull
        public String name = "";
    }
}

