/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.plan;

import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.db2.plan.Db2BuilderState;
import com.intellij.database.dialects.db2.plan.Db2RawPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2PlanModelBuilder
extends AbstractPlanModelBuilder<Db2RawPlanData, Db2BuilderState> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Set<String> INDICES = new HashSet<String>();
    private static final Set<String> RELATIONS = new HashSet<String>();

    public Db2PlanModelBuilder() {
        super(EnumSet.noneOf(PlanModel.Feature.class));
    }

    @Override
    @NotNull
    public Db2RawPlanData createData() {
        return new Db2RawPlanData();
    }

    @Override
    protected void parseData() {
        this.parseRoot(new Db2BuilderState((Db2RawPlanData)this.myData, null));
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull Db2BuilderState state2) {
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        for (Db2BuilderState.ObjectId id : state2.nextObjectsIds()) {
            sb.append(id.toString()).append(";\n");
        }
        String string = sb.toString();
        if (string == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull Db2BuilderState state2) {
        List objs;
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(2);
        }
        if ((objs = ContainerUtil.filter(state2.nextObjects(), obj2 -> RELATIONS.contains(obj2.type))).size() > 1) {
            this.unsupportedFormat();
        }
        return objs.isEmpty() ? null : ((Db2BuilderState.Obj)objs.get((int)0)).id.toString();
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Db2BuilderState state2) {
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(3);
        }
        return state2.prevStream == null ? null : state2.prevStream.numRows;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull Db2BuilderState state2) {
        List objs;
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(4);
        }
        if ((objs = ContainerUtil.filter(state2.nextObjects(), obj2 -> INDICES.contains(obj2.type))).size() > 1) {
            this.unsupportedFormat();
        }
        return objs.isEmpty() ? null : ((Db2BuilderState.Obj)objs.get((int)0)).id.toString();
    }

    @Nullable
    private static Db2BuilderState.Operator getOperator(@NotNull Db2BuilderState state2) {
        Db2BuilderState.NodeId nodeId;
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(5);
        }
        return (nodeId = state2.getCurrentNodeId()) == null || nodeId.operatorId == null ? null : (Db2BuilderState.Operator)state2.shared.operatorById.get(nodeId.operatorId.intValue());
    }

    @Override
    protected void parsePlan(@NotNull Db2BuilderState state2) {
        Db2BuilderState.Operator op;
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(6);
        }
        if ((op = Db2PlanModelBuilder.getOperator(state2)) == null) {
            return;
        }
        if (!this.openNode(state2)) {
            return;
        }
        this.parseSubPlans(state2);
        String operatorType = op.type;
        PlanModel.NodeType type = TYPE_MAPPING.get(op.type);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        PlanModel.GenericNode node = this.createNode(state2, type, operatorType);
        this.closeNode(node);
    }

    @Override
    protected void parseSubPlans(@NotNull Db2BuilderState state2) {
        List<Db2BuilderState.Stream> streams;
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(7);
        }
        if ((streams = state2.shared.streamsByTargetId.get(state2.getCurrentNodeId())) == null) {
            return;
        }
        for (Db2BuilderState.Stream stream : streams) {
            this.parsePlan(new Db2BuilderState(state2.shared, stream));
        }
    }

    protected void parseRoot(@NotNull Db2BuilderState state2) {
        Db2BuilderState.Operator op;
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(8);
        }
        if ((op = Db2PlanModelBuilder.getOperator(state2)) == null) {
            this.unsupportedFormat("No plan data found (may be wrong plan table is used)");
        }
        if (!"RETURN".equals(op.type)) {
            this.unsupportedFormat();
        }
        List<Db2BuilderState.Stream> streams = state2.shared.streamsByTargetId.get(state2.getCurrentNodeId());
        if (!this.openNode(null)) {
            return;
        }
        for (Db2BuilderState.Stream stream : streams) {
            this.parseStatement(new Db2BuilderState(state2.shared, stream));
        }
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    protected void parseStatement(@NotNull Db2BuilderState state2) {
        Db2BuilderState.Operator op;
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(9);
        }
        if ((op = Db2PlanModelBuilder.getOperator(state2)) == null) {
            this.unsupportedFormat();
        }
        if (!this.openNode(null)) {
            return;
        }
        PlanModel.NodeType type = STATEMENT_MAPPING.get(op.type);
        if (type == null) {
            type = PlanModel.NodeType.SELECT;
            this.parsePlan(state2);
        } else {
            this.parseSubPlans(state2);
        }
        this.closeNode(this.createNode(state2, type, null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull Db2BuilderState state2) {
        Db2BuilderState.Operator operator2;
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(10);
        }
        return (operator2 = Db2PlanModelBuilder.getOperator(state2)) == null ? null : Double.valueOf(operator2.totalCost);
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull Db2BuilderState state2) {
        Db2BuilderState.Operator operator2;
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(11);
        }
        return (operator2 = Db2PlanModelBuilder.getOperator(state2)) == null ? null : Double.valueOf(operator2.firstRowCost);
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull Db2BuilderState state2) {
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(12);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull Db2BuilderState state2) {
        if (state2 == null) {
            Db2PlanModelBuilder.$$$reportNull$$$0(13);
        }
        return false;
    }

    static {
        TYPE_MAPPING.put("TBFUNC", PlanModel.NodeType.TABLE_FUNCTION);
        TYPE_MAPPING.put("EISCAN", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("FETCH", PlanModel.NodeType.ROWID_ACCESS);
        TYPE_MAPPING.put("FILTER", PlanModel.NodeType.FILTER);
        TYPE_MAPPING.put("GENROW", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("CMPEXP", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("GRPBY", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("HSJOIN", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("IXAND", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("IXSCAN", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("MSJOIN", PlanModel.NodeType.MERGE_JOIN);
        TYPE_MAPPING.put("NLJOIN", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("RIDSCN", PlanModel.NodeType.ROWID_ACCESS);
        TYPE_MAPPING.put("RPD", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("SHIP", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("SORT", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("TBSCAN", PlanModel.NodeType.SEQ_SCAN);
        TYPE_MAPPING.put("TEMP", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("TQ", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("UNIQUE", PlanModel.NodeType.UNIQUE);
        TYPE_MAPPING.put("XISCAN", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("XSCAN", PlanModel.NodeType.UNKNOWN);
        TYPE_MAPPING.put("XANDOR", PlanModel.NodeType.UNKNOWN);
        STATEMENT_MAPPING.put("UPDATE", PlanModel.NodeType.UPDATE);
        STATEMENT_MAPPING.put("DELETE", PlanModel.NodeType.DELETE);
        STATEMENT_MAPPING.put("INSERT", PlanModel.NodeType.INSERT);
        INDICES.add("IX");
        INDICES.add("RX");
        INDICES.add("XI");
        INDICES.add("PI");
        INDICES.add("LI");
        INDICES.add("LX");
        INDICES.add("LP");
        RELATIONS.add("NK");
        RELATIONS.add("DP");
        RELATIONS.add("TA");
        RELATIONS.add("TF");
        RELATIONS.add("+A");
        RELATIONS.add("+C");
        RELATIONS.add("+F");
        RELATIONS.add("+G");
        RELATIONS.add("+N");
        RELATIONS.add("+T");
        RELATIONS.add("+V");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/plan/Db2PlanModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/plan/Db2PlanModelBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOperator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

