/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseDriverCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudSpannerFileAuthProvider
implements DatabaseAuthProvider {
    private static final String ID = "cloud-spanner-credentials-file";
    private static final String CREDENTIALS = "credentials";

    @NotNull
    public String getId() {
        return ID;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message((String)"credentials.file", (Object[])new Object[0]);
        if (string == null) {
            CloudSpannerFileAuthProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isApplicable(@NotNull LocalDataSource dataSource) {
        Dbms dbms;
        if (dataSource == null) {
            CloudSpannerFileAuthProvider.$$$reportNull$$$0(1);
        }
        return (dbms = DbImplUtilCore.getDbms((DatabaseDriverCore)dataSource.getDatabaseDriver())) == Dbms.CLOUD_SPANNER;
    }

    public @Nullable CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent) {
        if (proto2 == null) {
            CloudSpannerFileAuthProvider.$$$reportNull$$$0(2);
        }
        String cred = (String)proto2.getConnectionPoint().getAdditionalProperties().get(CREDENTIALS);
        DataSourceUtil.putOrRemove((Map)proto2.getConnectionProperties(), (Object)CREDENTIALS, (Object)cred);
        return CompletableFuture.completedFuture(proto2);
    }

    @Nullable
    public DatabaseAuthProvider.AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull LocalDataSource dataSource) {
        if (credentials == null) {
            CloudSpannerFileAuthProvider.$$$reportNull$$$0(3);
        }
        if (dataSource == null) {
            CloudSpannerFileAuthProvider.$$$reportNull$$$0(4);
        }
        return new FileWidget(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/CloudSpannerFileAuthProvider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = CREDENTIALS;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/CloudSpannerFileAuthProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "intercept";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createWidget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileWidget
    implements DatabaseAuthProvider.AuthWidget {
        private final Project myProject;
        private JPanel myPanel;
        private TextFieldWithBrowseButton myField;

        public FileWidget(Project project) {
            this.myProject = project;
        }

        public void save(@NotNull LocalDataSource dataSource, boolean copyCredentials) {
            if (dataSource == null) {
                FileWidget.$$$reportNull$$$0(0);
            }
            DataSourceUtil.putOrRemove((Map)dataSource.getAdditionalProperties(), (Object)CloudSpannerFileAuthProvider.CREDENTIALS, (Object)StringUtil.nullize((String)this.getField().getText()));
            DataSourceUtil.putOrRemove((Map)dataSource.getDriverProperties(), (Object)CloudSpannerFileAuthProvider.CREDENTIALS, null);
        }

        public void reset(@NotNull LocalDataSource dataSource, boolean resetCredentials) {
            if (dataSource == null) {
                FileWidget.$$$reportNull$$$0(1);
            }
            String cred = (String)dataSource.getAdditionalProperties().get(CloudSpannerFileAuthProvider.CREDENTIALS);
            String cred2 = (String)dataSource.getDriverProperties().get(CloudSpannerFileAuthProvider.CREDENTIALS);
            this.getField().setText(StringUtil.nullize((String)(cred == null ? cred2 : cred)));
        }

        public boolean isPasswordChanged() {
            return false;
        }

        public void hidePassword() {
        }

        public void reloadCredentials() {
        }

        private TextFieldWithBrowseButton getField() {
            this.getComponent();
            return this.myField;
        }

        @NotNull
        public JComponent getComponent() {
            if (this.myField == null) {
                this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 6));
                this.myField = new TextFieldWithBrowseButton();
                this.myField.addBrowseFolderListener(DatabaseBundle.message((String)"dialog.title.credentials.file", (Object[])new Object[0]), DatabaseBundle.message((String)"label.cloud.spanner.credentials.file", (Object[])new Object[0]), this.myProject, FileChooserDescriptorFactory.createSingleFileDescriptor());
                JBLabel lbl = new JBLabel(DatabaseBundle.message((String)"label.credentials.file", (Object[])new Object[0]));
                this.myPanel.add((Component)lbl, UrlPropertiesPanel.createLabelConstraints((int)0, (int)0, (double)lbl.getPreferredSize().getWidth()));
                this.myPanel.add((Component)this.myField, UrlPropertiesPanel.createSimpleConstraints((int)0, (int)1, (int)3));
            }
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                FileWidget.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        @NotNull
        public JComponent getPreferredFocusedComponent() {
            JComponent jComponent = this.getComponent();
            if (jComponent == null) {
                FileWidget.$$$reportNull$$$0(3);
            }
            return jComponent;
        }

        public void forceSave() {
        }

        public void updateFromUrl(@NotNull ParametersHolder holder) {
            String cred;
            if (holder == null) {
                FileWidget.$$$reportNull$$$0(4);
            }
            if (StringUtil.isNotEmpty((String)(cred = holder.getParameter(CloudSpannerFileAuthProvider.CREDENTIALS)))) {
                this.getField().setText(cred);
            }
        }

        public void updateUrl(@NotNull MutableParametersHolder model) {
            if (model == null) {
                FileWidget.$$$reportNull$$$0(5);
            }
            model.setParameter(CloudSpannerFileAuthProvider.CREDENTIALS, "");
        }

        public void onChanged(final @NotNull Runnable r) {
            if (r == null) {
                FileWidget.$$$reportNull$$$0(6);
            }
            this.getField().getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e2) {
                    if (e2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    r.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dialects/generic/CloudSpannerFileAuthProvider$FileWidget$1", "textChanged"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/generic/CloudSpannerFileAuthProvider$FileWidget";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/generic/CloudSpannerFileAuthProvider$FileWidget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredFocusedComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFromUrl";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "updateUrl";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "onChanged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

