/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.naming;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.AbstractNamingService;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.util.Casing;
import com.intellij.util.Function;
import com.intellij.util.containers.FactoryMap;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/generic/naming/GenericNamingService;", "Lcom/intellij/database/dialects/base/generator/AbstractNamingService;", "dbms", "Lcom/intellij/database/Dbms;", "casing", "Lcom/intellij/database/util/Casing;", "(Lcom/intellij/database/Dbms;Lcom/intellij/database/util/Casing;)V", "isPure", "", "name", "", "Provider", "intellij.database.dialects.generic"})
public final class GenericNamingService
extends AbstractNamingService {
    @Override
    public boolean isPure(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.getCasing().plain == this.getCasing().quoted ? this.isPlain(name2) : super.isPure(name2);
    }

    public GenericNamingService(@NotNull Dbms dbms, @NotNull Casing casing) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)casing, (String)"casing");
        Pattern pattern = Pattern.compile("\\p{IsAlphabetic}[\\p{IsAlphabetic}\\d_]*");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\"\"\"\\p{Is\u2026\\p{IsAlphabetic}\\d_]*\"\"\")");
        super(dbms, pattern, casing);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006RV\u0010\u0007\u001aJ\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b \n*#\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b0\r\u00a2\u0006\u0002\b\f0\b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/generic/naming/GenericNamingService$Provider;", "Lcom/intellij/database/script/generator/NamingService$Provider;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "generics", "", "Lcom/intellij/database/util/Casing;", "kotlin.jvm.PlatformType", "Lcom/intellij/database/script/generator/NamingService;", "Lorg/jetbrains/annotations/NotNull;", "", "getNamingService", "model", "Lcom/intellij/database/model/basic/BasicModel;", "database", "Lcom/intellij/database/model/basic/BasicDatabase;", "intellij.database.dialects.generic"})
    public static final class Provider
    implements NamingService.Provider {
        private final Map<Casing, NamingService> generics;
        @NotNull
        private final Dbms dbms;

        @NotNull
        public NamingService getNamingService(@Nullable BasicModel model, @Nullable BasicDatabase database) {
            BasicModel basicModel = model;
            if (basicModel == null || (basicModel = basicModel.getRoot()) == null || (basicModel = basicModel.getDefaultCasing()) == null) {
                basicModel = CasingProvider.MIXED_CASING;
            }
            NamingService namingService = this.generics.get(basicModel);
            Intrinsics.checkNotNull((Object)namingService);
            return namingService;
        }

        @NotNull
        public final Dbms getDbms() {
            return this.dbms;
        }

        public Provider(@NotNull Dbms dbms) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            this.dbms = dbms;
            Map map2 = FactoryMap.create((Function)new Function(this){
                final /* synthetic */ Provider this$0;

                public final NamingService fun(Casing it) {
                    Dbms dbms = this.this$0.getDbms();
                    Casing casing = it;
                    Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"it");
                    return new GenericNamingService(dbms, casing);
                }
                {
                    this.this$0 = provider;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"FactoryMap.create<Casing\u2026NamingService(dbms, it) }");
            this.generics = map2;
        }
    }
}

