/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.dialects.mongo.js.psi.resolve.MongoJSResolveHelper;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSMethod;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSSymbol;
import com.intellij.sql.dialects.mongo.js.psi.resolve.types.MongoJSType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoDialect
extends AbstractDatabaseDialect {
    public MongoDialect() {
        super(new TypeHelper(){

            @Override
            public String getTypeName(int code, int length, int precision, int scale) {
                return null;
            }
        });
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MONGO;
        if (dbms == null) {
            MongoDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "MongoDB";
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            MongoDialect.$$$reportNull$$$0(1);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().catToScript(current.getDisplayName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", schema);
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            MongoDialect.$$$reportNull$$$0(2);
        }
        if (sequence == null) {
            MongoDialect.$$$reportNull$$$0(3);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            MongoDialect.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            MongoDialect.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    public boolean supportsViewDefinition() {
        return false;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return false;
    }

    @Override
    public boolean triggersIntrospection(@NotNull PsiElement element) {
        ResolveResult[] results;
        boolean isDatabaseMember;
        PsiElement qualifier;
        if (element == null) {
            MongoDialect.$$$reportNull$$$0(6);
        }
        if (super.triggersIntrospection(element)) {
            return true;
        }
        MongoJSResolveHelper helper = MongoJSResolveHelper.Companion.getInstance(element);
        if (helper == null) {
            return false;
        }
        if (!helper.isCalleeReference(element)) {
            return false;
        }
        PsiReference reference = element.getReference();
        if (!(reference instanceof PsiPolyVariantReference)) {
            return false;
        }
        PsiElement psiElement = qualifier = reference instanceof PsiQualifiedReference ? ((PsiQualifiedReference)reference).getQualifier() : null;
        if (qualifier == null) {
            return false;
        }
        MongoJSType type = helper.getMongoType(qualifier);
        boolean isCollectionMember = type == MongoJSType.COLLECTION;
        boolean bl = isDatabaseMember = type == MongoJSType.DATABASE;
        if (!isCollectionMember && !isDatabaseMember) {
            return false;
        }
        for (ResolveResult result2 : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
            String name2;
            MongoJSSymbol symbol = helper.getSymbol(result2);
            String string = name2 = symbol != null ? symbol.getName() : "";
            if (isCollectionMember && symbol instanceof MongoJSMethod && (name2.startsWith("insert") || name2.equals("drop"))) {
                return true;
            }
            if (!isDatabaseMember || !(symbol instanceof MongoJSMethod) || !name2.startsWith("create") && !name2.equals("dropDatabase")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        DasObject schema;
        if (identifier == null) {
            MongoDialect.$$$reportNull$$$0(7);
        }
        if (qualifier == null) {
            MongoDialect.$$$reportNull$$$0(8);
        }
        DdlBuilder ddlBuilder = (schema = DasUtil.getSchemaObject((DasObject)qualifier)) == null ? builder : builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            MongoDialect.$$$reportNull$$$0(9);
        }
        return ddlBuilder;
    }

    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnectionCore connection) {
        if (system == null) {
            MongoDialect.$$$reportNull$$$0(10);
        }
        if (connection == null) {
            MongoDialect.$$$reportNull$$$0(11);
        }
        RemoteConnection remoteConnection = connection.getRemoteConnection();
        String schema = (String)JdbcNativeUtil.computeSafe(() -> ((RemoteConnection)remoteConnection).getSchema());
        return schema == null ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)StringUtil.notNullize((String)schema), (ObjectKind)ObjectKind.SCHEMA));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mongo/MongoDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mongo/MongoDialect";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "triggersIntrospection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

