/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.ssrp;

import com.intellij.database.dialects.mssql.ssrp.SsrpConstants;
import com.intellij.database.dialects.mssql.ssrp.SsrpNet;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SsrpInfo {
    public static final String SERVER_NAME = "ServerName";
    public static final String SSRP_ERROR = "SsrpError";
    public static final String INSTANCE_NAME = "InstanceName";
    public static final String SSRP_ERROR_UNKNOWN_HOST = "UnknownHost";
    public static final String SSRP_ERROR_NO_RESPONSE = "NoResponse";
    public static final String PORT = "tcp";
    public static final String PIPE = "np";
    public static final String VERSION = "Version";
    private final Map<String, SsrpServer> myServers;
    private final Map<String, SsrpServer> myAliases;

    public SsrpInfo(@Nullable SsrpInfo info, @NotNull Set<String> except) {
        if (except == null) {
            SsrpInfo.$$$reportNull$$$0(0);
        }
        this.myServers = CollectionFactory.createCaseInsensitiveStringMap();
        this.myAliases = CollectionFactory.createCaseInsensitiveStringMap();
        if (info == null) {
            return;
        }
        HashMap<SsrpServer, SsrpServer> clones = new HashMap<SsrpServer, SsrpServer>();
        for (Map.Entry<String, SsrpServer> entry : info.myServers.entrySet()) {
            if (except.contains(entry.getKey())) continue;
            SsrpServer newServer = new SsrpServer(entry.getValue());
            clones.put(entry.getValue(), newServer);
            this.myServers.put(entry.getKey(), newServer);
        }
        for (Map.Entry<String, SsrpServer> entry : info.myServers.entrySet()) {
            SsrpServer server = (SsrpServer)clones.get(entry.getValue());
            if (server == null) continue;
            this.myServers.put(entry.getKey(), server);
        }
    }

    public SsrpInfo() {
        this.myServers = CollectionFactory.createCaseInsensitiveStringMap();
        this.myAliases = CollectionFactory.createCaseInsensitiveStringMap();
    }

    @NotNull
    public List<SsrpServer> merge(@NotNull SsrpNet.Response resp) throws SsrpConstants.SsrpException {
        if (resp == null) {
            SsrpInfo.$$$reportNull$$$0(1);
        }
        List<SsrpServer> servers = this.merge(resp.response);
        String a1 = resp.host;
        String a2 = resp.addr == null ? null : resp.addr.getHostAddress();
        for (String alias : JBIterable.of((Object[])new String[]{a1, a2}).filter(Conditions.notNull())) {
            for (SsrpServer server : servers) {
                if (server.getName().equalsIgnoreCase(alias)) continue;
                this.myAliases.put(alias, server);
            }
        }
        List<SsrpServer> list = servers;
        if (list == null) {
            SsrpInfo.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<SsrpServer> merge(@NotNull String str) throws SsrpConstants.SsrpException {
        if (str == null) {
            SsrpInfo.$$$reportNull$$$0(3);
        }
        SmartList res2 = new SmartList();
        for (String inst : str.split(";;")) {
            SsrpServer server;
            String[] split = inst.split(";");
            if (split.length < 2) continue;
            if (!split[0].equals(SERVER_NAME)) {
                SsrpInfo.expected(SERVER_NAME, new String[]{str, inst});
            }
            if ((server = this.myServers.get(split[1])) == null) {
                server = new SsrpServer(split[1]);
                this.myServers.put(split[1], server);
            }
            server.merge(split);
            res2.add(server);
        }
        SmartList smartList = res2;
        if (smartList == null) {
            SsrpInfo.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    public static Set<String> extractServers(@NotNull String str) {
        if (str == null) {
            SsrpInfo.$$$reportNull$$$0(5);
        }
        HashSet<String> res2 = new HashSet<String>();
        for (String inst : str.split(";;")) {
            String[] split = inst.split(";");
            if (split.length < 2 || !split[0].equals(SERVER_NAME)) continue;
            res2.add(split[1]);
        }
        return res2;
    }

    @NotNull
    public Collection<SsrpServer> getServers() {
        Collection<SsrpServer> collection = this.myServers.values();
        if (collection == null) {
            SsrpInfo.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Nullable
    public SsrpServer getServer(@NotNull String server) {
        SsrpServer res2;
        if (server == null) {
            SsrpInfo.$$$reportNull$$$0(7);
        }
        if ((res2 = this.myServers.get(server)) == null) {
            res2 = this.myAliases.get(server);
        }
        return res2;
    }

    @Contract(value="_,_->fail")
    private static void expected(@NotNull String s, @NotNull String[] split) throws SsrpConstants.SsrpException {
        if (s == null) {
            SsrpInfo.$$$reportNull$$$0(8);
        }
        if (split == null) {
            SsrpInfo.$$$reportNull$$$0(9);
        }
        throw new SsrpConstants.SsrpException("Expected " + s + " in `" + StringUtil.join((String[])split, (String)";") + "`");
    }

    @NotNull
    public static String concat(String ... strs) {
        if (strs == null) {
            SsrpInfo.$$$reportNull$$$0(10);
        }
        String string = StringUtil.join((Object[])strs, s -> StringUtil.isEmpty((String)s) ? " " : s, (String)";");
        if (string == null) {
            SsrpInfo.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "except";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resp";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/ssrp/SsrpInfo";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "split";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/ssrp/SsrpInfo";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getServers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractServers";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getServer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "expected";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SsrpInstance {
        private String myName;
        private final Map<String, String> myAttributes;

        public SsrpInstance(@NotNull String name2) {
            if (name2 == null) {
                SsrpInstance.$$$reportNull$$$0(0);
            }
            this.myAttributes = new HashMap<String, String>();
            this.myName = name2;
        }

        public SsrpInstance(@NotNull SsrpInstance other) {
            if (other == null) {
                SsrpInstance.$$$reportNull$$$0(1);
            }
            this.myAttributes = new HashMap<String, String>();
            this.myName = other.myName;
            this.myAttributes.putAll(other.myAttributes);
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                SsrpInstance.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void setName(@NotNull String name2) {
            if (name2 == null) {
                SsrpInstance.$$$reportNull$$$0(3);
            }
            this.myName = name2;
        }

        @Nullable
        public String getAttribute(@NotNull String name2) {
            if (name2 == null) {
                SsrpInstance.$$$reportNull$$$0(4);
            }
            return this.myAttributes.get(name2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/mssql/ssrp/SsrpInfo$SsrpInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/mssql/ssrp/SsrpInfo$SsrpInstance";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttribute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class SsrpServer {
        private String myName;
        private String myError;
        private final Map<String, SsrpInstance> myInstances;

        public SsrpServer(@NotNull String name2) {
            if (name2 == null) {
                SsrpServer.$$$reportNull$$$0(0);
            }
            this.myInstances = new TreeMap<String, SsrpInstance>();
            this.myName = name2;
        }

        public SsrpServer(@NotNull SsrpServer other) {
            if (other == null) {
                SsrpServer.$$$reportNull$$$0(1);
            }
            this.myInstances = new TreeMap<String, SsrpInstance>();
            this.myName = other.myName;
            this.myError = other.myError;
            for (Map.Entry<String, SsrpInstance> entry : other.myInstances.entrySet()) {
                this.myInstances.put(entry.getKey(), new SsrpInstance(entry.getValue()));
            }
        }

        public void setName(@NotNull String name2) {
            if (name2 == null) {
                SsrpServer.$$$reportNull$$$0(2);
            }
            this.myName = name2;
        }

        private void merge(String @NotNull [] split) throws SsrpConstants.SsrpException {
            if (split == null) {
                SsrpServer.$$$reportNull$$$0(3);
            }
            if (split.length >= 4 && split[2].equals(SsrpInfo.SSRP_ERROR)) {
                this.myError = split[3];
                return;
            }
            if (split.length < 4 || !split[2].equals(SsrpInfo.INSTANCE_NAME)) {
                SsrpInfo.expected(SsrpInfo.INSTANCE_NAME, split);
            }
            SsrpInstance instance = new SsrpInstance(split[3]);
            int i2 = 4;
            while (i2 + 1 < split.length) {
                instance.myAttributes.put(split[i2], split[i2 + 1]);
                ++i2;
            }
            this.myInstances.put(split[3], instance);
            this.myError = null;
        }

        @Nullable
        public String getError() {
            return this.myError;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                SsrpServer.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public Collection<SsrpInstance> getInstances() {
            Collection<SsrpInstance> collection = this.myInstances.values();
            if (collection == null) {
                SsrpServer.$$$reportNull$$$0(5);
            }
            return collection;
        }

        @Nullable
        public SsrpInstance getInstance(@NotNull String instance) {
            if (instance == null) {
                SsrpServer.$$$reportNull$$$0(6);
            }
            return this.myInstances.get(instance);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "split";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/mssql/ssrp/SsrpInfo$SsrpServer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/mssql/ssrp/SsrpInfo$SsrpServer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstances";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getInstance";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

