/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.oracle.generator.OraRoutineArgumentsAnalyzer;
import com.intellij.database.dialects.oracle.model.OraArgument;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.run.actions.RoutineExecutionHelper;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraRoutineExecutionHelper
implements RoutineExecutionHelper {
    @Nullable
    public DataRequest makeRequest(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataRequest.OwnerEx owner, @NotNull String script, @NotNull BasicRoutine routine2, @Nullable SearchPath path) {
        if (project == null) {
            OraRoutineExecutionHelper.$$$reportNull$$$0(0);
        }
        if (dataSource == null) {
            OraRoutineExecutionHelper.$$$reportNull$$$0(1);
        }
        if (owner == null) {
            OraRoutineExecutionHelper.$$$reportNull$$$0(2);
        }
        if (script == null) {
            OraRoutineExecutionHelper.$$$reportNull$$$0(3);
        }
        if (routine2 == null) {
            OraRoutineExecutionHelper.$$$reportNull$$$0(4);
        }
        OraRoutineArgumentsAnalyzer analyzer = new OraRoutineArgumentsAnalyzer((OraRoutine)routine2);
        Version version = dataSource.getVersion();
        List<OraArgument> arguments = analyzer.getCursorArguments();
        List<OraRoutineArgumentsAnalyzer.PrimitivesPack> packs = analyzer.getPrimitives(version);
        List<OraArgument> sqlArrays = analyzer.getSqlTypeArrayArguments();
        List<OraArgument> plArrays = analyzer.getPlTypeArrayArguments();
        List<OraArgument> sqlTables = analyzer.getSqlTypeNestedTableArguments();
        List<OraArgument> plTables = analyzer.getPlTypeArrayArguments();
        int primitiveCursors = packs.stream().mapToInt(p -> p.getEnabled() ? 1 : 0).sum();
        int plTypesCursors = OraRoutineArgumentsAnalyzer.supportPlTypesInSql(version) ? plArrays.size() + plTables.size() : 0;
        int count = arguments.size() + sqlArrays.size() + sqlTables.size() + plTypesCursors + primitiveCursors;
        ArrayList<CallableStatementData.SimpleOutParameter> outParameters = new ArrayList<CallableStatementData.SimpleOutParameter>();
        for (int i2 = 1; i2 <= count; ++i2) {
            outParameters.add(new CallableStatementData.SimpleOutParameter(i2, -10));
        }
        DataRequest.CallRequest.Statement statement = new DataRequest.CallRequest.Statement(script, outParameters);
        List<DataRequest.CallRequest.Statement> statements2 = Collections.singletonList(statement);
        return DataRequest.newCallRequest((DataRequest.OwnerEx)owner, statements2, (SearchPath)path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "owner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "script";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "routine";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/oracle/generator/OraRoutineExecutionHelper";
        objectArray[2] = "makeRequest";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

