/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.MetaNode;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.MultiMap;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraRawPlanData
extends RawPlanData {
    private static final String DEFAULT_PLAN_TABLE = "PLAN_TABLE";
    public MetaNode<MetaData> plan;

    @Override
    public void load(@NotNull DatabaseConnectionCore connection, final @NotNull String statement, boolean run2) {
        if (connection == null) {
            OraRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            OraRawPlanData.$$$reportNull$$$0(1);
        }
        this.plan = null;
        final MultiMap childMap = MultiMap.createLinked();
        final Ref root2 = Ref.create();
        OraRawPlanData.useStatementWithPreserved(connection, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> s) throws PlanRetrievalException, SQLException {
                String uuid = AbstractPlanModelBuilder.randomShorterUUID();
                s.barren().execute((Object)("EXPLAIN PLAN SET STATEMENT_ID = '" + uuid + "' INTO \"PLAN_TABLE\" FOR " + statement));
                s.noisy().execute((Object)("SELECT OPERATION, OPTIONS, OBJECT_NAME, OBJECT_TYPE, ID, PARENT_ID, POSITION, COST, CARDINALITY, CPU_COST, IO_COST FROM \"PLAN_TABLE\" WHERE STATEMENT_ID = '" + uuid + "'"), OraRawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> {
                    while (rs.next()) {
                        MetaData nodeData = new MetaData(rs.getString("OPERATION"), rs.getString("OPTIONS"), rs.getString("OBJECT_NAME"), rs.getString("OBJECT_TYPE"), OraRawPlanData.this.getInteger((RemoteResultSet)rs, "ID"), OraRawPlanData.this.getInteger((RemoteResultSet)rs, "PARENT_ID"), OraRawPlanData.this.getInteger((RemoteResultSet)rs, "POSITION"), OraRawPlanData.this.getBig((RemoteResultSet)rs, "COST"), OraRawPlanData.this.getBig((RemoteResultSet)rs, "CARDINALITY"), OraRawPlanData.this.getBig((RemoteResultSet)rs, "CPU_COST"), OraRawPlanData.this.getBig((RemoteResultSet)rs, "IO_COST"));
                        if (nodeData.parentId == null) {
                            root2.set((Object)nodeData);
                            continue;
                        }
                        childMap.putValue((Object)nodeData.parentId, (Object)nodeData);
                    }
                }));
            }
        }, new RawPlanData.StateSaver[0]);
        if (root2.get() == null) {
            throw new PlanRetrievalException("No root operation found");
        }
        this.plan = new Object(){

            public MetaNode<MetaData> fillChildren(MetaNode<MetaData> node) {
                for (MetaData data : childMap.get((Object)((MetaData)node.data).id)) {
                    node.children.add(this.fillChildren((MetaNode<MetaData>)new MetaNode((Object)data)));
                }
                node.children.sort((o1, o2) -> Comparing.compare((Comparable)((MetaData)o1.data).position, (Comparable)((MetaData)o2.data).position));
                return node;
            }
        }.fillChildren((MetaNode<MetaData>)new MetaNode((Object)((MetaData)root2.get())));
    }

    @Nullable
    Integer getInteger(RemoteResultSet resultSet, String col) throws Exception {
        return resultSet.getObject(col) == null ? null : Integer.valueOf(resultSet.getInt(col));
    }

    @Nullable
    BigDecimal getBig(RemoteResultSet resultSet, String col) throws Exception {
        return resultSet.getObject(col) == null ? null : resultSet.getBigDecimal(col);
    }

    @Override
    public void load(@NotNull String dump) {
        if (dump == null) {
            OraRawPlanData.$$$reportNull$$$0(2);
        }
        try {
            this.plan = new Object(){

                private MetaNode<MetaData> visit(JSONObject obj2) throws JSONException {
                    MetaNode node = new MetaNode((Object)new MetaData(obj2.getString("operation"), obj2.optString("options"), obj2.optString("objectName"), obj2.optString("objectType"), obj2.optInt("id"), obj2.optInt("parentId"), obj2.optInt("position"), AbstractPlanModelBuilder.optBig(obj2, "cost", null), AbstractPlanModelBuilder.optBig(obj2, "cardinality", null), AbstractPlanModelBuilder.optBig(obj2, "cpuCost", null), AbstractPlanModelBuilder.optBig(obj2, "ioCost", null)));
                    JSONArray children2 = obj2.optJSONArray("children");
                    if (children2 != null) {
                        int e2 = children2.length();
                        for (int i2 = 0; i2 < e2; ++i2) {
                            node.children.add(this.visit(children2.getJSONObject(i2)));
                        }
                    }
                    return node;
                }
            }.visit(new JSONObject(dump));
        }
        catch (JSONException e2) {
            throw new PlanRetrievalException("Load failed", (Throwable)e2);
        }
    }

    @Override
    public String dump() {
        try {
            return new Object(){

                private JSONObject visit(MetaNode<MetaData> node) throws JSONException {
                    JSONObject res2 = new JSONObject();
                    res2.put("operation", (Object)((MetaData)node.data).operation);
                    res2.put("options", (Object)((MetaData)node.data).options);
                    res2.put("objectName", (Object)((MetaData)node.data).objectName);
                    res2.put("objectType", (Object)((MetaData)node.data).objectType);
                    res2.put("cardinality", (Object)((MetaData)node.data).cardinality);
                    res2.put("cost", (Object)((MetaData)node.data).cost);
                    res2.put("cpuCost", (Object)((MetaData)node.data).cpuCost);
                    res2.put("ioCost", (Object)((MetaData)node.data).ioCost);
                    res2.put("id", (Object)((MetaData)node.data).id);
                    res2.put("parentId", (Object)((MetaData)node.data).parentId);
                    res2.put("position", (Object)((MetaData)node.data).position);
                    if (!node.children.isEmpty()) {
                        JSONArray children2 = new JSONArray();
                        for (MetaNode child : node.children) {
                            children2.put((Object)this.visit((MetaNode<MetaData>)child));
                        }
                        res2.put("children", (Object)children2);
                    }
                    return res2;
                }
            }.visit(this.plan).toString(2);
        }
        catch (JSONException e2) {
            throw new PlanRetrievalException("Dump failed", (Throwable)e2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/oracle/plan/OraRawPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class MetaData {
        public final String operation;
        public final String options;
        public final String objectName;
        public final String objectType;
        public final Integer id;
        public final Integer parentId;
        public final Integer position;
        public final BigDecimal cardinality;
        public final BigDecimal cost;
        public final BigDecimal cpuCost;
        public final BigDecimal ioCost;

        private MetaData(String operation2, String options2, String objectName, String objectType, Integer id, Integer parentId, Integer position, BigDecimal cost, BigDecimal cardinality, BigDecimal cpuCost, BigDecimal ioCost) {
            this.operation = operation2;
            this.options = options2;
            this.objectName = objectName;
            this.objectType = objectType;
            this.id = id;
            this.parentId = parentId;
            this.position = position;
            this.cost = cost;
            this.cardinality = cardinality;
            this.cpuCost = cpuCost;
            this.ioCost = ioCost;
        }
    }
}

