/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectWithOwner;
import com.intellij.database.dialects.postgresbase.model.PgBaseOperator;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.properties.PgOperatorKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgRoutineKind;
import com.intellij.database.dialects.postgresbase.model.properties.PgVolatilityKind;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateCatalogStatement;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceExpressionImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlNamedStubElementType;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001dH\u0004\u00a2\u0006\u0002\u0010\u001eJB\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001d2\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001d0#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020!0#H\u0004J\u0014\u0010%\u001a\u0004\u0018\u00010!2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001dH\u0004J$\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0014\u00102\u001a\u0004\u0018\u00010!2\b\u0010\u000b\u001a\u0004\u0018\u000103H\u0002J\u0014\u00104\u001a\u0004\u0018\u00010!2\b\u0010\u000b\u001a\u0004\u0018\u000103H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010!2\u0006\u0010\u000b\u001a\u000203H\u0002J\u0018\u00106\u001a\u00020\b2\u0006\u0010\t\u001a\u0002072\u0006\u0010\u000b\u001a\u000208H\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00069"}, d2={"Lcom/intellij/database/dialects/postgresbase/PgBaseObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "lazyCodeBlock", "Lcom/intellij/psi/tree/IElementType;", "getLazyCodeBlock", "()Lcom/intellij/psi/tree/IElementType;", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "Lcom/intellij/sql/psi/SqlElement;", "buildDatabase", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;", "buildOperator", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseOperator;", "buildRoutine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "buildRoutineKind", "buildRoutineSources", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "findNumberInSiblings", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Float;", "findOptions", "", "", "nextElement", "Lkotlin/Function1;", "optionFormatter", "findSchemaInSiblings", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/script/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "getPgOperatorKind", "Lcom/intellij/database/dialects/postgresbase/model/properties/PgOperatorKind;", "n", "Lcom/intellij/database/model/DasOperator$OperatorNotation;", "getRoutineArgumentsDefinition", "Lcom/intellij/sql/psi/SqlCreateProcedureStatement;", "getRoutineResultDefinition", "getRoutineSourceText", "retrieveOwner", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseObjectWithOwner;", "Lcom/intellij/sql/psi/SqlAlterStatement;", "intellij.database.dialects.postgresbase"})
public abstract class PgBaseObjectBuilder
extends SqlObjectBuilderImpl {
    @Nullable
    protected abstract IElementType getLazyCodeBlock();

    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof PgBaseOperator) {
            this.buildOperator((PgBaseOperator)obj2, source, context);
        } else if (basicModElement instanceof PgBaseDatabase) {
            this.buildDatabase((PgBaseDatabase)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull SqlElement source) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (obj2 instanceof PgBaseObjectWithOwner && source instanceof SqlAlterStatement) {
            this.retrieveOwner((PgBaseObjectWithOwner)obj2, (SqlAlterStatement)source);
        } else {
            super.build(obj2, source);
        }
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.RULE) ? this.getTriggerBodyRange(def) : super.getCompactDefinition(path, text, def);
    }

    private final void retrieveOwner(PgBaseObjectWithOwner obj2, SqlAlterStatement source) {
        String ownerName = null;
        boolean faceless = false;
        JBIterable jBIterable = SqlImplUtil.childrenIt((PsiElement)((PsiElement)source));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil.childrenIt(source)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it);
            if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlElementTypes.SQL_ALTER_INSTRUCTION)) continue;
            JBIterable jBIterable2 = SqlImplUtil.childrenIt((PsiElement)it);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"SqlImplUtil.childrenIt(it)");
            Iterable $this$forEach$iv2 = (Iterable)jBIterable2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PsiElement ownerPsi;
                PsiElement psiElement;
                StubElement stub;
                PsiElement alterChild = (PsiElement)element$iv2;
                boolean bl2 = false;
                IElementType iElementType2 = PsiTreeUtilKt.getElementType((PsiElement)alterChild);
                if (!Intrinsics.areEqual((Object)iElementType2, (Object)SqlElementTypes.SQL_OWNER_TO_CLAUSE)) continue;
                PsiElement psiElement2 = alterChild;
                if (!(psiElement2 instanceof SqlStubbedElement)) {
                    psiElement2 = null;
                }
                SqlStubbedElement sqlStubbedElement = (SqlStubbedElement)psiElement2;
                Object object = stub = sqlStubbedElement != null ? sqlStubbedElement.getStub() : null;
                if (stub != null) {
                    SqlReferenceExpression sqlReferenceExpression;
                    StubElement stubElement = stub;
                    if (!(stubElement instanceof SqlNamedElementStub)) {
                        stubElement = null;
                    }
                    SqlNamedElementStub sqlNamedElementStub = (SqlNamedElementStub)stubElement;
                    if (sqlNamedElementStub != null) {
                        IStubElementType iStubElementType = ((SqlNamedElementStub)stub).getStubType();
                        if (iStubElementType == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.stubs.SqlNamedStubElementType<com.intellij.psi.stubs.StubElement<*>!, com.intellij.psi.PsiElement!>");
                        }
                        sqlReferenceExpression = sqlNamedElementStub.getNameReference(((SqlNamedStubElementType)iStubElementType).getTargetReferenceType());
                    } else {
                        sqlReferenceExpression = null;
                    }
                    psiElement = (PsiElement)sqlReferenceExpression;
                } else {
                    IElementType iElementType3 = PgTypes.PG_TO;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"PgTypes.PG_TO");
                    PsiElement to = this.findChild(alterChild, iElementType3);
                    SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_USER_REFERENCE;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_USER_REFERENCE");
                    PsiElement psiElement3 = this.findSibling(to, (IElementType)sqlReferenceElementType);
                    if (psiElement3 == null) {
                        IElementType iElementType4 = PgTypes.PG_SESSION_USER;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"PgTypes.PG_SESSION_USER");
                        psiElement3 = psiElement = this.findSibling(to, iElementType4);
                    }
                    if (psiElement3 == null) {
                        IElementType iElementType5 = PgTypes.PG_CURRENT_USER;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType5, (String)"PgTypes.PG_CURRENT_USER");
                        psiElement = this.findSibling(to, iElementType5);
                    }
                }
                PsiElement psiElement4 = ownerPsi = psiElement;
                ownerName = psiElement4 != null ? this.extractName(psiElement4) : null;
                faceless = ownerPsi != null && !(ownerPsi instanceof SqlReferenceExpression);
            }
        }
        if (ownerName != null) {
            obj2.setOwner(ownerName);
            obj2.setFaceless(faceless);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildDatabase(PgBaseDatabase obj2, DasObject source, SqlObjectBuilder.Context context) {
        PgBaseDatabase stubbed;
        BasicElement basicElement;
        SqlObjectBuilderImpl $this$stubbed$iv;
        super.buildNamespace((BasicModNamespace)obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var8_8 = $this$stubbed$iv;
        if (var8_8 instanceof PgBaseDatabase) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_8 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof PgBaseDatabase)) {
                object = null;
            }
            basicElement = (BasicElement)((PgBaseDatabase)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (PgBaseDatabase)basicElement) != null) {
            obj2.setOwner(stubbed.getOwner());
        } else {
            void this_$iv2;
            String ownerName = null;
            $this$stubbed$iv = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateCatalogStatement)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)((SqlCreateCatalogStatement)dasObject2);
            boolean $i$f$forEachChild = false;
            void var9_11 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_OWNER)) continue;
                SqlReferenceElementType sqlReferenceElementType = SqlElementTypes.SQL_USER_REFERENCE;
                Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SqlElementTypes.SQL_USER_REFERENCE");
                PsiElement psiElement2 = this.findSibling(it, (IElementType)sqlReferenceElementType);
                ownerName = psiElement2 != null ? this.extractName(psiElement2) : null;
            }
            obj2.setOwner(ownerName);
        }
    }

    @Override
    protected void buildViewSource(@NotNull BasicModView obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources((BasicModSourceAware)obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ PgBaseObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            @Nullable
            public final CompositeText invoke() {
                return (CompositeText)PgBaseObjectBuilder.access$getViewQuery$s-2018911564(this.this$0, this.$source, CompositeText.Kind.DECOMPILED_TEXT);
            }
            {
                this.this$0 = pgBaseObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildRoutine(@NotNull BasicModRoutine obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        void $this$stubbed$iv$iv;
        void $this$stubbedOrBuild$iv;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PgBaseRoutine cfr_ignored_0 = (PgBaseRoutine)obj2;
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbedOrBuild = false;
        void var8_7 = $this$stubbedOrBuild$iv;
        SqlObjectBuilderImpl this_$iv$iv = this_$iv;
        boolean $i$f$stubbed = false;
        void var11_11 = $this$stubbed$iv$iv;
        if (var11_11 instanceof PgBaseRoutine) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (var11_11 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof PgBaseRoutine)) {
                object = null;
            }
            basicElement = (BasicElement)((PgBaseRoutine)object);
        } else {
            basicElement = null;
        }
        BasicElement basicElement2 = basicElement;
        if (basicElement == null) {
            void this_$iv2;
            BasicElement basicElement3 = ((BasicElement)obj2).getMetaObject().newDataObject();
            if (basicElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.postgresbase.model.PgBaseRoutine");
            }
            BasicElement basicElement4 = (BasicElement)((PgBaseRoutine)basicElement3);
            boolean bl = false;
            boolean bl2 = false;
            PgBaseRoutine $this$stubbedOrBuild = (PgBaseRoutine)basicElement4;
            boolean bl3 = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof SqlCreateProcedureStatement)) {
                dasObject2 = null;
            }
            PsiElement el$iv = (PsiElement)((SqlCreateProcedureStatement)dasObject2);
            boolean $i$f$forEachChild = false;
            void var17_17 = this_$iv2;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement s;
                PsiElement it = tmp$iv$iv;
                boolean bl4 = false;
                PsiElement psiElement2 = s = it.getFirstChild();
                Object object = iElementType = psiElement2 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement2) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_IMMUTABLE)) {
                    $this$stubbedOrBuild.setVolatilityKind(PgVolatilityKind.IMMUTABLE);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_STABLE)) {
                    $this$stubbedOrBuild.setVolatilityKind(PgVolatilityKind.STABLE);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)PgTypes.PG_VOLATILE)) continue;
                $this$stubbedOrBuild.setVolatilityKind(PgVolatilityKind.VOLATILE);
            }
            DasObject dasObject3 = source;
            if (!(dasObject3 instanceof SqlCreateProcedureStatement)) {
                dasObject3 = null;
            }
            $this$stubbedOrBuild.setArgumentsDefinition(this.getRoutineArgumentsDefinition((SqlCreateProcedureStatement)dasObject3));
            DasObject dasObject4 = source;
            if (!(dasObject4 instanceof SqlCreateProcedureStatement)) {
                dasObject4 = null;
            }
            $this$stubbedOrBuild.setResultsDefinition(this.getRoutineResultDefinition((SqlCreateProcedureStatement)dasObject4));
            String string = $this$stubbedOrBuild.getResultsDefinition();
            $this$stubbedOrBuild.setReturnsSet(string != null && StringsKt.contains((CharSequence)string, (CharSequence)"setof ", (boolean)true));
            basicElement2 = basicElement4;
        }
        PgBaseRoutine stubbed = (PgBaseRoutine)basicElement2;
        ((PgBaseRoutine)obj2).setArgumentsDefinition(stubbed.getArgumentsDefinition());
        ((PgBaseRoutine)obj2).setResultsDefinition(stubbed.getResultsDefinition());
        ((PgBaseRoutine)obj2).setVolatilityKind(stubbed.getVolatilityKind());
        ((PgBaseRoutine)obj2).setReturnsSet(stubbed.isReturnsSet());
        super.buildRoutine(obj2, source, context);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void buildRoutineKind(@NotNull BasicModRoutine obj2, @NotNull DasObject source) {
        PgRoutineKind pgRoutineKind;
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DasRoutine.Kind rk = this.extractRoutineKind(source);
        PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)obj2;
        String string = ((PgBaseRoutine)obj2).getResultsDefinition();
        if (string != null && StringsKt.equals((String)string, (String)"trigger", (boolean)true)) {
            pgRoutineKind = PgRoutineKind.PG_TRIGGER;
        } else {
            String string2 = ((PgBaseRoutine)obj2).getResultsDefinition();
            pgRoutineKind = string2 != null && StringsKt.equals((String)string2, (String)"event trigger", (boolean)true) ? PgRoutineKind.PG_EVENT_TRIGGER : (rk == DasRoutine.Kind.PROCEDURE ? PgRoutineKind.PG_PROCEDURE : PgRoutineKind.PG_FUNCTION);
        }
        pgBaseRoutine.setPgRoutineKind(pgRoutineKind);
    }

    @Nullable
    protected final String findSchemaInSiblings(@Nullable PsiElement source) {
        SqlReferenceElementType sqlReferenceElementType = SqlCompositeElementTypes.SQL_SCHEMA_REFERENCE;
        Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"SqlCompositeElementTypes.SQL_SCHEMA_REFERENCE");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlReferenceElementType);
        if (!(psiElement instanceof SqlReferenceExpressionImpl)) {
            psiElement = null;
        }
        SqlReferenceExpressionImpl sqlReferenceExpressionImpl = (SqlReferenceExpressionImpl)psiElement;
        return sqlReferenceExpressionImpl != null ? sqlReferenceExpressionImpl.getName() : null;
    }

    @Nullable
    protected final Float findNumberInSiblings(@Nullable PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findSibling(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toFloatOrNull((String)object) : null;
    }

    @NotNull
    protected final List<String> findOptions(@Nullable PsiElement source, @NotNull Function1<? super PsiElement, ? extends PsiElement> nextElement, @NotNull Function1<? super String, String> optionFormatter) {
        PsiElement leftParen;
        Intrinsics.checkNotNullParameter(nextElement, (String)"nextElement");
        Intrinsics.checkNotNullParameter(optionFormatter, (String)"optionFormatter");
        List result2 = new ArrayList();
        SqlTokenType sqlTokenType = SqlElementTypes.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SqlElementTypes.SQL_LEFT_PAREN");
        PsiElement psiElement = this.findSibling(source, (IElementType)sqlTokenType);
        if (psiElement == null) {
            return result2;
        }
        PsiElement current = leftParen = psiElement;
        while (true) {
            PsiElement psiElement2;
            block7: {
                PsiElement literal;
                PsiElement option;
                PsiElement psiElement3 = current;
                if ((psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null) == null || !(Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)current), (Object)SqlElementTypes.SQL_RIGHT_PAREN) ^ true)) break;
                if ((PsiElement)nextElement.invoke((Object)current) == null) {
                    return result2;
                }
                PsiElement psiElement4 = option.getNextSibling();
                SqlCompositeElementType sqlCompositeElementType = SqlElementTypes.SQL_STRING_LITERAL;
                Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SqlElementTypes.SQL_STRING_LITERAL");
                if (this.findSibling(psiElement4, (IElementType)sqlCompositeElementType) == null) {
                    return result2;
                }
                PsiElement psiElement5 = literal;
                if (psiElement5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.impl.SqlStringLiteralExpressionImpl");
                }
                String literalValue = ((SqlStringLiteralExpressionImpl)psiElement5).getValue();
                if (literalValue != null) {
                    result2.add(option.getText() + "=" + (String)optionFormatter.invoke((Object)literalValue));
                }
                SqlObjectBuilderImpl this_$iv = this;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv = literal; tmp$iv != null; tmp$iv = tmp$iv.getNextSibling()) {
                    PsiElement it = tmp$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)literal) ^ true && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)SqlElementTypes.WHITE_SPACE) ^ true)) continue;
                    psiElement2 = tmp$iv;
                    break block7;
                }
                psiElement2 = null;
            }
            current = psiElement2;
        }
        return result2;
    }

    @Override
    protected void buildRoutineSources(@NotNull BasicModSourceAware obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>(this, source){
            final /* synthetic */ PgBaseObjectBuilder this$0;
            final /* synthetic */ DasObject $source;

            /*
             * Enabled aggressive block sorting
             */
            @Nullable
            public final CompositeText invoke() {
                SimpleCompositeText simpleCompositeText;
                Object object;
                DasObject dasObject = this.$source;
                if (!(dasObject instanceof SqlCreateProcedureStatement)) {
                    dasObject = null;
                }
                if ((object = (SqlCreateProcedureStatement)dasObject) != null) {
                    SqlCreateProcedureStatement sqlCreateProcedureStatement = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    SqlCreateProcedureStatement it = sqlCreateProcedureStatement;
                    boolean bl3 = false;
                    object = PgBaseObjectBuilder.access$getRoutineSourceText(this.this$0, it);
                    if (object != null) {
                        simpleCompositeText = SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null);
                        return (CompositeText)simpleCompositeText;
                    }
                }
                simpleCompositeText = null;
                return (CompositeText)simpleCompositeText;
            }
            {
                this.this$0 = pgBaseObjectBuilder;
                this.$source = dasObject;
                super(0);
            }
        }));
    }

    private final String getRoutineArgumentsDefinition(SqlCreateProcedureStatement source) {
        PsiElement rParen;
        PsiElement lParen;
        PsiElement params2;
        block7: {
            block6: {
                PsiElement psiElement = (PsiElement)source;
                IElementType iElementType = PgTypes.PG_PARAMETER_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PgTypes.PG_PARAMETER_LIST");
                PsiElement psiElement2 = this.findChild(psiElement, iElementType);
                if (psiElement2 == null) {
                    return null;
                }
                params2 = psiElement2;
                lParen = params2.getFirstChild();
                rParen = params2.getLastChild();
                PsiElement psiElement3 = lParen;
                if (Intrinsics.areEqual((Object)(psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null), (Object)PgTypes.PG_LEFT_PAREN) ^ true) break block6;
                PsiElement psiElement4 = rParen;
                if (!(Intrinsics.areEqual((Object)(psiElement4 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement4) : null), (Object)PgTypes.PG_RIGHT_PAREN) ^ true)) break block7;
            }
            return null;
        }
        String string = params2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.text");
        String string2 = string;
        PsiElement psiElement = lParen;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"lParen");
        int n = psiElement.getStartOffsetInParent() + lParen.getTextLength();
        PsiElement psiElement5 = rParen;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"rParen");
        int n2 = psiElement5.getStartOffsetInParent();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string2 = string4;
        n = 0;
        String string5 = string2;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string5)).toString(), (boolean)false, (int)1, null);
    }

    private final String getRoutineResultDefinition(SqlCreateProcedureStatement source) {
        PsiElement returns;
        PsiElement psiElement = (PsiElement)source;
        IElementType iElementType = PgTypes.PG_RETURNS_CLAUSE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PgTypes.PG_RETURNS_CLAUSE");
        PsiElement psiElement2 = this.findChild(psiElement, iElementType);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement params2 = psiElement2;
        PsiElement psiElement3 = returns = params2.getFirstChild();
        if (Intrinsics.areEqual((Object)(psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null), (Object)PgTypes.PG_RETURNS) ^ true) {
            return null;
        }
        String string = params2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.text");
        String string2 = string;
        PsiElement psiElement4 = returns;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"returns");
        int n = psiElement4.getStartOffsetInParent() + returns.getTextLength();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        string2 = string4;
        n = 0;
        String string5 = string2;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string5)).toString(), (boolean)false, (int)1, null);
    }

    private final String getRoutineSourceText(SqlCreateProcedureStatement source) {
        String string;
        String string2;
        Object object;
        PsiElement code;
        PsiElement psiElement;
        block12: {
            PsiElement psiElement2 = (PsiElement)source;
            IElementType iElementType = PgElementTypes.Misc.PG_LAZY_CODE_BLOCK_PARENT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PgElementTypes.Misc.PG_LAZY_CODE_BLOCK_PARENT");
            PsiElement psiElement3 = this.findChild(psiElement2, iElementType);
            if (psiElement3 == null) {
                PsiElement psiElement4;
                block11: {
                    SqlObjectBuilderImpl this_$iv = this;
                    boolean $i$f$findChild = false;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
                    PsiElement psiElement5 = (PsiElement)source;
                    PsiElement element$iv$iv = psiElement5 != null ? psiElement5.getFirstChild() : null;
                    boolean $i$f$findSibling = false;
                    for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        PsiElement it$iv = tmp$iv$iv;
                        boolean bl = false;
                        if (!(it$iv instanceof SqlStringLiteralExpression)) continue;
                        psiElement4 = tmp$iv$iv;
                        break block11;
                    }
                    psiElement4 = null;
                }
                SqlStringLiteralExpression sqlStringLiteralExpression = (SqlStringLiteralExpression)psiElement4;
                return sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
            }
            PsiElement block = psiElement3;
            SqlObjectBuilderImpl this_$iv = this;
            boolean $i$f$findChild = false;
            SqlObjectBuilderImpl element$iv$iv = this_$iv;
            PsiElement psiElement6 = block;
            PsiElement element$iv$iv2 = psiElement6 != null ? psiElement6.getFirstChild() : null;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv2; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                IElementType type = PsiTreeUtilKt.getElementType((PsiElement)it);
                if (!(Intrinsics.areEqual((Object)type, (Object)this.getLazyCodeBlock()) || Intrinsics.areEqual((Object)type, (Object)SqlElementTypes.SQL_STRING_LITERAL))) continue;
                psiElement = tmp$iv$iv;
                break block12;
            }
            psiElement = null;
        }
        PsiElement psiElement7 = code = psiElement;
        Object object2 = object = psiElement7 != null ? PsiTreeUtilKt.getElementType(psiElement7) : null;
        if (Intrinsics.areEqual((Object)object, (Object)this.getLazyCodeBlock())) {
            PsiElement psiElement8 = code;
            string2 = psiElement8 != null ? psiElement8.getText() : null;
        } else if (Intrinsics.areEqual((Object)object, (Object)SqlElementTypes.SQL_STRING_LITERAL)) {
            PsiElement psiElement9 = code;
            if (psiElement9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.SqlStringLiteralExpression");
            }
            string2 = ((SqlStringLiteralExpression)psiElement9).getValue();
        } else {
            string2 = null;
        }
        if (string2 != null) {
            object = string2;
            boolean bl = false;
            Object object3 = object;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trimStart((CharSequence)((CharSequence)object3))).toString();
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void buildOperator(PgBaseOperator obj, DasObject source, SqlObjectBuilder.Context context) {
        block23: {
            block20: {
                block22: {
                    this.buildBasicElement((BasicModElement)obj, source, context);
                    var6_4 = source;
                    this_$iv = this;
                    $i$f$stubbed = false;
                    var8_10 = $this$stubbed$iv;
                    if (var8_10 instanceof PgBaseOperator) {
                        v0 = (BasicElement)$this$stubbed$iv;
                    } else if (var8_10 instanceof SqlStubbedElement) {
                        v1 = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                        if (!(v1 instanceof SqlDefinitionStub)) {
                            v1 = null;
                        }
                        v2 = (SqlDefinitionStub)v1;
                        v3 /* !! */  = v2 != null ? v2.getElement() : null;
                        if (!(v3 /* !! */  instanceof PgBaseOperator)) {
                            v3 /* !! */  = null;
                        }
                        v0 = (BasicElement)((PgBaseOperator)v3 /* !! */ );
                    } else {
                        v0 = null;
                    }
                    if ((stubbed = (PgBaseOperator)v0) == null) break block22;
                    obj.setLeftType(stubbed.getLeftType());
                    obj.setRightType(stubbed.getRightType());
                    obj.setOperatorKind(stubbed.getOperatorKind());
                    obj.setCallRoutineName(stubbed.getCallRoutineName());
                    break block23;
                }
                v4 = source;
                if (!(v4 instanceof DasOperator)) {
                    v4 = null;
                }
                if ((v5 /* !! */  = (op = (DasOperator)v4)) == null || (v5 /* !! */  = v5 /* !! */ .getArgumentTypes()) == null || (v5 /* !! */  = (DataType)CollectionsKt.getOrNull((List)v5 /* !! */ , (int)0)) == null) {
                    v6 = DataType.UNKNOWN;
                    v5 /* !! */  = v6;
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"DataType.UNKNOWN");
                }
                obj.setLeftType((DataType)v5 /* !! */ );
                v7 /* !! */  = op;
                if (v7 /* !! */  == null || (v7 /* !! */  = v7 /* !! */ .getArgumentTypes()) == null || (v7 /* !! */  = (DataType)CollectionsKt.getOrNull((List)v7 /* !! */ , (int)1)) == null) {
                    v8 = DataType.UNKNOWN;
                    v7 /* !! */  = v8;
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"DataType.UNKNOWN");
                }
                obj.setRightType((DataType)v7 /* !! */ );
                v9 = op;
                if (v9 == null || (v9 = v9.getOperatorNotation()) == null) {
                    v9 = DasOperator.OperatorNotation.INFIX;
                }
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"op?.operatorNotation ?: \u2026or.OperatorNotation.INFIX");
                obj.setOperatorKind(this.getPgOperatorKind((DasOperator.OperatorNotation)v9));
                $this$stubbed$iv = this;
                v10 = source;
                if (!(v10 instanceof PsiElement)) {
                    v10 = null;
                }
                $i$f$stubbed = (PsiElement)v10;
                var19_13 = obj;
                $i$f$findChild = false;
                var9_14 = this_$iv;
                v11 = el$iv;
                element$iv$iv = v11 != null ? v11.getFirstChild() : null;
                $i$f$findSibling = false;
                for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    it /* !! */  = tmp$iv$iv;
                    $i$a$-findChild-PgBaseObjectBuilder$buildOperator$1 = false;
                    if (!(it /* !! */  instanceof SqlClause)) ** GOTO lbl-1000
                    v12 = ((SqlClause)it /* !! */ ).getFirstChild();
                    if (Intrinsics.areEqual((Object)(v12 != null ? PsiTreeUtilKt.getElementType((PsiElement)v12) : null), (Object)PgTypes.PG_PROCEDURE)) {
                        v13 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v13 = false;
                    }
                    if (!v13) continue;
                    v14 = tmp$iv$iv;
                    break block20;
                }
                v14 = null;
            }
            var20_24 /* !! */  = v14;
            v15 = var19_13;
            v16 = var20_24 /* !! */ ;
            if (v16 != null) {
                block21: {
                    this_$iv = v16;
                    var7_9 = false;
                    var8_11 = false;
                    this_$iv$iv = this_$iv;
                    var19_13 = v15;
                    $i$a$-let-PgBaseObjectBuilder$buildOperator$2 = false;
                    this_$iv = this;
                    $i$f$findChild = false;
                    it /* !! */  = this_$iv;
                    v17 = it;
                    element$iv$iv = v17 != null ? v17.getFirstChild() : null;
                    $i$f$findSibling = false;
                    for (tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        it$iv = tmp$iv$iv;
                        $i$a$-findSibling-SqlObjectBuilderImpl$findChild$2$iv = false;
                        if (!(it$iv instanceof SqlReferenceExpression)) continue;
                        v18 = tmp$iv$iv;
                        break block21;
                    }
                    v18 = null;
                }
                v19 = (SqlReferenceExpression)v18;
                var20_24 /* !! */  = v19 != null ? v19.getName() : null;
                v15 = var19_13;
                v20 /* !! */  = var20_24 /* !! */ ;
            } else {
                v20 /* !! */  = null;
            }
            v15.setCallRoutineName((String)v20 /* !! */ );
        }
        if (!context.isStubBuilder()) {
            $this$castSafelyTo$iv = source;
            $i$f$castSafelyTo = false;
            v21 = $this$castSafelyTo$iv;
            if (!(v21 instanceof DasOperator)) {
                v21 = null;
            }
            if ((v22 = (DasOperator)v21) == null || (v22 = v22.getResultType()) == null) {
                v23 = DataType.UNKNOWN;
                v22 = v23;
                Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"DataType.UNKNOWN");
            }
            obj.setResultType((DataType)v22);
        }
    }

    private final PgOperatorKind getPgOperatorKind(DasOperator.OperatorNotation n) {
        if (n == DasOperator.OperatorNotation.INFIX) {
            return PgOperatorKind.BINARY;
        }
        if (n == DasOperator.OperatorNotation.POSTFIX) {
            return PgOperatorKind.POSTFIX;
        }
        return n == DasOperator.OperatorNotation.PREFIX ? PgOperatorKind.PREFIX : PgOperatorKind.UNKNOWN;
    }

    public static final /* synthetic */ SimpleCompositeText access$getViewQuery$s-2018911564(PgBaseObjectBuilder $this, DasObject source, CompositeText.Kind kind) {
        return super.getViewQuery(source, kind);
    }

    public static final /* synthetic */ String access$getRoutineSourceText(PgBaseObjectBuilder $this, SqlCreateProcedureStatement source) {
        return $this.getRoutineSourceText(source);
    }
}

