/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.model.properties;

import com.intellij.openapi.util.text.StringUtil;

public enum PgDataTypeSubKind {
    NONE('\u0000'),
    BASE_TYPE('b'),
    COMPOSITE('c'),
    DOMAIN('d'),
    ENUM('e'),
    PSEUDO('p'),
    UNKNOWN('x');

    public final char code;

    private PgDataTypeSubKind(char code) {
        this.code = code;
    }

    public static PgDataTypeSubKind of(char c) {
        switch (Character.toLowerCase(c)) {
            case 'b': {
                return BASE_TYPE;
            }
            case 'c': {
                return COMPOSITE;
            }
            case 'd': {
                return DOMAIN;
            }
            case 'e': {
                return ENUM;
            }
            case 'p': {
                return PSEUDO;
            }
            case '\u0000': {
                return NONE;
            }
        }
        return UNKNOWN;
    }

    public String human_readable_name() {
        return StringUtil.toLowerCase((String)this.name()).replace('_', ' ');
    }
}

