/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.model.properties;

import com.intellij.database.model.DasRoutine;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PgRoutineKind {
    PG_FUNCTION('F', DasRoutine.Kind.FUNCTION, false),
    PG_PROCEDURE('P', DasRoutine.Kind.PROCEDURE, false),
    PG_TRIGGER('T', DasRoutine.Kind.FUNCTION, true),
    PG_EVENT_TRIGGER('V', DasRoutine.Kind.FUNCTION, true);

    public final char code;
    public final DasRoutine.Kind basicKind;
    public final boolean isTrigger;

    private PgRoutineKind(char code, DasRoutine.Kind basicKind, boolean isTrigger) {
        this.code = code;
        this.basicKind = basicKind;
        this.isTrigger = isTrigger;
    }

    @Nullable
    public static PgRoutineKind of(char code) {
        switch (code) {
            case 'F': 
            case 'f': {
                return PG_FUNCTION;
            }
            case 'P': 
            case 'p': {
                return PG_PROCEDURE;
            }
            case 'T': 
            case 't': {
                return PG_TRIGGER;
            }
            case 'V': 
            case 'v': {
                return PG_EVENT_TRIGGER;
            }
        }
        return null;
    }

    @NotNull
    public String exportValue() {
        String string = Character.toString(this.code);
        if (string == null) {
            PgRoutineKind.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static PgRoutineKind importValue(@NotNull String str) {
        String s;
        if (str == null) {
            PgRoutineKind.$$$reportNull$$$0(1);
        }
        if ((s = str.trim().toLowerCase(Locale.ROOT)).length() >= 4 && s.startsWith("pg")) {
            s = s.substring(3);
        }
        if (s.length() == 1) {
            return PgRoutineKind.of(str.charAt(0));
        }
        if (s.contains("event")) {
            return PG_EVENT_TRIGGER;
        }
        if (s.contains("trigger")) {
            return PG_TRIGGER;
        }
        if (s.contains("pro")) {
            return PG_PROCEDURE;
        }
        if (s.contains("fun")) {
            return PG_FUNCTION;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/model/properties/PgRoutineKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "exportValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/model/properties/PgRoutineKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "importValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

