/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceStorageUtil;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.IntrospectionQueryContext;
import com.intellij.database.dialects.postgresbase.introspector.IntroStep;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntroQueries;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospector;
import com.intellij.database.dialects.postgresbase.introspector.PgBaseIntrospectorKt;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeColumn;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseLikeStoredTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.redshift.introspector.RsIntroQueries;
import com.intellij.database.dialects.redshift.introspector.RsIntrospector;
import com.intellij.database.dialects.redshift.introspector.RsIntrospector$retrieveGroups$1$$special$;
import com.intellij.database.dialects.redshift.introspector.RsIntrospector$retrieveUsers$1$$special$;
import com.intellij.database.dialects.redshift.introspector.RsIntrospectorKt;
import com.intellij.database.dialects.redshift.model.RsDatabase;
import com.intellij.database.dialects.redshift.model.RsExternalSchema;
import com.intellij.database.dialects.redshift.model.RsExternalTable;
import com.intellij.database.dialects.redshift.model.RsExternalTableColumn;
import com.intellij.database.dialects.redshift.model.RsGroup;
import com.intellij.database.dialects.redshift.model.RsModelHelper;
import com.intellij.database.dialects.redshift.model.RsRoot;
import com.intellij.database.dialects.redshift.model.RsSchema;
import com.intellij.database.dialects.redshift.model.RsTable;
import com.intellij.database.dialects.redshift.model.RsTableColumn;
import com.intellij.database.dialects.redshift.model.RsUser;
import com.intellij.database.dialects.redshift.model.RsView;
import com.intellij.database.dialects.redshift.model.RsViewColumn;
import com.intellij.database.dialects.redshift.model.properties.RsTableBackupMode;
import com.intellij.database.dialects.redshift.model.properties.RsTableDistStyle;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.remote.jdba.sql.Scriptum;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 62\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u00056789:B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\u0012\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0013R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0014H\u0014J\u001c\u0010\u0015\u001a\u00060\u0016R\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0014J6\u0010\u001a\u001a \u0012\u0006\b\u0001\u0012\u00020\u00040\u001bR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0004H\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010$\u001a\u00020%H\u0014J$\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0'0\"2\b\u0010(\u001a\u0004\u0018\u00010\u001fH\u0002J \u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u0010\u0010/\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0018H\u0002J\u0010\u00100\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u00101\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0018H\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u00105\u001a\u00020\u0018H\u0014R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006;"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RsIntrospector;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "Lcom/intellij/database/dialects/redshift/model/RsRoot;", "Lcom/intellij/database/dialects/redshift/model/RsDatabase;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "helper", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "getHelper", "()Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "queries", "Lcom/intellij/database/dialects/redshift/introspector/RsIntroQueries;", "getQueries", "()Lcom/intellij/database/dialects/redshift/introspector/RsIntroQueries;", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/redshift/introspector/RsIntrospector$MyDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "schema", "generateDbAge", "", "tx", "getSchemasToIntrospect", "", "Lcom/intellij/database/model/basic/BasicSchema;", "it", "Lcom/intellij/database/model/basic/BasicDatabase;", "parseProperties", "Lkotlin/Pair;", "properties", "retrieveGroups", "", "tran", "detectDropped", "", "loadNew", "retrievePermissions", "retrieveSettings", "retrieveUsers", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "trans", "Companion", "ExternalSchemaRetriever", "Factory", "MyDatabaseRetriever", "MySchemaRetriever", "intellij.database.dialects.redshift"})
public final class RsIntrospector
extends PgBaseIntrospector<RsRoot, RsDatabase, PgBaseLikeSchema> {
    @NotNull
    public static final String ARRAY_DELIMITER = "\u001e";
    @JvmField
    @NotNull
    public static final RsIntroQueries QUERIES;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    protected RsIntroQueries getQueries() {
        return QUERIES;
    }

    @Override
    @NotNull
    protected PgBaseModelHelper getHelper() {
        return RsModelHelper.INSTANCE;
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<RsIntroQueries.RsDbInfo, RsDatabase>(this){
            final /* synthetic */ RsIntrospector this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected List<RsIntroQueries.RsDbInfo> listDatabases(@NotNull DBTransaction tran) {
                List list;
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                List list2 = this.this$0.performQuery(tran, this.this$0.getQueries().getListDatabases());
                boolean bl = false;
                boolean bl2 = false;
                List dbs2 = list2;
                boolean bl3 = false;
                if (Intrinsics.areEqual((Object)((Boolean)DataSourceStorageUtil.SHOW_TEMPLATE_DATABASES.get((UserDataHolder)this.this$0.getOptions())), (Object)true) ^ true) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = dbs2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        RsIntroQueries.RsDbInfo it = (RsIntroQueries.RsDbInfo)element$iv$iv;
                        boolean bl4 = false;
                        if (!(!it.is_template)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = dbs2;
                }
                return list;
            }

            @NotNull
            protected RsDatabase applyDatabase(@NotNull ModNamingFamily<?> databases2, @NotNull RsIntroQueries.RsDbInfo db) {
                Intrinsics.checkNotNullParameter(databases2, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                MD MD = this.renew(databases2, db.id, db.name);
                boolean bl = false;
                boolean bl2 = false;
                RsDatabase $this$apply = (RsDatabase)MD;
                boolean bl3 = false;
                $this$apply.setOwner(db.getOwnerName());
                return (RsDatabase)MD;
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    @Override
    @NotNull
    public String generateDbAge(@NotNull String tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        return "pg_catalog.age(pg_catalog.xidin(pg_catalog.int8out(" + tx + ")))";
    }

    @Override
    protected void retrieveSettings(@NotNull DBTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        super.retrieveSettings(transaction);
        this.retrievePermissions(transaction);
    }

    @Override
    @NotNull
    protected List<IntroStep> steps(@NotNull DBTransaction trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        return PgBaseIntrospectorKt.add(PgBaseIntrospectorKt.add(super.steps(trans), 60, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this, trans){
            final /* synthetic */ RsIntrospector this$0;
            final /* synthetic */ DBTransaction $trans;

            public final void invoke(boolean detectDropped, boolean loadNew) {
                RsIntrospector.access$retrieveUsers(this.this$0, this.$trans);
            }
            {
                this.this$0 = rsIntrospector;
                this.$trans = dBTransaction;
                super(2);
            }
        })), 70, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this, trans){
            final /* synthetic */ RsIntrospector this$0;
            final /* synthetic */ DBTransaction $trans;

            public final void invoke(boolean detectDropped, boolean loadNew) {
                RsIntrospector.access$retrieveGroups(this.this$0, this.$trans, detectDropped, loadNew);
            }
            {
                this.this$0 = rsIntrospector;
                this.$trans = dBTransaction;
                super(2);
            }
        }));
    }

    @Override
    @NotNull
    protected List<BasicSchema> getSchemasToIntrospect(@NotNull BasicDatabase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Collection collection = super.getSchemasToIntrospect(it);
        ModNamingIdentifyingFamily<? extends RsExternalSchema> modNamingIdentifyingFamily = ((RsDatabase)it).getExternalSchemas();
        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"(it as RsDatabase).externalSchemas");
        return CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)modNamingIdentifyingFamily));
    }

    private final void retrievePermissions(DBTransaction tran) {
        RsIntroQueries.Permissions permissions = this.performQuery(tran, QUERIES.getRetrievePermissions());
        this.getParametersMap().put("USER_EXT", permissions.user_ext);
    }

    private final void retrieveUsers(DBTransaction tran) {
        this.setQueryParameter("array_delimiter", ARRAY_DELIMITER);
        this.inModel((Function1)new Function1<RsRoot, Unit>(this, tran){
            final /* synthetic */ RsIntrospector this$0;
            final /* synthetic */ DBTransaction $tran;

            public final void invoke(@NotNull RsRoot r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                boolean $i$f$cleanupFamilies = false;
                Function1 it = retrieveUsers$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                boolean bl = false;
                ModNamingIdentifyingFamily<? extends RsUser> modNamingIdentifyingFamily = r.getUsers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"r.users");
                it.invoke(modNamingIdentifyingFamily);
                boolean bl2 = false;
                IntrospectionQueryContext.performQueryHandleEachRow$default(this.this$0, this.$tran, RsIntrospector.QUERIES.getRetrieveUsers(), 0, (Function1)new Function1<RsIntroQueries.OneUser, Unit>(this, r){
                    final /* synthetic */ retrieveUsers.1 this$0;
                    final /* synthetic */ RsRoot $r$inlined;
                    {
                        this.this$0 = var1_1;
                        this.$r$inlined = rsRoot;
                        super(1);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke(@NotNull RsIntroQueries.OneUser user) {
                        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
                        var2_2 = this.$r$inlined.getUsers().renew(user.user_id, user.user_name);
                        var3_3 = false;
                        var4_4 = false;
                        $this$apply = (RsUser)var2_2;
                        $i$a$-apply-RsIntrospector$retrieveUsers$1$2$1$1 = false;
                        $this$apply.setSuperRole(user.is_super);
                        $this$apply.setCreateDb(user.can_createdb);
                        v0 = user.conn_limit;
                        $this$apply.setConnectionLimit(v0 != null ? v0 : -1L);
                        v1 = user.valid_until;
                        if (v1 == null) ** GOTO lbl-1000
                        var7_7 = v1;
                        switch (var7_7.hashCode()) {
                            case 173173288: {
                                if (var7_7.equals("infinity")) {
                                    v2 = null;
                                    break;
                                }
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                v2 = user.valid_until;
                            }
                        }
                        $this$apply.setValidUntil(v2);
                        var7_7 = user.config;
                        var8_8 = false;
                        var9_9 = false;
                        $this$apply.setConfig((var7_7 == null || var7_7.length() == 0) != false ? CollectionsKt.emptyList() : ArraysKt.toList((Object[])PgBaseIntrospectorKt.parseArrayOfStrings(user.config, "\u001e")));
                    }
                }, 2, null);
                it = retrieveUsers$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                bl = false;
                ModNamingIdentifyingFamily<? extends RsUser> modNamingIdentifyingFamily2 = r.getUsers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"r.users");
                it.invoke(modNamingIdentifyingFamily2);
            }
            {
                this.this$0 = rsIntrospector;
                this.$tran = dBTransaction;
                super(1);
            }
        });
    }

    private final void retrieveGroups(DBTransaction tran, boolean detectDropped, boolean loadNew) {
        this.inModel((Function1)new Function1<RsRoot, Unit>(this, detectDropped, tran, loadNew){
            final /* synthetic */ RsIntrospector this$0;
            final /* synthetic */ boolean $detectDropped;
            final /* synthetic */ DBTransaction $tran;
            final /* synthetic */ boolean $loadNew;

            public final void invoke(@NotNull RsRoot r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                boolean $i$f$cleanupFamilies = false;
                Function1 it = retrieveGroups$1$$special$$inlined$cleanupFamilies$1.INSTANCE;
                boolean bl = false;
                ModNamingIdentifyingFamily<? extends RsGroup> modNamingIdentifyingFamily = r.getGroups();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"r.groups");
                it.invoke(modNamingIdentifyingFamily);
                boolean bl2 = false;
                if (this.$detectDropped) {
                    long[] $this$forEach$iv = this.this$0.performQuery(this.$tran, RsIntrospector.QUERIES.getRetrieveExistentGroups());
                    boolean $i$f$forEach = false;
                    long[] lArray = $this$forEach$iv;
                    int n = lArray.length;
                    for (int j = 0; j < n; ++j) {
                        long element$iv;
                        long it2 = element$iv = lArray[j];
                        boolean bl3 = false;
                        RsGroup rsGroup = (RsGroup)r.getGroups().getByObjectId(it2);
                        if (rsGroup != null) {
                            rsGroup.resetSyncPending();
                        }
                    }
                }
                if (this.$loadNew) {
                    IntrospectionQueryContext.performQueryHandleEachRow$default(this.this$0, this.$tran, RsIntrospector.QUERIES.getRetrieveGroups(), 0, (Function1)new Function1<RsIntroQueries.OneGroup, Unit>(this, r){
                        final /* synthetic */ retrieveGroups.1 this$0;
                        final /* synthetic */ RsRoot $r$inlined;
                        {
                            this.this$0 = var1_1;
                            this.$r$inlined = rsRoot;
                            super(1);
                        }

                        public final void invoke(@NotNull RsIntroQueries.OneGroup g) {
                            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                            BasicModNamedElement basicModNamedElement = this.$r$inlined.getGroups().renew(g.grosysid, g.groname);
                            boolean bl = false;
                            boolean bl2 = false;
                            RsGroup $this$apply = (RsGroup)basicModNamedElement;
                            boolean bl3 = false;
                            Object object = g.grolist;
                            if (g.grolist == null || (object = ArraysKt.asList((Object[])object)) == null) {
                                object = CollectionsKt.emptyList();
                            }
                            $this$apply.setMemberIds((List<Long>)object);
                        }
                    }, 2, null);
                }
                it = retrieveGroups$1$$special$$inlined$cleanupFamilies$2.INSTANCE;
                bl = false;
                ModNamingIdentifyingFamily<? extends RsGroup> modNamingIdentifyingFamily2 = r.getGroups();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"r.groups");
                it.invoke(modNamingIdentifyingFamily2);
            }
            {
                this.this$0 = rsIntrospector;
                this.$detectDropped = bl;
                this.$tran = dBTransaction;
                this.$loadNew = bl2;
                super(1);
            }
        });
    }

    @NotNull
    protected MyDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull RsDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new MyDatabaseRetriever(transaction, database);
    }

    @Override
    @NotNull
    protected BaseIntrospector.AbstractSchemaRetriever<? extends PgBaseLikeSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull PgBaseLikeSchema schema) {
        BaseIntrospector.AbstractSchemaRetriever abstractSchemaRetriever;
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        PgBaseLikeSchema pgBaseLikeSchema = schema;
        if (pgBaseLikeSchema instanceof RsExternalSchema) {
            abstractSchemaRetriever = new ExternalSchemaRetriever(transaction, (RsExternalSchema)schema);
        } else if (pgBaseLikeSchema instanceof RsSchema) {
            abstractSchemaRetriever = new MySchemaRetriever(transaction, (RsSchema)schema);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("unexpected schema: " + schema.getClass())));
        }
        return abstractSchemaRetriever;
    }

    private final List<Pair<String, String>> parseProperties(String properties2) {
        Iterable $this$filterTo$iv$iv;
        List list;
        List it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String string = properties2;
        if (string == null || (string = StringsKt.trimStart((String)string, (char[])new char[]{'{'})) == null || (string = StringsKt.trimEnd((String)string, (char[])new char[]{'}'})) == null) {
            return CollectionsKt.emptyList();
        }
        String clear = string;
        List list2 = StringUtil.splitHonorQuotes((String)clear, (char)',');
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"StringUtil.splitHonorQuotes(clear, ',')");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            list = StringUtil.splitHonorQuotes((String)((Object)it), (char)':');
            collection.add(list);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            boolean bl = false;
            if (!(it.size() == 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (List)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            List list3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"it");
            list = new Pair((Object)StringUtil.unquoteString((String)((String)CollectionsKt.first((List)list3))), (Object)StringUtil.unquoteString((String)((String)CollectionsKt.last((List)it))));
            collection.add(list);
        }
        return (List)destination$iv$iv;
    }

    public RsIntrospector(@NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        Dbms dbms = Dbms.REDSHIFT;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"Dbms.REDSHIFT");
        super(dbms, project, modelFactory);
    }

    static {
        Companion = new Companion(null);
        Scriptum scriptum = Scriptum.of(RsIntroQueries.class);
        Intrinsics.checkNotNullExpressionValue((Object)scriptum, (String)"Scriptum.of(RsIntroQueries::class.java)");
        QUERIES = new RsIntroQueries(scriptum);
    }

    public static final /* synthetic */ List access$parseProperties(RsIntrospector $this, String properties2) {
        return $this.parseProperties(properties2);
    }

    public static final /* synthetic */ boolean access$isColumnNameSurrogate(RsIntrospector $this, String it) {
        return $this.isColumnNameSurrogate(it);
    }

    public static final /* synthetic */ void access$retrieveUsers(RsIntrospector $this, DBTransaction tran) {
        $this.retrieveUsers(tran);
    }

    public static final /* synthetic */ void access$retrieveGroups(RsIntrospector $this, DBTransaction tran, boolean detectDropped, boolean loadNew) {
        $this.retrieveGroups(tran, detectDropped, loadNew);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RsIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.redshift"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new RsIntrospector(project, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return PgBaseIntrospectorKt.canCheckOutdated(e2);
        }

        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative((DBIntrospector.Factory)this);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RsIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.redshift"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0014J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0014J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0018\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00150\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RsIntrospector$ExternalSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/redshift/model/RsExternalSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "Lcom/intellij/database/dialects/redshift/model/RsRoot;", "Lcom/intellij/database/dialects/redshift/model/RsDatabase;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/redshift/introspector/RsIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/redshift/model/RsExternalSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "retrieveExternalTables", "", "retrieveExternalTablesColumns", "retrieveMainContent", "toRsProperties", "", "", "properties", "Lkotlin/Pair;", "intellij.database.dialects.redshift"})
    private final class ExternalSchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever<RsExternalSchema> {
        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull RsExternalSchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return false;
        }

        @Override
        protected void retrieveMainContent() {
            String string = "external schema " + ((RsExternalSchema)this.getSchema()).getName();
            Object[] objectArray = new Object[1];
            String string2 = ((RsExternalSchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"schema.name");
            objectArray[0] = string2;
            RsIntrospector.this.reportIntrospecting(string, "introspector.progress.status.external.schema", objectArray);
            this.prepareParameters();
            this.retrieveExternalTables();
            this.retrieveExternalTablesColumns();
        }

        private final void retrieveExternalTables() {
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ObjectKind.TABLE");
            RsIntrospector.this.reportRetrieving(objectKind);
            List<RsIntroQueries.OneExternalTable> tables = this.performQuery(QUERIES.getRetrieveExternalTables());
            this.getModel().modify((BasicElement)this.getSchema(), RsExternalSchema.class, new ModelModifier(this, tables){
                final /* synthetic */ ExternalSchemaRetriever this$0;
                final /* synthetic */ List $tables;

                /*
                 * WARNING - void declaration
                 */
                public final void perform(RsExternalSchema schema) {
                    RsExternalSchema rsExternalSchema = schema;
                    Intrinsics.checkNotNullExpressionValue((Object)rsExternalSchema, (String)"schema");
                    rsExternalSchema.getExternalTables().markChildrenAsSyncPending();
                    for (RsIntroQueries.OneExternalTable t : this.$tables) {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        RsExternalTable table;
                        RsExternalTable rsExternalTable = table = (RsExternalTable)schema.getExternalTables().renew(Long.MIN_VALUE, t.table_name);
                        Intrinsics.checkNotNullExpressionValue((Object)rsExternalTable, (String)"table");
                        rsExternalTable.setLocation(t.location);
                        table.setSerializationLib(t.serialization_lib);
                        table.setInputFormat(t.input_format);
                        table.setOutputFormat(t.output_format);
                        Iterable iterable = RsIntrospector.access$parseProperties(this.this$0.RsIntrospector.this, t.props);
                        ExternalSchemaRetriever externalSchemaRetriever = this.this$0;
                        RsExternalTable rsExternalTable2 = table;
                        boolean $i$f$filter = false;
                        void var7_7 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            Pair it = (Pair)element$iv$iv;
                            boolean bl = false;
                            if (!(!StringsKt.equals((String)((String)it.getFirst()), (String)"external", (boolean)true) && !StringsKt.equals((String)((String)it.getFirst()), (String)"transient_lastDdlTime", (boolean)true))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List list = (List)destination$iv$iv;
                        rsExternalTable2.setProps(ExternalSchemaRetriever.access$toRsProperties(externalSchemaRetriever, list));
                        table.setSerdeProperties(ExternalSchemaRetriever.access$toRsProperties(this.this$0, RsIntrospector.access$parseProperties(this.this$0.RsIntrospector.this, t.serde_properties)));
                    }
                    schema.getExternalTables().sort();
                    schema.getExternalTables().removeSyncPendingChildren();
                }
                {
                    this.this$0 = externalSchemaRetriever;
                    this.$tables = list;
                }
            });
        }

        private final void retrieveExternalTablesColumns() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ObjectKind.COLUMN");
            RsIntrospector.this.reportRetrieving(objectKind);
            List<RsIntroQueries.OneExternalTableColumn> columns = this.performQuery(QUERIES.getRetrieveExternalTablesColumns());
            this.getModel().modify((BasicElement)this.getSchema(), RsExternalSchema.class, new ModelModifier(columns){
                final /* synthetic */ List $columns;

                /*
                 * WARNING - void declaration
                 */
                public final void perform(RsExternalSchema schema) {
                    void $this$groupByTo$iv$iv;
                    RsIntroQueries.OneExternalTableColumn it;
                    Iterable $this$filterNotTo$iv$iv;
                    Iterable $this$filterNot$iv = this.$columns;
                    boolean $i$f$filterNot = false;
                    Iterable iterable = $this$filterNot$iv;
                    Object destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        it = (RsIntroQueries.OneExternalTableColumn)element$iv$iv;
                        boolean bl = false;
                        if (it.table_name == null || it.column_name == null) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$groupBy$iv = (List)destination$iv$iv;
                    boolean $i$f$groupBy = false;
                    $this$filterNotTo$iv$iv = $this$groupBy$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        it = (RsIntroQueries.OneExternalTableColumn)element$iv$iv;
                        boolean bl = false;
                        String key$iv$iv = it.table_name;
                        Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    destination$iv$iv.forEach(new BiConsumer(schema){
                        final /* synthetic */ RsExternalSchema $schema;

                        public final void accept(@Nullable String table_name, @NotNull List<RsIntroQueries.OneExternalTableColumn> externalColumns) {
                            Intrinsics.checkNotNullParameter(externalColumns, (String)"externalColumns");
                            RsExternalSchema rsExternalSchema = this.$schema;
                            Intrinsics.checkNotNullExpressionValue((Object)rsExternalSchema, (String)"schema");
                            ModNamingIdentifyingFamily<? extends RsExternalTable> modNamingIdentifyingFamily = rsExternalSchema.getExternalTables();
                            String string = table_name;
                            Intrinsics.checkNotNull((Object)string);
                            RsExternalTable rsExternalTable = (RsExternalTable)modNamingIdentifyingFamily.get(string);
                            if (rsExternalTable == null) {
                                return;
                            }
                            RsExternalTable table = rsExternalTable;
                            table.getColumns().markChildrenAsSyncPending();
                            for (RsIntroQueries.OneExternalTableColumn c : externalColumns) {
                                RsExternalTableColumn column2;
                                ModPositioningNamingFamily<? extends RsExternalTableColumn> modPositioningNamingFamily = table.getColumns();
                                short s = c.position;
                                String string2 = c.column_name;
                                Intrinsics.checkNotNull((Object)string2);
                                RsExternalTableColumn rsExternalTableColumn = column2 = (RsExternalTableColumn)modPositioningNamingFamily.renewAt(s, string2);
                                Intrinsics.checkNotNullExpressionValue((Object)rsExternalTableColumn, (String)"column");
                                rsExternalTableColumn.setPartitionKeyOrder(c.partition_key);
                                column2.setDataType(PgBaseIntrospectorKt.dataTypeOf(c.data_type));
                            }
                            table.getColumns().sort();
                            table.getColumns().removeSyncPendingChildren();
                        }
                        {
                            this.$schema = rsExternalSchema;
                        }
                    });
                }
                {
                    this.$columns = list;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> toRsProperties(List<Pair<String, String>> properties2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = properties2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = '\'' + (String)it.getFirst() + "'='" + (String)it.getSecond() + '\'';
                collection.add(string);
            }
            return (List)destination$iv$iv;
        }

        public ExternalSchemaRetriever(@NotNull DBTransaction tran, RsExternalSchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseIntrospector)RsIntrospector.this, tran, (BasicModSchema)schema);
        }

        public static final /* synthetic */ List access$toRsProperties(ExternalSchemaRetriever $this, List properties2) {
            return $this.toRsProperties(properties2);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ,\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RsIntrospector$MyDatabaseRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$DatabaseRetriever;", "Lcom/intellij/database/dialects/redshift/model/RsDatabase;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "Lcom/intellij/database/dialects/redshift/model/RsRoot;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/redshift/introspector/RsIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/redshift/model/RsDatabase;)V", "getProperty", "", "properties", "", "Lkotlin/Pair;", "key", "retrieveExternalSchemas", "", "retrieveSchemas", "intellij.database.dialects.redshift"})
    protected final class MyDatabaseRetriever
    extends PgBaseIntrospector.DatabaseRetriever<RsDatabase> {
        @Override
        public void retrieveSchemas() {
            super.retrieveSchemas();
            this.retrieveExternalSchemas();
        }

        private final void retrieveExternalSchemas() {
            String dbComment = this.performQuery(QUERIES.getCurrentDbComment());
            List<RsIntroQueries.OneExternalSchema> schemas2 = this.performQuery(QUERIES.getRetrieveExternalSchemas());
            this.inDatabase((Function1)new Function1<RsDatabase, Unit>(this, dbComment, schemas2){
                final /* synthetic */ MyDatabaseRetriever this$0;
                final /* synthetic */ String $dbComment;
                final /* synthetic */ List $schemas;

                public final void invoke(@NotNull RsDatabase db) {
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    db.setComment(this.$dbComment);
                    db.getExternalSchemas().markChildrenAsSyncPending();
                    for (RsIntroQueries.OneExternalSchema s : this.$schemas) {
                        RsExternalSchema schema;
                        RsExternalSchema rsExternalSchema = schema = (RsExternalSchema)db.getExternalSchemas().renew(s.schema_id, s.schema_name);
                        Intrinsics.checkNotNullExpressionValue((Object)rsExternalSchema, (String)"schema");
                        rsExternalSchema.setStateNumber(s.state_number);
                        schema.setCurrent(false);
                        schema.setDatabaseName(s.database_name);
                        schema.setComment(s.description);
                        schema.setSchemaKind(s.schema_kind);
                        List props = RsIntrospector.access$parseProperties(this.this$0.RsIntrospector.this, s.schema_options);
                        schema.setIamRole(MyDatabaseRetriever.access$getProperty(this.this$0, props, "IAM_ROLE"));
                        schema.setRegion(MyDatabaseRetriever.access$getProperty(this.this$0, props, "REGION"));
                        schema.setUri(MyDatabaseRetriever.access$getProperty(this.this$0, props, "URI"));
                        schema.setPort(MyDatabaseRetriever.access$getProperty(this.this$0, props, "PORT"));
                        schema.setOwner(s.getOwnerName());
                    }
                    db.getExternalSchemas().sort();
                    db.getExternalSchemas().removeSyncPendingChildren();
                }
                {
                    this.this$0 = myDatabaseRetriever;
                    this.$dbComment = string;
                    this.$schemas = list;
                    super(1);
                }
            });
        }

        private final String getProperty(List<Pair<String, String>> properties2, String key2) {
            Object v0;
            block1: {
                Iterable iterable = properties2;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    Pair it = (Pair)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)((String)it.getFirst()), (Object)key2)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            Pair pair = v0;
            return pair != null ? (String)pair.getSecond() : null;
        }

        public MyDatabaseRetriever(@NotNull DBTransaction tran, RsDatabase database) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((PgBaseIntrospector)RsIntrospector.this, tran, (PgBaseDatabase)database);
        }

        public static final /* synthetic */ String access$getProperty(MyDatabaseRetriever $this, List properties2, String key2) {
            return $this.getProperty(properties2, key2);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003B\u0017\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0014\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0014J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010 \u001a\u00020\u0012H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RsIntrospector$MySchemaRetriever;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector$SchemaRetriever;", "Lcom/intellij/database/dialects/redshift/model/RsSchema;", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntrospector;", "Lcom/intellij/database/dialects/redshift/model/RsRoot;", "Lcom/intellij/database/dialects/redshift/model/RsDatabase;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/redshift/introspector/RsIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/redshift/model/RsSchema;)V", "incrementalColAcl", "", "listExistentComments", "Lgnu/trove/TLongObjectHashMap;", "", "", "processColumn", "", "col", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneColumn;", "column", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeColumn;", "columns", "Lcom/intellij/database/model/families/ModPositioningNamingFamily;", "table", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseLikeStoredTable;", "processModTable", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "t", "Lcom/intellij/database/dialects/postgresbase/introspector/PgBaseIntroQueries$OneTable;", "processModView", "retrieveBoundlessViewsColumns", "steps", "", "Lcom/intellij/database/dialects/postgresbase/introspector/IntroStep;", "intellij.database.dialects.redshift"})
    private final class MySchemaRetriever
    extends PgBaseIntrospector.SchemaRetriever<RsSchema> {
        @Override
        protected boolean incrementalColAcl() {
            return false;
        }

        @Override
        @NotNull
        protected List<IntroStep> steps() {
            return PgBaseIntrospectorKt.add(super.steps(), 21, (Function2<? super Boolean, ? super Boolean, Unit>)((Function2)new Function2<Boolean, Boolean, Unit>(this){
                final /* synthetic */ MySchemaRetriever this$0;

                public final void invoke(boolean detectDropped, boolean loadNew) {
                    MySchemaRetriever.access$retrieveBoundlessViewsColumns(this.this$0);
                }
                {
                    this.this$0 = mySchemaRetriever;
                    super(2);
                }
            }));
        }

        private final void retrieveBoundlessViewsColumns() {
            RsIntrospector.this.reportRetrieving("late-binding views' columns", "introspection.retrieve.lateBindingView.columns");
            List<RsIntroQueries.OneBoundlessViewColumn> cols2 = this.performQuery(QUERIES.getRetrieveBoundlessViewsColumns());
            if (cols2.isEmpty()) {
                return;
            }
            this.inSchema((Function1)new Function1<RsSchema, Unit>(this, cols2){
                final /* synthetic */ MySchemaRetriever this$0;
                final /* synthetic */ List $cols;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull RsSchema schema) {
                    void $this$groupByTo$iv$iv;
                    RsIntroQueries.OneBoundlessViewColumn it;
                    Iterable $this$filterNotTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                    Iterable $this$filterNot$iv = this.$cols;
                    boolean $i$f$filterNot = false;
                    Iterable iterable = $this$filterNot$iv;
                    Object destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterNotTo = false;
                    for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                        boolean bl;
                        block5: {
                            it = (RsIntroQueries.OneBoundlessViewColumn)element$iv$iv;
                            boolean bl2 = false;
                            String[] $this$any$iv = new String[]{it.view_name, it.column_name, it.column_type};
                            boolean $i$f$any = false;
                            String[] stringArray = $this$any$iv;
                            int n = stringArray.length;
                            for (int j = 0; j < n; ++j) {
                                String element$iv;
                                String it2 = element$iv = stringArray[j];
                                boolean bl3 = false;
                                if (!(it2 == null)) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                        if (bl) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$groupBy$iv = (List)destination$iv$iv;
                    boolean $i$f$groupBy = false;
                    $this$filterNotTo$iv$iv = $this$groupBy$iv;
                    destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        it = (RsIntroQueries.OneBoundlessViewColumn)element$iv$iv;
                        boolean bl = false;
                        String key$iv$iv = it.view_name;
                        Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl4 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    destination$iv$iv.forEach(new BiConsumer(this, schema){
                        final /* synthetic */ retrieveBoundlessViewsColumns.1 this$0;
                        final /* synthetic */ RsSchema $schema;

                        public final void accept(@Nullable String view_name, @NotNull List<RsIntroQueries.OneBoundlessViewColumn> cols2) {
                            Intrinsics.checkNotNullParameter(cols2, (String)"cols");
                            ModNamingIdentifyingFamily<? extends RsView> modNamingIdentifyingFamily = this.$schema.getViews();
                            String string = view_name;
                            Intrinsics.checkNotNull((Object)string);
                            RsView rsView = (RsView)modNamingIdentifyingFamily.get(string);
                            if (rsView == null) {
                                return;
                            }
                            RsView view = rsView;
                            view.getColumns().markChildrenAsSyncPending();
                            for (RsIntroQueries.OneBoundlessViewColumn c : cols2) {
                                RsViewColumn column2;
                                ModPositioningNamingFamily<? extends RsViewColumn> modPositioningNamingFamily = view.getColumns();
                                short s = c.position;
                                String string2 = c.column_name;
                                Intrinsics.checkNotNull((Object)string2);
                                RsViewColumn rsViewColumn = column2 = (RsViewColumn)modPositioningNamingFamily.renewAt(s, string2);
                                Intrinsics.checkNotNullExpressionValue((Object)rsViewColumn, (String)"column");
                                String string3 = c.column_type;
                                Intrinsics.checkNotNull((Object)string3);
                                rsViewColumn.setDataType(PgBaseIntrospectorKt.dataTypeOf(string3));
                                column2.setNameSurrogate(RsIntrospector.access$isColumnNameSurrogate(this.this$0.this$0.RsIntrospector.this, c.column_name));
                            }
                            view.getColumns().removeSyncPendingChildren();
                        }
                        {
                            this.this$0 = var1_1;
                            this.$schema = rsSchema;
                        }
                    });
                }
                {
                    this.this$0 = mySchemaRetriever;
                    this.$cols = list;
                    super(1);
                }
            });
        }

        @Override
        protected void processModView(@NotNull PgBaseLikeStoredTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            PgBaseLikeStoredTable pgBaseLikeStoredTable = table;
            if (!(pgBaseLikeStoredTable instanceof RsView)) {
                pgBaseLikeStoredTable = null;
            }
            RsView rsView = (RsView)pgBaseLikeStoredTable;
            if (rsView == null) {
                return;
            }
            RsView view = rsView;
            view.setBoundless(t.is_boundless_view);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected TLongObjectHashMap<Short[]> listExistentComments() {
            void $this$groupByTo$iv$iv;
            TLongObjectHashMap existentComments = new TLongObjectHashMap();
            Iterable $this$groupBy$iv = this.performQuery(QUERIES.getListExistentSchemaComments());
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                RsIntroQueries.IdAndSubId it = (RsIntroQueries.IdAndSubId)element$iv$iv;
                boolean bl = false;
                Long key$iv$iv = it.id;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl3 = false;
                existentComments.put(((Number)it.getKey()).longValue(), (Object)RsIntrospectorKt.optimizeFor0((List)it.getValue()));
            }
            return existentComments;
        }

        @Override
        protected void processModTable(@NotNull PgBaseTable table, @NotNull PgBaseIntroQueries.OneTable t) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            if (!(table instanceof RsTable)) {
                return;
            }
            ((RsTable)table).setDistStyle(RsTableDistStyle.of(t.dist_style));
            ((RsTable)table).setBackupMode(RsTableBackupMode.of(t.bckp));
        }

        @Override
        protected void processColumn(@NotNull PgBaseIntroQueries.OneColumn col, @NotNull PgBaseLikeColumn column2, @NotNull ModPositioningNamingFamily<? extends PgBaseLikeColumn> columns, @NotNull PgBaseLikeStoredTable table) {
            Intrinsics.checkNotNullParameter((Object)col, (String)"col");
            Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            super.processColumn(col, column2, columns, table);
            if (!(column2 instanceof RsTableColumn)) {
                return;
            }
            ((RsTableColumn)column2).setDistKey(col.distkey);
            ((RsTableColumn)column2).setSortKeyOrder(col.sortkeyord);
            ((RsTableColumn)column2).setEncoding(col.encoding);
        }

        public MySchemaRetriever(@NotNull DBTransaction transaction, RsSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((PgBaseIntrospector)RsIntrospector.this, transaction, (PgBaseSchema)schema);
        }

        public static final /* synthetic */ void access$retrieveBoundlessViewsColumns(MySchemaRetriever $this) {
            $this.retrieveBoundlessViewsColumns();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/redshift/introspector/RsIntrospector$Companion;", "", "()V", "ARRAY_DELIMITER", "", "QUERIES", "Lcom/intellij/database/dialects/redshift/introspector/RsIntroQueries;", "intellij.database.dialects.redshift"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

