/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cockroach;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.base.TokenClasses;
import com.intellij.sql.dialects.cockroach.CRoachElementFactory;
import com.intellij.sql.dialects.cockroach.CRoachElementTypes;
import com.intellij.sql.dialects.cockroach.CRoachTokens;
import com.intellij.sql.dialects.cockroach.CRoachTypeSystem;
import com.intellij.sql.dialects.cockroach.CRoachTypes;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.Pg83Dialect;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRoachDialect
extends Pg83Dialect {
    public static final CRoachDialect INSTANCE = new CRoachDialect();

    public CRoachDialect() {
        super("Cockroach");
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.COCKROACH;
        if (dbms == null) {
            CRoachDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @NotNull
    public SqlTypeSystemBase getTypeSystem() {
        CRoachTypeSystem cRoachTypeSystem = CRoachTypeSystem.INSTANCE;
        if (cRoachTypeSystem == null) {
            CRoachDialect.$$$reportNull$$$0(1);
        }
        return cRoachTypeSystem;
    }

    @Override
    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"geometry", (String)"geometry", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"geography", (String)"geography", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType(myTypes, (String)"uuid", (String)"uuid", (SqlLanguageDialectEx)this);
    }

    @NotNull
    public SqlLanguageDialectEx.BuiltinFunctions getSupportedFunctions() {
        SqlLanguageDialectEx.BuiltinFunctions builtinFunctions = LazyData.ourFunctionMap;
        if (builtinFunctions == null) {
            CRoachDialect.$$$reportNull$$$0(2);
        }
        return builtinFunctions;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set<String> set = LazyData.ourKeywords;
        if (set == null) {
            CRoachDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getReservedKeywords() {
        Set<String> set = LazyData.ourReservedKeywords;
        if (set == null) {
            CRoachDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            CRoachDialect.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            CRoachDialect.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        if (type == CRoachElementTypes.Kinds.FAMILY) {
            result2.add((ObjectKind)ObjectKind.TABLE);
        }
        if (type == ObjectKind.PARTITION) {
            result2.add((ObjectKind)ObjectKind.INDEX);
            result2.add((ObjectKind)ObjectKind.TABLE);
        }
        return super.getParentDbTypes(result2, type);
    }

    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name2) {
        IElementType res2;
        if (name2 == null) {
            CRoachDialect.$$$reportNull$$$0(7);
        }
        return (res2 = CRoachElementFactory.findComposite(name2)) == null ? super.getFunctionParserExtension(name2) : res2;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            CRoachDialect.$$$reportNull$$$0(8);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlDeleteStatement.class, SqlUpdateStatement.class, SqlInsertStatement.class}) != null;
    }

    @NotNull
    private static Condition<PsiElement> isType(IElementType type) {
        Condition condition = Conditions.compose((Function)SyntaxTraverser.psiApi().TO_TYPE, (Condition)Conditions.is((Object)type));
        if (condition == null) {
            CRoachDialect.$$$reportNull$$$0(9);
        }
        return condition;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        SqlDmlInstruction insert;
        SqlPrimitiveType type;
        SyntaxTraverser.ApiEx api;
        PsiElement conflictAction;
        if (place == null) {
            CRoachDialect.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            CRoachDialect.$$$reportNull$$$0(11);
        }
        if (!super.processReservedEntitiesWithType(name2, place, resolve2, processor)) {
            return false;
        }
        return !SqlImplUtil.equalsInsensitiveOrTrue((String)name2, (String)LazyData.RE_EXCLUDED.name, (boolean)resolve2) || (conflictAction = (PsiElement)(api = SyntaxTraverser.psiApi()).parents((Object)place).filter(CRoachDialect.isType(CRoachTypes.CROACH_CONFLICT_ACTION_CLAUSE)).first()) == null || api.children((Object)conflictAction).filter(CRoachDialect.isType((IElementType)SqlCommonKeywords.SQL_UPDATE)).isEmpty() || processor.executeTarget((DasSymbol)LazyData.RE_EXCLUDED, (SqlType)((type = (insert = (SqlDmlInstruction)api.parents((Object)place).filter(SqlDmlInstruction.class).first()) == null ? SqlType.UNKNOWN : insert.getTargetExpression().getSqlType()) == SqlType.UNKNOWN ? SqlTableTypeBase.EMPTY_TABLE : type), null, ResolveState.initial());
    }

    @Override
    @NotNull
    protected List<ReservedEntity> getReservedObjects() {
        List<ReservedEntity> list = LazyData.ourObjects;
        if (list == null) {
            CRoachDialect.$$$reportNull$$$0(12);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cockroach/CRoachDialect";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedKeywords";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cockroach/CRoachDialect";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "isType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        static final TokenClasses ourClasses = new TokenClasses(CRoachTokens.class);
        static final SqlLanguageDialectEx.BuiltinFunctions ourFunctionMap = SqlFunctionsUtil.loadFunctionDefinition((SqlLanguageDialectEx)INSTANCE);
        static final Set<String> ourSystemVars;
        static final List<ReservedEntity> ourObjects;
        static final NullableFunction<String, IElementType> ourReservedTokens;
        static Set<String> ourKeywords;
        static Set<String> ourReservedKeywords;
        static final Set<IElementType> ourSupportedOperators;
        static final ReservedEntity RE_EXCLUDED;
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS;

        LazyData() {
        }

        static {
            SqlLexer.initTokens(ourFunctionMap, ourClasses);
            ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars((SqlLanguageDialect)INSTANCE));
            ourObjects = SqlDialectImplUtilCore.loadObjects((SqlLanguageDialect)INSTANCE, (String)"fallback.txt");
            ourReservedTokens = SqlTokenRegistry.getTokenProvider((Class)LazyData.ourClasses.reserved);
            ourKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.all);
            ourReservedKeywords = SqlTokenRegistry.getTokens((Class)LazyData.ourClasses.reserved);
            ourSupportedOperators = Set.of(SqlCommonTokens.SQL_QUESTION_MARK, CRoachTypes.CROACH_OP_ABS, SqlCommonTokens.SQL_OP_NOT2, CRoachTypes.CROACH_OP_BITWISE_XOR, SqlCommonTokens.SQL_OP_INVERT, SqlCommonTokens.SQL_OP_LOGICAL_AND, SqlCommonTokens.SQL_OP_CONCAT, SqlCommonTokens.SQL_OP_NULLSAFE_EQ, SqlCommonTokens.SQL_OP_LEFT_SHIFT, SqlCommonTokens.SQL_OP_RIGHT_SHIFT, SqlCommonTokens.SQL_OP_BITWISE_AND, SqlCommonTokens.SQL_OP_BITWISE_OR, SqlCommonTokens.PG_OP_PRIME, CRoachTypes.CROACH_OP_CUSTOM, SqlCommonTokens.SQL_OP_PLUS, SqlCommonTokens.SQL_OP_MINUS, SqlCommonTokens.SQL_OP_MUL, SqlCommonTokens.SQL_OP_DIV, SqlCommonTokens.SQL_OP_DIV_INT, SqlCommonTokens.SQL_OP_LT, SqlCommonTokens.SQL_OP_GT, SqlCommonTokens.SQL_OP_PLUS_EQ, SqlCommonTokens.SQL_OP_MINUS_EQ, SqlCommonTokens.SQL_OP_MUL_EQ, SqlCommonTokens.SQL_OP_DIV_EQ, SqlCommonTokens.SQL_OP_LE, SqlCommonTokens.SQL_OP_GE, SqlCommonTokens.SQL_OP_EQEQ, SqlCommonTokens.SQL_OP_NEQ3, SqlCommonTokens.SQL_OP_MODULO_EQ, SqlCommonTokens.SQL_OP_BITWISE_AND_EQ, SqlCommonTokens.SQL_OP_BITWISE_OR_EQ, SqlCommonTokens.SQL_OP_EQ, SqlCommonTokens.SQL_OP_MODULO, SqlCommonTokens.SQL_OP_BITWISE_XOR, SqlCommonTokens.SQL_OP_NEQ, SqlCommonTokens.SQL_OP_NEQ2);
            RE_EXCLUDED = new ReservedEntity(Dbms.POSTGRES, "excluded", ObjectKind.TABLE);
            MAJOR_CHILD_KINDS = Arrays.asList(ObjectKind.KEY, ObjectKind.INDEX);
        }
    }
}

