/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.mongo.MongoSqlDialect;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MongoSqlTypeSystem
extends SqlTypeSystemBase {
    public static final MongoSqlTypeSystem INSTANCE = new MongoSqlTypeSystem();

    private MongoSqlTypeSystem() {
        super((SqlLanguageDialectEx)MongoSqlDialect.INSTANCE);
    }

    @NotNull
    public SqlType getSqlType(@Nullable SqlReferenceImpl ref2, @Nullable PsiElement resolved, @Nullable DasSymbol symbol) {
        if (symbol == null) {
            SqlType sqlType = super.getSqlType(ref2, resolved, null);
            if (sqlType == null) {
                MongoSqlTypeSystem.$$$reportNull$$$0(0);
            }
            return sqlType;
        }
        if (symbol.getKind() == ObjectKind.COLUMN) {
            String prefix;
            DasObject table;
            DasObject object = symbol.getDasObject();
            DasObject dasObject = table = object == null ? null : object.getDasParent();
            if (table == null) {
                SqlType sqlType = super.getSqlType(ref2, resolved, symbol);
                if (sqlType == null) {
                    MongoSqlTypeSystem.$$$reportNull$$$0(1);
                }
                return sqlType;
            }
            JBIterable allColumns = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class);
            JBIterable children2 = allColumns.filter(arg_0 -> MongoSqlTypeSystem.lambda$getSqlType$0(prefix = symbol.getName() + ".", arg_0));
            if (!children2.isEmpty()) {
                SqlTableType sqlTableType = SqlImplUtil.createTableTypeWithColumns((SqlLanguageDialectEx)this.getDialect(), (JBIterable)children2, (PsiElement)resolved, (DasSymbol)symbol);
                if (sqlTableType == null) {
                    MongoSqlTypeSystem.$$$reportNull$$$0(2);
                }
                return sqlTableType;
            }
            if (object instanceof DasColumn && !(object instanceof SqlTypedDefinition)) {
                DasColumn column2 = (DasColumn)object;
                SqlType sqlType = SqlTypeFactory.of((DataType)column2.getDataType(), (SqlLanguageDialect)this.getDialect());
                if (sqlType == null) {
                    MongoSqlTypeSystem.$$$reportNull$$$0(3);
                }
                return sqlType;
            }
        } else if (symbol.getKind() == ObjectKind.TABLE) {
            DasTable table = (DasTable)symbol;
            JBIterable columns = table.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class);
            SqlTableType sqlTableType = SqlImplUtil.createTableTypeWithColumns((SqlLanguageDialectEx)this.getDialect(), (JBIterable)columns, (PsiElement)resolved, (DasSymbol)symbol);
            if (sqlTableType == null) {
                MongoSqlTypeSystem.$$$reportNull$$$0(4);
            }
            return sqlTableType;
        }
        SqlType sqlType = super.getSqlType(ref2, resolved, symbol);
        if (sqlType == null) {
            MongoSqlTypeSystem.$$$reportNull$$$0(5);
        }
        return sqlType;
    }

    private static /* synthetic */ boolean lambda$getSqlType$0(String prefix, DasColumn col) {
        return col.getName().startsWith(prefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mongo/MongoSqlTypeSystem", "getSqlType"));
    }
}

