/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesAndCommentsBinder;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.JavaScriptParser;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.PropertyKey;

public class JavaScriptParserBase {
    public static final Key<ForceContext> FORCE_CONTEXT_KEY = Key.create((String)"FORCE_CONTEXT");
    public static int MAX_TREE_DEPTH = 100;
    protected final PsiBuilder builder;
    protected final JavaScriptParser myJavaScriptParser;
    protected static final WhitespacesAndCommentsBinder INCLUDE_DOC_COMMENT_AT_LEFT = new JSDocBinder(true);
    protected static final WhitespacesAndCommentsBinder INCLUDE_DOC_COMMENT_AT_LEFT_NO_EXTRA_LINEBREAK = new JSDocBinder(false);

    protected JavaScriptParserBase(JavaScriptParser parser) {
        this.builder = parser.builder;
        this.myJavaScriptParser = parser;
    }

    public static boolean hasSemanticLinefeedBefore(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == null || tokenType == JSElementTypes.RBRACE || tokenType == JSElementTypes.OR_RBRACE) {
            return true;
        }
        if (tokenType == JSElementTypes.ELSE_KEYWORD || tokenType == JSElementTypes.WHILE_KEYWORD) {
            return true;
        }
        return JavaScriptParserBase.hasSemanticLinefeed(builder, true);
    }

    public static boolean hasSemanticLinefeedAfter(PsiBuilder builder) {
        return JavaScriptParserBase.hasSemanticLinefeed(builder, false);
    }

    private static boolean hasSemanticLinefeed(PsiBuilder builder, boolean isBefore) {
        int at = isBefore ? -1 : 1;
        IElementType boundElementType = builder.rawLookup(at);
        while (boundElementType == JSElementTypes.WHITE_SPACE || boundElementType == JSElementTypes.HEREDOC_BOUND || JSElementTypes.COMMENTS.contains(boundElementType)) {
            int end = builder.rawTokenTypeStart(at + 1);
            CharSequence sequence = builder.getOriginalText();
            for (int start2 = builder.rawTokenTypeStart(at); start2 < end; ++start2) {
                char ch = sequence.charAt(start2);
                if (ch != '\n' && ch != '\u2028' && ch != '\u2029' && ch != '\r') continue;
                return true;
            }
            at = isBefore ? --at : ++at;
            boundElementType = builder.rawLookup(at);
        }
        return false;
    }

    protected static boolean checkMatches(PsiBuilder builder, IElementType token, @NonNls @PropertyKey(resourceBundle="messages.DatabaseBundle") @NonNls @PropertyKey(resourceBundle="messages.DatabaseBundle") String errorMessageKey) {
        if (builder.getTokenType() == token) {
            builder.advanceLexer();
            return true;
        }
        builder.error(DatabaseBundle.message((String)errorMessageKey, (Object[])new Object[0]));
        return false;
    }

    protected boolean isIdentifierToken(IElementType tokenType) {
        if (tokenType == JSElementTypes.IDENTIFIER) {
            return true;
        }
        return this.myJavaScriptParser.isIdentifierToken(tokenType);
    }

    private static final class JSDocBinder
    implements WhitespacesAndCommentsBinder {
        private final boolean myAllowExtraLineBreak;

        private JSDocBinder(boolean allowExtraLineBreak) {
            this.myAllowExtraLineBreak = allowExtraLineBreak;
        }

        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter) {
            CharSequence tokenText;
            IElementType type;
            int i2 = tokens.size() - 1;
            IElementType iElementType = type = i2 >= 0 ? tokens.get(i2) : null;
            while (!(type != JSElementTypes.WHITE_SPACE && type != JSElementTypes.END_OF_LINE_COMMENT || !this.myAllowExtraLineBreak && type == JSElementTypes.WHITE_SPACE && (tokenText = getter.get(i2)).chars().filter(c -> c == 10).count() > 1L)) {
                type = --i2 >= 0 ? tokens.get(i2) : null;
            }
            if (type == JSElementTypes.DOC_COMMENT) {
                return i2;
            }
            return tokens.size();
        }
    }

    public static enum ForceContext {
        Type,
        TypeAllowEmpty,
        Parameter;

    }
}

