/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.psi.manipulators;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.MongoJSChangeUtil;
import com.intellij.sql.dialects.mongo.js.MongoJSStringUtil;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSStringTemplateExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J \u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/dialects/mongo/js/psi/manipulators/MongoJSStringManipulator;", "Lcom/intellij/psi/AbstractElementManipulator;", "Lcom/intellij/sql/dialects/mongo/js/psi/MongoJSStringTemplateExpression;", "()V", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "element", "handleContentChange", "range", "newContent", "", "intellij.database.dialects.mongo"})
public final class MongoJSStringManipulator
extends AbstractElementManipulator<MongoJSStringTemplateExpression> {
    @NotNull
    public TextRange getRangeInElement(@NotNull MongoJSStringTemplateExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        int length = element.getTextLength();
        if (element.isQuotedLiteral() && length >= 2) {
            int startOffset = 1;
            ASTNode quotedLiteralNode = element.getNode();
            ASTNode backquote = quotedLiteralNode.findChildByType(JSElementTypes.BACKQUOTE);
            if (backquote != null) {
                int n = backquote.getStartOffset();
                ASTNode aSTNode = quotedLiteralNode;
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"quotedLiteralNode");
                startOffset = n - aSTNode.getStartOffset() + 1;
            }
            return new TextRange(startOffset, length - 1);
        }
        return new TextRange(0, length);
    }

    @NotNull
    public MongoJSStringTemplateExpression handleContentChange(@NotNull MongoJSStringTemplateExpression element, @NotNull TextRange range, @NotNull String newContent) {
        MongoJSStringTemplateExpression mongoJSStringTemplateExpression;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        String escapedContent = MongoJSStringUtil.escapeTemplateStringChars(newContent, false, false, element);
        String string = range.replace(element.getText(), escapedContent);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"range.replace(element.text, escapedContent)");
        String newText = string;
        ASTNode aSTNode = MongoJSChangeUtil.createExpressionFromText(element.getProject(), newText);
        Object object = aSTNode != null ? aSTNode.getPsi() : null;
        if (!(object instanceof MongoJSStringTemplateExpression)) {
            object = null;
        }
        if ((mongoJSStringTemplateExpression = (MongoJSStringTemplateExpression)object) == null) {
            mongoJSStringTemplateExpression = element;
        }
        MongoJSStringTemplateExpression newElement = mongoJSStringTemplateExpression;
        PsiElement psiElement = element.replace(newElement);
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.dialects.mongo.js.psi.MongoJSStringTemplateExpression");
        }
        return (MongoJSStringTemplateExpression)psiElement;
    }
}

