/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle;

import com.intellij.database.dialects.oracle.generator.OraNamingService;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraModelUtils;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.SqlTypeSystemBase;
import com.intellij.sql.dialects.oracle.OraCanonicalSignature;
import com.intellij.sql.dialects.oracle.OraCanonicalType;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.psi.OraCollectionTypeElementImpl;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlCreateTypeStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTypeDefinitionImpl;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraTypeSystem
extends SqlTypeSystemBase {
    public static final OraTypeSystem INSTANCE = new OraTypeSystem();
    private static final String STRING_ROOT = "CHAR";
    private static final Map<String, String> PREDEFINED_FAMILY_ROOTS = new ContainerUtil.ImmutableMapBuilder().put((Object)"DATE", (Object)"DATE").put((Object)"TIME", (Object)"DATE").put((Object)"TIMESTAMP", (Object)"DATE").put((Object)"TIME WITH TIME ZONE", (Object)"DATE").put((Object)"TIMESTAMP WITH TIME ZONE", (Object)"DATE").put((Object)"INTERVAL YEAR TO MONTH", (Object)"DATE").put((Object)"INTERVAL DAY TO SECOND", (Object)"DATE").put((Object)"TIMESTAMP WITH LOCAL TIME ZONE", (Object)"DATE").put((Object)"TIME_UNCONSTRAINED", (Object)"DATE").put((Object)"TIME_TZ_UNCONSTRAINED", (Object)"DATE").put((Object)"TIMESTAMP_UNCONSTRAINED", (Object)"DATE").put((Object)"TIMESTAMP_TZ_UNCONSTRAINED", (Object)"DATE").put((Object)"YMINTERVAL_UNCONSTRAINED", (Object)"DATE").put((Object)"DSINTERVAL_UNCONSTRAINED", (Object)"DATE").put((Object)"TIMESTAMP_LTZ_UNCONSTRAINED", (Object)"DATE").put((Object)"NUMBER", (Object)"NUMBER").put((Object)"FLOAT", (Object)"NUMBER").put((Object)"REAL", (Object)"NUMBER").put((Object)"DOUBLE PRECISION", (Object)"NUMBER").put((Object)"INTEGER", (Object)"NUMBER").put((Object)"INT", (Object)"NUMBER").put((Object)"SMALLINT", (Object)"NUMBER").put((Object)"DECIMAL", (Object)"NUMBER").put((Object)"NUMERIC", (Object)"NUMBER").put((Object)"DEC", (Object)"NUMBER").put((Object)"BINARY_INTEGER", (Object)"BINARY_INTEGER").put((Object)"NATURAL", (Object)"BINARY_INTEGER").put((Object)"NATURALN", (Object)"BINARY_INTEGER").put((Object)"POSITIVE", (Object)"BINARY_INTEGER").put((Object)"POSITIVEN", (Object)"BINARY_INTEGER").put((Object)"SIGNTYPE", (Object)"BINARY_INTEGER").put((Object)"PLS_INTEGER", (Object)"BINARY_INTEGER").put((Object)"SIMPLE_INTEGER", (Object)"BINARY_INTEGER").put((Object)"BINARY_FLOAT", (Object)"BINARY_FLOAT").put((Object)"SIMPLE_FLOAT", (Object)"BINARY_FLOAT").put((Object)"BINARY_DOUBLE", (Object)"BINARY_DOUBLE").put((Object)"SIMPLE_DOUBLE", (Object)"BINARY_DOUBLE").put((Object)"CHAR", (Object)"CHAR").put((Object)"VARCHAR", (Object)"CHAR").put((Object)"VARCHAR2", (Object)"CHAR").put((Object)"CHAR VARYING", (Object)"CHAR").put((Object)"CHARACTER", (Object)"CHAR").put((Object)"CHARACTER VARYING", (Object)"CHAR").put((Object)"NCHAR", (Object)"CHAR").put((Object)"NVARCHAR2", (Object)"CHAR").put((Object)"NCHAR VARYING", (Object)"CHAR").put((Object)"NATIONAL CHAR", (Object)"CHAR").put((Object)"NATIONAL CHAR VARYING", (Object)"CHAR").put((Object)"NATIONAL CHARACTER", (Object)"CHAR").put((Object)"NATIONAL CHARACTER VARYING", (Object)"CHAR").put((Object)"STRING", (Object)"CHAR").put((Object)"LONG", (Object)"CHAR").put((Object)"RAW", (Object)"CHAR").put((Object)"LONG RAW", (Object)"CHAR").put((Object)"UROWID", (Object)"CHAR").put((Object)"CLOB", (Object)"CLOB").put((Object)"CHAR LARGE OBJECT", (Object)"CLOB").put((Object)"CHARACTER LARGE OBJECT", (Object)"CLOB").put((Object)"NCLOB", (Object)"CLOB").put((Object)"NCHAR LARGE OBJECT", (Object)"CLOB").put((Object)"NATIONAL CHARACTER LARGE OBJECT", (Object)"CLOB").put((Object)"BLOB", (Object)"BLOB").put((Object)"BINARY LARGE OBJECT", (Object)"BLOB").put((Object)"BOOLEAN", (Object)"BOOLEAN").put((Object)"ANYDATA", (Object)"ANYDATA").put((Object)"ANYTYPE", (Object)"ANYTYPE").put((Object)"ANYDATASET", (Object)"ANYDATASET").put((Object)"ROWID", (Object)"ROWID").put((Object)"MLSLABEL", (Object)"MLSLABEL").put((Object)"BFILE", (Object)"BFILE").put((Object)"SYS_REFCURSOR", (Object)"SYS_REFCURSOR").build();
    private static final Set<String> BLOB_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"BLOB", "BINARY LARGE OBJECT"});
    private static final Set<String> CLOB_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"CLOB", "CHAR LARGE OBJECT", "CHARACTER LARGE OBJECT", "NCLOB", "NCHAR LARGE OBJECT", "NATIONAL CHARACTER LARGE OBJECT"});
    private static final Set<String> LONG_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"LONG", "LONG RAW"});
    private static final Map<String, SqlTypeSystemBase.DeprecatedTypeInfo> DEPRECATED_TYPES = Collections.singletonMap("long", new SqlTypeSystemBase.DeprecatedTypeInfo("inspection.message.deprecated.type.oracle.long.description", Arrays.asList("clob", "nclob", "blob")));

    private OraTypeSystem() {
        super((SqlLanguageDialectEx)OraDialect.INSTANCE);
    }

    @NotNull
    public String getNormalizedTypeName(@NotNull String name2) {
        if (name2 == null) {
            OraTypeSystem.$$$reportNull$$$0(0);
        }
        if ((name2 = super.getNormalizedTypeName(name2)).equals("LONG VARCHAR")) {
            return "LONG";
        }
        if (name2.equals("NUMERIC")) {
            return "NUMBER";
        }
        if (name2.equals("DECIMAL")) {
            return "NUMBER";
        }
        if (name2.equals("DEC")) {
            return "NUMBER";
        }
        if (name2.equals("INTEGER")) {
            return "NUMBER";
        }
        if (name2.equals("INT")) {
            return "NUMBER";
        }
        if (name2.equals("SMALLINT")) {
            return "NUMBER";
        }
        if (name2.equals("DOUBLE PRECISION")) {
            return "FLOAT";
        }
        if (name2.equals("REAL")) {
            return "FLOAT";
        }
        String string = name2;
        if (string == null) {
            OraTypeSystem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            OraTypeSystem.$$$reportNull$$$0(2);
        }
        switch (cat) {
            case INTEGER: {
                return "number";
            }
            case REAL: {
                return "float";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE_TIME: {
                return "timestamp";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "timestamp";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "interval";
            }
            case BYTES: {
                return "blob";
            }
            case ARRAY: {
                return "varray";
            }
        }
        return null;
    }

    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            OraTypeSystem.$$$reportNull$$$0(3);
        }
        if ("BINARY_FLOAT".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(4);
            }
            return category;
        }
        if ("BINARY_DOUBLE".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(5);
            }
            return category;
        }
        if ("LONG".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(6);
            }
            return category;
        }
        if ("LONG RAW".equals(typeName)) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(7);
            }
            return category;
        }
        if ("BFILE".equals(typeName)) {
            SqlType.Category category = SqlType.Category.BYTES;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(8);
            }
            return category;
        }
        if ("ROWID".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(9);
            }
            return category;
        }
        if ("UROWID".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTEGER;
            if (category == null) {
                OraTypeSystem.$$$reportNull$$$0(10);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            OraTypeSystem.$$$reportNull$$$0(11);
        }
        return category;
    }

    public boolean supportsImplicitConversion(@NotNull DataType fromType, @NotNull DataType toType) {
        if (fromType == null) {
            OraTypeSystem.$$$reportNull$$$0(12);
        }
        if (toType == null) {
            OraTypeSystem.$$$reportNull$$$0(13);
        }
        if (fromType.equals(toType)) {
            return true;
        }
        Case plainCase = OraNamingService.INSTANCE.getDefaultCasing().plain;
        String fromTypeName = plainCase.apply(fromType.typeName);
        String toTypeName = plainCase.apply(toType.typeName);
        if (!PREDEFINED_FAMILY_ROOTS.containsKey(fromTypeName) || !PREDEFINED_FAMILY_ROOTS.containsKey(toTypeName)) {
            return true;
        }
        String fromRoot = PREDEFINED_FAMILY_ROOTS.get(fromTypeName);
        String toRoot = PREDEFINED_FAMILY_ROOTS.get(toTypeName);
        if (toRoot.equals(STRING_ROOT)) {
            return !BLOB_TYPES.contains(fromTypeName);
        }
        if (fromRoot.equals(STRING_ROOT)) {
            return !BLOB_TYPES.contains(toTypeName);
        }
        SqlType.Category fromCategory = this.getTypeCategory(fromType);
        SqlType.Category toCategory = this.getTypeCategory(toType);
        if (fromCategory == SqlType.Category.INTEGER) {
            return toCategory == fromCategory || toCategory == SqlType.Category.REAL;
        }
        if (fromCategory == SqlType.Category.REAL) {
            return toCategory == fromCategory || toCategory == SqlType.Category.INTEGER;
        }
        if (fromCategory == SqlType.Category.INTERVAL || fromCategory == SqlType.Category.DATE_TIME || fromCategory == SqlType.Category.TIMESTAMP) {
            return toCategory == fromCategory || LONG_TYPES.contains(toTypeName);
        }
        if (fromTypeName.equals("RAW")) {
            return LONG_TYPES.contains(toTypeName) || BLOB_TYPES.contains(toTypeName);
        }
        if (BLOB_TYPES.contains(fromTypeName)) {
            return BLOB_TYPES.contains(toTypeName) || toTypeName.equals("RAW");
        }
        if (LONG_TYPES.contains(fromTypeName)) {
            return toTypeName.equals("RAW") || CLOB_TYPES.contains(toTypeName);
        }
        if (CLOB_TYPES.contains(fromTypeName)) {
            return LONG_TYPES.contains(toTypeName) || CLOB_TYPES.contains(toTypeName);
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public OraCanonicalSignature getCanonicalSignature(@NotNull DasRoutine routine2, @NotNull Project project) {
        if (routine2 == null) {
            OraTypeSystem.$$$reportNull$$$0(14);
        }
        if (project == null) {
            OraTypeSystem.$$$reportNull$$$0(15);
        }
        ObjectName name2 = new ObjectName(routine2.getName(), routine2.isQuoted());
        @NotNull List parameterTypes = DasUtil.getParameters((DasRoutine)routine2).filterMap(argument -> OraTypeSystem.getCanonicalType(argument, project)).toList();
        DasObject dasParent = routine2.getDasParent();
        ObjectKind parentKind = dasParent != null ? dasParent.getKind() : null;
        boolean isHeader = routine2 instanceof SqlRoutineDefinition && ((SqlRoutineDefinition)routine2).getBody().isEmpty() || parentKind == ObjectKind.PACKAGE || parentKind == ObjectKind.OBJECT_TYPE;
        return new OraCanonicalSignature(name2, routine2.getRoutineKind(), isHeader, parameterTypes);
    }

    @NotNull
    public Map<String, SqlTypeSystemBase.DeprecatedTypeInfo> getDeprecatedTypes(@NotNull PsiFile contextFile) {
        if (contextFile == null) {
            OraTypeSystem.$$$reportNull$$$0(16);
        }
        Map<String, SqlTypeSystemBase.DeprecatedTypeInfo> map2 = DEPRECATED_TYPES;
        if (map2 == null) {
            OraTypeSystem.$$$reportNull$$$0(17);
        }
        return map2;
    }

    @NotNull
    private static OraCanonicalType getCanonicalType(@NotNull DataType dataType) {
        if (dataType == null) {
            OraTypeSystem.$$$reportNull$$$0(18);
        }
        String typeName = OraNamingService.INSTANCE.getDefaultCasing().plain.apply(dataType.typeName);
        String intrinsicRootName = PREDEFINED_FAMILY_ROOTS.get(typeName);
        ObjectPath path = ObjectPath.create((String)Objects.requireNonNullElse(intrinsicRootName, dataType.getSpecification()), (ObjectKind)ObjectKind.OBJECT_TYPE);
        return new OraCanonicalType(path);
    }

    @Nullable
    private static DasUserDefinedType getTypeDefinition(@NotNull DasArgument argument) {
        if (argument == null) {
            OraTypeSystem.$$$reportNull$$$0(19);
        }
        if (argument instanceof SqlParameterDefinition) {
            SqlTypeElement typeElement = ((SqlParameterDefinition)argument).getTypeElement();
            if (typeElement == null) {
                return null;
            }
            SqlReferenceExpression typeRef = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)typeElement, SqlReferenceExpression.class);
            if (typeRef == null) {
                return null;
            }
            PsiElement typeDefinition = typeRef.resolve();
            return typeDefinition instanceof DasUserDefinedType ? (DasUserDefinedType)typeDefinition : null;
        }
        return argument instanceof BasicElement ? OraModelUtils.resolveTypeDefinition(argument.getDataType(), (BasicElement)argument) : null;
    }

    @NotNull
    private static OraCanonicalType getCanonicalType(@NotNull DasArgument argument, @NotNull Project project) {
        DasUserDefinedType typeDefinition;
        if (argument == null) {
            OraTypeSystem.$$$reportNull$$$0(20);
        }
        if (project == null) {
            OraTypeSystem.$$$reportNull$$$0(21);
        }
        if ((typeDefinition = OraTypeSystem.getTypeDefinition(argument)) == null) {
            return OraTypeSystem.getCanonicalType(argument.getDataType());
        }
        OraCanonicalType oraCanonicalType = (OraCanonicalType)((ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.create(OraTypeSystem::computeCanonicalType, ContainerUtil::createConcurrentSoftValueMap), (Object[])new Object[]{DbPsiFacade.getInstance((Project)project), PsiModificationTracker.MODIFICATION_COUNT}))).get(typeDefinition);
        if (oraCanonicalType == null) {
            OraTypeSystem.$$$reportNull$$$0(22);
        }
        return oraCanonicalType;
    }

    private static boolean isCollectionType(@NotNull DasUserDefinedType type) {
        DasUserDefinedType typeDef;
        if (type == null) {
            OraTypeSystem.$$$reportNull$$$0(23);
        }
        if ((typeDef = type) instanceof DbCustomType) {
            typeDef = (DasUserDefinedType)((DbCustomType)type).getDelegate();
        }
        return typeDef instanceof OraCollectionType || typeDef instanceof SqlTypeDefinitionImpl && ((SqlTypeDefinitionImpl)typeDef).getAliasedTypeElement() instanceof OraCollectionTypeElementImpl;
    }

    public static boolean isObjectType(@NotNull DasUserDefinedType type) {
        DasUserDefinedType typeDef;
        if (type == null) {
            OraTypeSystem.$$$reportNull$$$0(24);
        }
        if ((typeDef = type) instanceof DbCustomType) {
            typeDef = (DasUserDefinedType)((DbCustomType)type).getDelegate();
        }
        if (typeDef instanceof OraObjectType) {
            return true;
        }
        if (typeDef instanceof SqlCreateTypeStatementImpl) {
            return SqlImplUtil.sqlChildren((PsiElement)((PsiElement)typeDef)).find(e2 -> {
                IElementType elementType = PsiUtilCore.getElementType((PsiElement)e2);
                return elementType == OraTypes.ORA_OBJECT || elementType == OraTypes.ORA_TYPE_INHERITS_CLAUSE;
            }) != null;
        }
        return false;
    }

    @NotNull
    private static OraCanonicalType computeCanonicalType(@NotNull DasUserDefinedType typeDefinition) {
        if (typeDefinition == null) {
            OraTypeSystem.$$$reportNull$$$0(25);
        }
        DasUserDefinedType type = typeDefinition;
        while (!OraTypeSystem.isCollectionType(type) && !OraTypeSystem.isObjectType(type)) {
            DasUserDefinedType superType = type.getSuperType();
            if (superType == null) {
                DataType dataType = type.getSuperDataType();
                return dataType == null || dataType.typeName.equals("table") ? new OraCanonicalType(ObjectPaths.of((DasObject)type)) : OraTypeSystem.getCanonicalType(dataType);
            }
            type = superType;
        }
        return new OraCanonicalType(ObjectPaths.of((DasObject)type));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/OraTypeSystem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/OraTypeSystem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeprecatedTypes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "supportsImplicitConversion";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalSignature";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedTypes";
                break;
            }
            case 18: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDefinition";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isCollectionType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isObjectType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "computeCanonicalType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

