/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.oracle.OraTypeService;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.impl.SqlBinaryExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OraBinaryExpressionImpl
extends SqlBinaryExpressionImpl {
    private static final Map<DasBuiltinType, DasBuiltinType> numberRoots = new ContainerUtil.ImmutableMapBuilder().put((Object)OraTypeService.NATURAL, (Object)OraTypeService.BINARY_INTEGER).put((Object)OraTypeService.POSITIVE, (Object)OraTypeService.BINARY_INTEGER).put((Object)OraTypeService.SIGNTYPE, (Object)OraTypeService.BINARY_INTEGER).put((Object)OraTypeService.NATURALN, (Object)OraTypeService.SIMPLE_INTEGER).put((Object)OraTypeService.POSITIVEN, (Object)OraTypeService.SIMPLE_INTEGER).build();

    private static boolean isBinaryInt(@NotNull DasBuiltinType type) {
        if (type == null) {
            OraBinaryExpressionImpl.$$$reportNull$$$0(0);
        }
        return type == OraTypeService.BINARY_INTEGER || type == OraTypeService.SIMPLE_INTEGER;
    }

    public OraBinaryExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            OraBinaryExpressionImpl.$$$reportNull$$$0(1);
        }
        super(elementType);
    }

    @NotNull
    public DasType getDasType() {
        DasType dasType = SqlImplUtil.getCacheableDasType((PsiElement)this, () -> {
            IElementType sign = this.getOpSign();
            if (sign == SqlCommonKeywords.SQL_AND || sign == SqlCommonKeywords.SQL_OR) {
                return OraTypeService.BOOLEAN;
            }
            if (sign == SqlCommonKeywords.SQL_IS) {
                return OraTypeService.BOOLEAN;
            }
            if (sign == SqlCommonKeywords.SQL_IN) {
                return OraTypeService.BOOLEAN;
            }
            if (sign == OraTypes.ORA_OP_EQ || sign == OraTypes.ORA_OP_GE || sign == OraTypes.ORA_SQL_OP_GE_WS || sign == OraTypes.ORA_OP_GT || sign == OraTypes.ORA_OP_LE || sign == OraTypes.ORA_SQL_OP_LE_WS || sign == OraTypes.ORA_OP_LT || sign == OraTypes.ORA_OP_NEQ || sign == OraTypes.ORA_OP_NEQ2 || sign == OraTypes.ORA_OP_NEQ3 || sign == OraTypes.ORA_OP_NEQ4 || sign == OraTypes.ORA_SQL_OP_NEQ_WS || sign == OraTypes.ORA_SQL_OP_NEQ2_WS || sign == OraTypes.ORA_SQL_OP_NEQ3_WS || sign == OraTypes.ORA_SQL_OP_NEQ4_WS) {
                return OraTypeService.BOOLEAN;
            }
            if (sign == OraTypes.ORA_LIKE || sign == OraTypes.ORA_LIKEC || sign == OraTypes.ORA_LIKE2 || sign == OraTypes.ORA_LIKE4) {
                return OraTypeService.BOOLEAN;
            }
            if (sign == OraTypes.ORA_MEMBER || sign == OraTypes.ORA_SUBMULTISET) {
                return OraTypeService.BOOLEAN;
            }
            if (sign == OraTypes.ORA_OVERLAPS) {
                return OraTypeService.BOOLEAN;
            }
            if (sign == OraTypes.ORA_OP_CONCAT) {
                return OraTypeService.VARCHAR2;
            }
            SqlExpression lOperand = this.getLOperand();
            if (sign == SqlCommonTokens.SQL_LEFT_BRACKET) {
                return lOperand.getDasType();
            }
            DasBuiltinType lType = (DasBuiltinType)ObjectUtils.tryCast((Object)lOperand.getDasType(), DasBuiltinType.class);
            if (lType == null) {
                return DasType.UNKNOWN;
            }
            SqlExpression rOperand = this.getROperand();
            if (rOperand == null) {
                return lType;
            }
            DasBuiltinType rType = (DasBuiltinType)ObjectUtils.tryCast((Object)rOperand.getDasType(), DasBuiltinType.class);
            if (rType == null) {
                return DasType.UNKNOWN;
            }
            if (lType.getKind() == DasBuiltinType.Kind.NUMBER && rType.getKind() == DasBuiltinType.Kind.NUMBER && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS || sign == OraTypes.ORA_OP_MUL || sign == OraTypes.ORA_OP_DIV || sign == OraTypes.ORA_POWER)) {
                lType = numberRoots.getOrDefault(lType, lType);
                rType = numberRoots.getOrDefault(rType, rType);
                if (lType.equals(OraTypeService.BINARY_DOUBLE) || rType.equals(OraTypeService.BINARY_DOUBLE)) {
                    return OraTypeService.BINARY_DOUBLE;
                }
                if (lType.equals(OraTypeService.BINARY_FLOAT) || rType.equals(OraTypeService.BINARY_FLOAT)) {
                    return OraTypeService.BINARY_FLOAT;
                }
                if (sign == OraTypes.ORA_OP_DIV) {
                    return OraTypeService.NUMBER;
                }
                if (lType.equals(OraTypeService.SIMPLE_INTEGER) && rType.equals(OraTypeService.SIMPLE_INTEGER)) {
                    return OraTypeService.SIMPLE_INTEGER;
                }
                if (OraBinaryExpressionImpl.isBinaryInt(lType) && OraBinaryExpressionImpl.isBinaryInt(rType)) {
                    return OraTypeService.BINARY_INTEGER;
                }
                return OraTypeService.NUMBER;
            }
            if (lType.getKind() == DasBuiltinType.Kind.DATE) {
                if (rType.getKind() == DasBuiltinType.Kind.DATE && sign == OraTypes.ORA_OP_MINUS) {
                    return OraTypeService.NUMBER;
                }
                if (!(rType.getKind() != DasBuiltinType.Kind.NUMBER && rType.getKind() != DasBuiltinType.Kind.INTERVAL || sign != OraTypes.ORA_OP_PLUS && sign != OraTypes.ORA_OP_MINUS)) {
                    return lType;
                }
                if (rType.getKind() == DasBuiltinType.Kind.TIMESTAMP && sign == OraTypes.ORA_OP_MINUS) {
                    return OraTypeService.INTERVAL_DAY_TO_SECOND;
                }
            }
            if (lType.getKind() == DasBuiltinType.Kind.TIMESTAMP) {
                if (rType.getKind() == DasBuiltinType.Kind.INTERVAL && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS)) {
                    return lType;
                }
                if (rType.getKind() == DasBuiltinType.Kind.NUMBER && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS)) {
                    return OraTypeService.DATE;
                }
                if ((rType.getKind() == DasBuiltinType.Kind.TIMESTAMP || rType.getKind() == DasBuiltinType.Kind.DATE) && sign == OraTypes.ORA_OP_MINUS) {
                    return OraTypeService.INTERVAL_DAY_TO_SECOND;
                }
            }
            if (lType.getKind() == DasBuiltinType.Kind.INTERVAL) {
                if (rType.equals(lType) && (sign == OraTypes.ORA_OP_PLUS || sign == OraTypes.ORA_OP_MINUS)) {
                    return lType;
                }
                if ((rType.getKind() == DasBuiltinType.Kind.DATE || rType.getKind() == DasBuiltinType.Kind.TIMESTAMP) && sign == OraTypes.ORA_OP_PLUS) {
                    return rType;
                }
                if (rType.getKind() == DasBuiltinType.Kind.NUMBER && (sign == OraTypes.ORA_OP_MUL || sign == OraTypes.ORA_OP_DIV)) {
                    return lType;
                }
            }
            if (lType.getKind() == DasBuiltinType.Kind.NUMBER) {
                if ((rType.getKind() == DasBuiltinType.Kind.TIMESTAMP || rType.getKind() == DasBuiltinType.Kind.DATE) && sign == OraTypes.ORA_OP_PLUS) {
                    return OraTypeService.DATE;
                }
                if (rType.getKind() == DasBuiltinType.Kind.INTERVAL && sign == OraTypes.ORA_OP_MUL) {
                    return rType;
                }
            }
            return DasType.UNKNOWN;
        });
        if (dasType == null) {
            OraBinaryExpressionImpl.$$$reportNull$$$0(2);
        }
        return dasType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/psi/OraBinaryExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/psi/OraBinaryExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryInt";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

