/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.dialects.oracle.types.OraIntervalType;
import com.intellij.database.dialects.oracle.types.OraTimeAwareType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeWithLength;
import com.intellij.database.types.DasBuiltinTypeWithLengthUnits;
import com.intellij.database.types.DasBuiltinTypeWithPrecision;
import com.intellij.database.types.DasBuiltinWrapperType;
import com.intellij.database.types.DasType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.base.SqlCommonTypes;
import com.intellij.sql.dialects.oracle.OraTypeService;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTypeElementImpl;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraBuiltinTypeElementImpl
extends SqlTypeElementImpl {
    public OraBuiltinTypeElementImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    private static int parseIntAttribute(@Nullable PsiElement attributePsi, int defaultValue) {
        if (attributePsi == null) {
            return defaultValue;
        }
        String text = attributePsi.getText();
        if (text.equals("*")) {
            return 0x7FFFFFFE;
        }
        return StringUtil.parseInt((String)text, (int)defaultValue);
    }

    @Nullable
    private PsiElement getIntAttributePsi(@Nullable PsiElement after) {
        JBIterable elements2 = after != null ? SqlImplUtil.siblings((PsiElement)after).skip(1) : SqlImplUtil.sqlChildren((PsiElement)this);
        return (PsiElement)elements2.filter(e2 -> {
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)e2);
            return elementType == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || elementType == SqlCommonTypes.SQL_ASTERISK;
        }).first();
    }

    private int getIntAttribute() {
        return OraBuiltinTypeElementImpl.parseIntAttribute(this.getIntAttributePsi(null), -1);
    }

    @NotNull
    private DasBuiltinTypeWithPrecision adjustTypeWithPrecision(@NotNull DasBuiltinTypeWithPrecision dasType) {
        PsiElement precisionPsi;
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(1);
        }
        if ((precisionPsi = this.getIntAttributePsi(null)) == null) {
            DasBuiltinTypeWithPrecision dasBuiltinTypeWithPrecision = dasType;
            if (dasBuiltinTypeWithPrecision == null) {
                OraBuiltinTypeElementImpl.$$$reportNull$$$0(2);
            }
            return dasBuiltinTypeWithPrecision;
        }
        int precision = OraBuiltinTypeElementImpl.parseIntAttribute(precisionPsi, -1);
        PsiElement scalePsi = this.getIntAttributePsi(precisionPsi);
        int scale = OraBuiltinTypeElementImpl.parseIntAttribute(scalePsi, 0);
        DasBuiltinTypeWithPrecision dasBuiltinTypeWithPrecision = dasType.copy(dasType.getName(), precision, scale);
        if (dasBuiltinTypeWithPrecision == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(3);
        }
        return dasBuiltinTypeWithPrecision;
    }

    @NotNull
    private DasBuiltinTypeWithLength adjustTypeWithLength(@NotNull DasBuiltinTypeWithLength dasType) {
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(4);
        }
        DasBuiltinTypeWithLength dasBuiltinTypeWithLength = dasType.copy(dasType.getName(), dasType.getKind(), this.getIntAttribute());
        if (dasBuiltinTypeWithLength == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(5);
        }
        return dasBuiltinTypeWithLength;
    }

    @NotNull
    private LengthUnit getLengthUnit() {
        PsiElement lParen = this.findPsiChildByType(SqlCommonTypes.SQL_LEFT_PAREN);
        if (lParen == null) {
            LengthUnit lengthUnit = LengthUnit.NONE;
            if (lengthUnit == null) {
                OraBuiltinTypeElementImpl.$$$reportNull$$$0(6);
            }
            return lengthUnit;
        }
        LengthUnit lengthUnit = PsiTreeUtil.findSiblingForward((PsiElement)lParen, (IElementType)OraTypes.ORA_BYTE, null) != null ? LengthUnit.BYTE : (PsiTreeUtil.findSiblingForward((PsiElement)lParen, (IElementType)OraTypes.ORA_CHAR, null) != null ? LengthUnit.CHAR : LengthUnit.NONE);
        if (lengthUnit == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(7);
        }
        return lengthUnit;
    }

    @NotNull
    private DasBuiltinTypeWithLengthUnits adjustTypeWithLengthUnits(@NotNull DasBuiltinTypeWithLengthUnits dasType) {
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(8);
        }
        int length = this.getIntAttribute();
        LengthUnit unit = this.getLengthUnit();
        DasBuiltinTypeWithLengthUnits dasBuiltinTypeWithLengthUnits = dasType.copy(dasType.getName(), length, unit, unit != LengthUnit.NONE);
        if (dasBuiltinTypeWithLengthUnits == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(9);
        }
        return dasBuiltinTypeWithLengthUnits;
    }

    @NotNull
    private OraTimeAwareType adjustTimeAwareType(@NotNull OraTimeAwareType dasType) {
        OraTimeAwareType.TimeZoneKind timeZoneKind;
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(10);
        }
        int size = this.getIntAttribute();
        OraTimeAwareType.TimeZoneKind timeZoneKind2 = this.findPsiChildByType(OraTypes.ORA_LOCAL) != null ? OraTimeAwareType.TimeZoneKind.LOCAL_TZ : (timeZoneKind = this.findPsiChildByType(OraTypes.ORA_ZONE) != null ? OraTimeAwareType.TimeZoneKind.TZ : OraTimeAwareType.TimeZoneKind.NONE);
        if (size == -1) {
            OraTimeAwareType oraTimeAwareType = OraTypeService.withTimeZone(dasType, timeZoneKind);
            if (oraTimeAwareType == null) {
                OraBuiltinTypeElementImpl.$$$reportNull$$$0(11);
            }
            return oraTimeAwareType;
        }
        OraTimeAwareType oraTimeAwareType = dasType.copy(dasType.getName(), dasType.getKind(), size, timeZoneKind);
        if (oraTimeAwareType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(12);
        }
        return oraTimeAwareType;
    }

    @NotNull
    private OraIntervalType.YearToMonth adjustYMInterval(@NotNull OraIntervalType.YearToMonth dasType) {
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(13);
        }
        OraIntervalType.YearToMonth yearToMonth = dasType.copy(this.getIntAttribute());
        if (yearToMonth == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(14);
        }
        return yearToMonth;
    }

    @NotNull
    private OraIntervalType.DayToSecond adjustDSInterval(@NotNull OraIntervalType.DayToSecond dasType) {
        PsiElement secondPsi;
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(15);
        }
        PsiElement dayKeyword = this.findPsiChildByType((IElementType)SqlCommonKeywords.SQL_DAY);
        PsiElement secondKeyword = this.findPsiChildByType((IElementType)SqlCommonKeywords.SQL_SECOND);
        PsiElement dayPsi = this.getIntAttributePsi(dayKeyword);
        if (dayPsi == (secondPsi = this.getIntAttributePsi(secondKeyword))) {
            dayPsi = null;
        }
        int dayLength = OraBuiltinTypeElementImpl.parseIntAttribute(dayPsi, -1);
        int secondLength = OraBuiltinTypeElementImpl.parseIntAttribute(secondPsi, 0);
        OraIntervalType.DayToSecond dayToSecond = dasType.copy(dayLength, secondLength);
        if (dayToSecond == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(16);
        }
        return dayToSecond;
    }

    private static boolean isCharacterSet(@NotNull PsiElement element) {
        if (element == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(17);
        }
        return PsiUtilCore.getElementType((PsiElement)element) == OraTypes.ORA_CHARACTER && PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element)) == OraTypes.ORA_SET;
    }

    @Nullable
    private DasType parseBuiltinTypeBase() {
        IElementType starterType = PsiUtilCore.getElementType((PsiElement)this.getFirstChild());
        if (starterType == OraTypes.ORA_INTERVAL) {
            return this.findChildByType(OraTypes.ORA_YEAR) != null ? OraTypeService.INTERVAL_YEAR_TO_MONTH : (this.findChildByType(OraTypes.ORA_DAY) != null ? OraTypeService.INTERVAL_DAY_TO_SECOND : null);
        }
        JBIterable keywords = SqlImplUtil.sqlChildren((PsiElement)this).filter(e2 -> !(e2 instanceof PsiWhiteSpace) && !(e2 instanceof PsiComment)).takeWhile(e2 -> {
            if (OraBuiltinTypeElementImpl.isCharacterSet(e2)) {
                return false;
            }
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)e2);
            return elementType instanceof SqlKeywordTokenType && elementType != OraTypes.ORA_WITH;
        });
        String name2 = StringUtil.toUpperCase((String)StringUtil.join((Iterable)keywords, kw -> kw.getText(), (String)" "));
        return OraTypeService.predefinedTypes.get(name2);
    }

    @NotNull
    private DasBuiltinType adjustType(@NotNull DasBuiltinType dasType) {
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(18);
        }
        if (dasType instanceof DasBuiltinTypeWithPrecision) {
            return this.adjustTypeWithPrecision((DasBuiltinTypeWithPrecision)dasType);
        }
        if (dasType instanceof DasBuiltinTypeWithLength) {
            return this.adjustTypeWithLength((DasBuiltinTypeWithLength)dasType);
        }
        if (dasType instanceof DasBuiltinTypeWithLengthUnits) {
            return this.adjustTypeWithLengthUnits((DasBuiltinTypeWithLengthUnits)dasType);
        }
        if (dasType instanceof OraTimeAwareType) {
            return this.adjustTimeAwareType((OraTimeAwareType)dasType);
        }
        if (dasType instanceof OraIntervalType.YearToMonth) {
            return this.adjustYMInterval((OraIntervalType.YearToMonth)dasType);
        }
        if (dasType instanceof OraIntervalType.DayToSecond) {
            return this.adjustDSInterval((OraIntervalType.DayToSecond)dasType);
        }
        DasBuiltinType dasBuiltinType = dasType;
        if (dasBuiltinType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(19);
        }
        return dasBuiltinType;
    }

    @NotNull
    public DasType getDasType() {
        DasType dasType = SqlImplUtil.getCacheableDasType((PsiElement)this, () -> {
            DasType dasType = this.parseBuiltinTypeBase();
            if (dasType == null) {
                return DasType.UNKNOWN;
            }
            if (!(dasType instanceof DasBuiltinType)) {
                return dasType;
            }
            if (dasType instanceof DasBuiltinWrapperType) {
                return ((DasBuiltinWrapperType)dasType).transform(this::adjustType);
            }
            return this.adjustType((DasBuiltinType)dasType);
        });
        if (dasType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(20);
        }
        return dasType;
    }

    @NotNull
    public DataType getDataType() {
        DasType dasType = this.getDasType();
        DataType dataType = dasType instanceof DasBuiltinType ? ((DasBuiltinType)dasType).toDataType() : super.getDataType();
        if (dataType == null) {
            OraBuiltinTypeElementImpl.$$$reportNull$$$0(21);
        }
        return dataType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/psi/OraBuiltinTypeElementImpl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/psi/OraBuiltinTypeElementImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTypeWithPrecision";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTypeWithLength";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLengthUnit";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTypeWithLengthUnits";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTimeAwareType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustYMInterval";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustDSInterval";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustTypeWithPrecision";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustTypeWithLength";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "adjustTypeWithLengthUnits";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "adjustTimeAwareType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "adjustYMInterval";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "adjustDSInterval";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCharacterSet";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

