/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class CopyServerPathsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CopyServerPathsAction.$$$reportNull$$$0(0);
        }
        Deployable server = (Deployable)e.getData(WebDeploymentDataKeys.DEPLOYABLE);
        ServerTreeNode[] nodes = (ServerTreeNode[])e.getData(WebDeploymentDataKeys.SERVER_NODES);
        if (server == null || nodes == null) {
            return;
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(CopyServerPathsAction.getPaths(server, nodes)));
    }

    private static String getPaths(Deployable server, ServerTreeNode[] nodes) {
        StringBuilder buf = new StringBuilder(nodes.length * 64);
        boolean first = true;
        for (ServerTreeNode node : nodes) {
            if (first) {
                first = false;
            } else {
                buf.append("\n");
            }
            buf.append(server.getPresentablePath(node.getPath()));
        }
        return buf.toString();
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CopyServerPathsAction.$$$reportNull$$$0(1);
        }
        ServerTreeNode[] nodes = (ServerTreeNode[])event.getData(WebDeploymentDataKeys.SERVER_NODES);
        Presentation presentation = event.getPresentation();
        boolean enabled = nodes != null && nodes.length > 0;
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation.setVisible(enabled);
        } else {
            presentation.setVisible(true);
        }
        presentation.setText(nodes != null && nodes.length == 1 ? IdeBundle.messagePointer((String)"action.copy.path", (Object[])new Object[0]) : IdeBundle.messagePointer((String)"action.copy.paths", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/CopyServerPathsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

