/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.LocalVsRemoteTaskBase;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.DiffRoot;
import com.jetbrains.plugins.webDeployment.ui.LocalMappingDiffRoot;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalVsRemoteActionBase
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(LocalVsRemoteActionBase.class);
    private final Supplier<String> myRemoteHostViewTitleSupplier;

    protected abstract LocalVsRemoteTaskBase createTask(LocalData var1);

    protected abstract LocalVsRemoteTaskBase createTask(RemoteData var1);

    public LocalVsRemoteActionBase(@NotNull Supplier<String> remoteHostViewTitleSupplier) {
        if (remoteHostViewTitleSupplier == null) {
            LocalVsRemoteActionBase.$$$reportNull$$$0(0);
        }
        this.myRemoteHostViewTitleSupplier = remoteHostViewTitleSupplier;
    }

    protected abstract Supplier<@NlsActions.ActionText String> getProjectViewTitleSupplier(@NotNull Deployable var1);

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        if (e == null) {
            LocalVsRemoteActionBase.$$$reportNull$$$0(1);
        }
        if (this.getRemoteDataIfEnabledOnRemoteHostView(e) != null) {
            enabled = true;
            e.getPresentation().setText(this.myRemoteHostViewTitleSupplier);
        } else {
            LocalData localData = this.getDataIfEnabledOnProjectView(e, true);
            if (localData != null) {
                enabled = true;
                e.getPresentation().setText(this.getProjectViewTitleSupplier(localData.server));
            } else {
                enabled = false;
            }
        }
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        } else {
            e.getPresentation().setEnabled(enabled);
        }
    }

    @Nullable
    protected LocalData getDataIfEnabledOnProjectView(AnActionEvent e, boolean isFromUpdate) {
        DataContext dataContext = e.getDataContext();
        Project project = LocalVsRemoteActionBase.getValidProject(dataContext);
        if (project == null) {
            return null;
        }
        Trinity<VirtualFile, WebServerConfig, DeploymentPathMapping> mappingTrinity = PublishActionUtil.findMappingForSingleFile(e, false, true);
        if (mappingTrinity != null) {
            return new LocalData(project, Deployable.create((WebServerConfig)mappingTrinity.getSecond(), project), Collections.singletonList(LocalMappingDiffRoot.create((VirtualFile)mappingTrinity.getFirst(), (DeploymentPathMapping)mappingTrinity.getThird())));
        }
        return null;
    }

    @Nullable
    static Project getValidProject(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project != null && !project.isDefault() && !project.isDisposed() ? project : null;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            LocalVsRemoteActionBase.$$$reportNull$$$0(2);
        }
        if (event.getData(WebDeploymentDataKeys.SERVER_TREE) != null) {
            this.actionPerformedOnRemoteHostView(event);
        } else {
            this.actionPerformedOnProjectView(event);
        }
    }

    protected void actionPerformedOnProjectView(AnActionEvent event) {
        LocalData localData = this.getDataIfEnabledOnProjectView(event, false);
        if (localData == null) {
            return;
        }
        this.createTask(localData).queue();
    }

    @Nullable
    protected RemoteData getRemoteDataIfEnabledOnRemoteHostView(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Project project = LocalVsRemoteActionBase.getValidProject(dataContext);
        if (project == null) {
            return null;
        }
        Deployable server = (Deployable)event.getData(WebDeploymentDataKeys.DEPLOYABLE);
        if (server == null) {
            return null;
        }
        FileObject[] deployedItems = (FileObject[])event.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        if (deployedItems == null || deployedItems.length != 1) {
            return null;
        }
        RemoteConnection connection = (RemoteConnection)event.getData(WebDeploymentDataKeys.REMOTE_CONNECTION);
        LOG.assertTrue(connection != null);
        FileObject deployedItem = deployedItems[0];
        DeploymentPathMapping mapping = (DeploymentPathMapping)PublishConfig.getInstance(project).getNearestMappingDeploy2Local(deployedItem, false, (Mappable)server, true).getFirst();
        if (mapping != null) {
            String localPath = mapping.mapToLocalPath(deployedItem.getName(), (Mappable)server);
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(localPath);
            if (vFile != null) {
                DiffRoot root = DiffRoot.create(vFile, deployedItem, mapping);
                return new RemoteData(project, server, Collections.singletonList(root), connection);
            }
        }
        return null;
    }

    private void actionPerformedOnRemoteHostView(AnActionEvent event) {
        RemoteData data = this.getRemoteDataIfEnabledOnRemoteHostView(event);
        if (data == null) {
            return;
        }
        this.createTask(data).queue();
    }

    protected static FileObject getRemoteItem(ExecutionContextBase context, FileObject deployedItem) throws FileSystemException {
        DeploymentPathUtils.refreshRemoteFile(deployedItem, context);
        return deployedItem;
    }

    public static FileObject getRemoteItem(ExecutionContextBase context, DeploymentPathMapping mapping, VirtualFile localItem, Deployable server) throws FileSystemException {
        return context.findRemoteFile(mapping.mapToDeployPath(localItem.getPath(), (Mappable)server), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteHostViewTitleSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/LocalVsRemoteActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class RemoteData {
        @NotNull
        public final Project project;
        @NotNull
        public final Deployable server;
        @NotNull
        public final List<DiffRoot> files;
        @NotNull
        public final RemoteConnection connection;

        public RemoteData(@NotNull Project project, @NotNull Deployable server, @NotNull List<DiffRoot> files, @NotNull RemoteConnection connection) {
            if (project == null) {
                RemoteData.$$$reportNull$$$0(0);
            }
            if (server == null) {
                RemoteData.$$$reportNull$$$0(1);
            }
            if (files == null) {
                RemoteData.$$$reportNull$$$0(2);
            }
            if (connection == null) {
                RemoteData.$$$reportNull$$$0(3);
            }
            this.project = project;
            this.server = server;
            this.files = files;
            this.connection = connection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "server";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "files";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/webDeployment/actions/LocalVsRemoteActionBase$RemoteData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class LocalData {
        @NotNull
        public final Project project;
        @NotNull
        public final Deployable server;
        @NotNull
        public final List<LocalMappingDiffRoot> myDiffRoots;

        public LocalData(@NotNull Project project, @NotNull Deployable server, @NotNull List<LocalMappingDiffRoot> myDiffRoots) {
            if (project == null) {
                LocalData.$$$reportNull$$$0(0);
            }
            if (server == null) {
                LocalData.$$$reportNull$$$0(1);
            }
            if (myDiffRoots == null) {
                LocalData.$$$reportNull$$$0(2);
            }
            this.project = project;
            this.server = server;
            this.myDiffRoots = myDiffRoots;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "server";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "myDiffRoots";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/plugins/webDeployment/actions/LocalVsRemoteActionBase$LocalData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

