/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.autoupload;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.actions.SaveAllAction;
import com.intellij.ide.actions.SaveDocumentAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.UploadPostponer;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.autoupload.AutoUploadAsyncFileListener;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoUploadSaveActionsListener
implements AnActionListener {
    private static final int CHECK_RELATED_CHANGES_TIMEOUT = 5000;
    private final Map<AnActionEvent, Editor> myActionsToHandle;
    @NotNull
    private final Project myProject;
    @NotNull
    private final AutoUploadAsyncFileListener myListener;
    private final AtomicBoolean myChecksRelatedChanges;

    public AutoUploadSaveActionsListener(@NotNull Project project, @NotNull AutoUploadAsyncFileListener listener) {
        if (project == null) {
            AutoUploadSaveActionsListener.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            AutoUploadSaveActionsListener.$$$reportNull$$$0(1);
        }
        this.myActionsToHandle = new HashMap<AnActionEvent, Editor>();
        this.myChecksRelatedChanges = new AtomicBoolean(false);
        this.myProject = project;
        this.myListener = listener;
    }

    public void beforeActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event) {
        if (action == null) {
            AutoUploadSaveActionsListener.$$$reportNull$$$0(2);
        }
        if (event == null) {
            AutoUploadSaveActionsListener.$$$reportNull$$$0(3);
        }
        if (!this.myListener.isUploadOnSaveAll() || !(action instanceof SaveAllAction) && !(action instanceof SaveDocumentAction)) {
            return;
        }
        if (!this.myProject.equals(event.getProject())) {
            return;
        }
        this.myActionsToHandle.put(event, action instanceof SaveDocumentAction ? (Editor)event.getData(CommonDataKeys.EDITOR) : null);
    }

    public void afterActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event, @NotNull AnActionResult result) {
        if (action == null) {
            AutoUploadSaveActionsListener.$$$reportNull$$$0(4);
        }
        if (event == null) {
            AutoUploadSaveActionsListener.$$$reportNull$$$0(5);
        }
        if (result == null) {
            AutoUploadSaveActionsListener.$$$reportNull$$$0(6);
        }
        if (!(action instanceof SaveAllAction) && !(action instanceof SaveDocumentAction)) {
            return;
        }
        if (!this.myListener.isUploadOnSaveAll()) {
            this.myActionsToHandle.remove(event);
            return;
        }
        if (!this.myActionsToHandle.containsKey(event)) {
            return;
        }
        Editor editor = this.myActionsToHandle.remove(event);
        VirtualFile target = null;
        if (action instanceof SaveDocumentAction) {
            if (editor == null) {
                return;
            }
            Document document = editor.getDocument();
            target = FileDocumentManager.getInstance().getFile(document);
            if (target == null) {
                return;
            }
        }
        this.waitForRelatedChangesAndUpload(target);
    }

    private void waitForRelatedChangesAndUpload(final @Nullable VirtualFile target) {
        if (this.myChecksRelatedChanges.get()) {
            return;
        }
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, WDBundle.message("auto.upload.wait.for.related.changes.to.apply.before.upload", new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (AutoUploadSaveActionsListener.this.myChecksRelatedChanges.get()) {
                    return;
                }
                Future checkFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    boolean wasNotChecking = AutoUploadSaveActionsListener.this.myChecksRelatedChanges.compareAndSet(false, true);
                    if (!wasNotChecking) {
                        return;
                    }
                    try {
                        for (UploadPostponer extension : UploadPostponer.EP_NAME.getExtensionList()) {
                            AutoUploadComponent.LOG.debug("Checking for related changes " + extension.getPresentableName());
                            pi.setText(WDBundle.message("auto.upload.checking.0", extension.getPresentableName()));
                            extension.waitForRelatedChanges(pi, this.getProject());
                            pi.checkCanceled();
                        }
                    }
                    finally {
                        AutoUploadSaveActionsListener.this.myChecksRelatedChanges.set(false);
                    }
                });
                boolean checkFailedByTimeout = false;
                try {
                    checkFuture.get(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    AutoUploadComponent.LOG.warn((Throwable)e);
                }
                catch (ExecutionException e) {
                    AutoUploadComponent.LOG.error((Throwable)e);
                }
                catch (TimeoutException e) {
                    AutoUploadComponent.LOG.debug((Throwable)e);
                    checkFailedByTimeout = true;
                    checkFuture.cancel(true);
                }
                pi.checkCanceled();
                boolean finalCheckFailedByTimeout = checkFailedByTimeout;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (this.getProject().isDisposed()) {
                        return;
                    }
                    if (finalCheckFailedByTimeout) {
                        String text = WDBundle.message("auto.upload.check.for.related.changes.took.too.much.time.and.was.cancelled", new Object[0]);
                        List<WebServerConfig> servers = PublishConfig.getInstance(this.getProject()).findValidDefaultTransferableServers();
                        for (WebServerConfig server : servers) {
                            FileTransferToolWindow.printWithTimestamp(this.myProject, server, text, ConsoleViewContentType.NORMAL_OUTPUT, PublishConfig.TraceLevel.ERRORS);
                        }
                        DeploymentNotifier.notifyWithBalloon(null, text, NotificationType.WARNING, null, this.myProject, FileTransferToolWindow.ID_PROVIDER);
                    }
                    if (target == null) {
                        AutoUploadSaveActionsListener.this.myListener.uploadAllChangesOnSaveAllAction();
                    } else {
                        ApplicationManager.getApplication().executeOnPooledThread(() -> AutoUploadSaveActionsListener.this.myListener.uploadFile(target));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/autoupload/AutoUploadSaveActionsListener$1", "run"));
            }
        };
        task.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/autoupload/AutoUploadSaveActionsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeActionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "afterActionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

