/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ultimate.PluginVerifier;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.WebServerConfigsChangedListener;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManagerBaseImpl;
import com.jetbrains.plugins.webDeployment.statistic.ServerSettingsUsageTriggerCollector;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GroupedServersConfigManagerImpl
implements GroupedServersConfigManager {
    static final Logger LOG = Logger.getInstance(GroupedServersConfigManagerImpl.class);
    private final WebServersConfigManagerBaseImpl.App myAppManager;
    @Nullable
    private final WebServersConfigManagerBaseImpl.ProjectInstance myProjectManager;

    public GroupedServersConfigManagerImpl(final @NotNull Project project) {
        if (project == null) {
            GroupedServersConfigManagerImpl.$$$reportNull$$$0(0);
        }
        PluginVerifier.verifyUltimatePlugin();
        this.myAppManager = WebServersConfigManagerBaseImpl.App.getInstance();
        if (project.isDefault()) {
            this.myProjectManager = null;
        } else {
            this.myProjectManager = WebServersConfigManagerBaseImpl.ProjectInstance.getInstance(project);
            WebServersConfigManagerBaseImpl.Listener listener = new WebServersConfigManagerBaseImpl.Listener(){

                @Override
                public void serversLoaded() {
                    GroupedServersConfigManagerImpl.this.resolvePossibleServerCollisions(project);
                }
            };
            this.myProjectManager.addListener(listener, this);
            this.myAppManager.addListener(listener, this);
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.resolvePossibleServerCollisions(project));
        }
    }

    private void resolvePossibleServerCollisions(@NotNull Project project) {
        if (project == null) {
            GroupedServersConfigManagerImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(this.myProjectManager != null);
        ArrayList<WebServerGroupingWrap> wraps = new ArrayList<WebServerGroupingWrap>(this.getGroupedServers());
        HashSet<String> globalGroupAndServerNames = new HashSet<String>();
        HashSet<String> globalServerIds = new HashSet<String>();
        HashSet<String> projectGroupAndServerNames = new HashSet<String>();
        for (WebServerGroupingWrap wrap : wraps) {
            if (wrap.isProjectLevel()) {
                projectGroupAndServerNames.add(wrap.getName());
                for (WebServerConfig server : wrap.getServers()) {
                    projectGroupAndServerNames.add(StringUtil.notNullize((String)server.getName()));
                }
                continue;
            }
            globalGroupAndServerNames.add(wrap.getName());
            for (WebServerConfig server : wrap.getServers()) {
                globalServerIds.add(server.getId());
                globalGroupAndServerNames.add(StringUtil.notNullize((String)server.getName()));
            }
        }
        HashSet<String> previousProjectServerIds = new HashSet<String>();
        HashMap<WebServerConfig, WebServerConfig> oldToNewServers = new HashMap<WebServerConfig, WebServerConfig>();
        HashMap<String, String> oldToNewGroupNames = new HashMap<String, String>();
        for (WebServerGroupingWrap wrap : wraps) {
            if (!wrap.isProjectLevel()) continue;
            String groupName = wrap.getName();
            if (!wrap.isSingleServer() && globalGroupAndServerNames.contains(groupName) && globalGroupAndServerNames.contains(groupName)) {
                String newGroupName = GroupedServersConfigManagerImpl.getNewName(globalGroupAndServerNames, projectGroupAndServerNames, wrap.getName());
                wrap.setName(newGroupName);
                projectGroupAndServerNames.add(newGroupName);
                oldToNewGroupNames.put(groupName, newGroupName);
            }
            for (WebServerConfig server : wrap.getServers()) {
                String oldServerName = StringUtil.notNullize((String)server.getName());
                if (globalGroupAndServerNames.contains(oldServerName) || globalServerIds.contains(server.getId())) {
                    WebServerConfig oldServer = server.clone();
                    if (globalGroupAndServerNames.contains(oldServerName)) {
                        String serverName = GroupedServersConfigManagerImpl.getNewName(globalGroupAndServerNames, projectGroupAndServerNames, oldServerName);
                        server.setName(serverName);
                        projectGroupAndServerNames.add(StringUtil.notNullize((String)oldServerName));
                    }
                    while (globalServerIds.contains(server.getId()) || previousProjectServerIds.contains(server.getId())) {
                        server.setId(WebServerConfig.getNextId());
                        WebDeploymentCredentialHelper.copyServerCredentials(oldServer, server);
                    }
                    oldToNewServers.put(oldServer, server);
                }
                previousProjectServerIds.add(server.getId());
            }
        }
        if (!oldToNewServers.isEmpty() || !oldToNewGroupNames.isEmpty()) {
            this.setGroupedServers(wraps);
            PublishConfig.getInstance(project).notifyServersPatched(oldToNewServers, this.getFlattenedServers(), oldToNewGroupNames);
        }
    }

    @Override
    public void setGroupedServers(@NotNull List<WebServerGroupingWrap> groups) {
        if (groups == null) {
            GroupedServersConfigManagerImpl.$$$reportNull$$$0(2);
        }
        HashMap<String, WebServerGroupingWrap> oldWraps = new HashMap<String, WebServerGroupingWrap>();
        HashMap<String, WebServerConfig> oldServers = new HashMap<String, WebServerConfig>();
        if (this.myProjectManager != null) {
            GroupedServersConfigManagerImpl.collectOldData(this.myProjectManager, oldWraps, oldServers);
        }
        GroupedServersConfigManagerImpl.collectOldData(this.myAppManager, oldWraps, oldServers);
        this.myAppManager.resetReauthCache();
        for (WebServerGroupingWrap wrap : groups) {
            if (wrap.isProjectLevel()) {
                assert (this.myProjectManager != null);
                this.myProjectManager.addGroup(wrap.copy());
                continue;
            }
            this.myAppManager.addGroup(wrap.copy());
        }
        for (WebServerGroupingWrap groupingWrap : groups) {
            WebServerGroupingWrap oldGroup = (WebServerGroupingWrap)oldWraps.get(groupingWrap.getName());
            if (oldGroup == null) {
                ServerSettingsUsageTriggerCollector.logGroup(true, groupingWrap.isProjectLevel());
                continue;
            }
            if (oldGroup.isProjectLevel() == groupingWrap.isProjectLevel()) continue;
            ServerSettingsUsageTriggerCollector.logGroup(false, groupingWrap.isProjectLevel());
        }
        GroupedServersConfigManagerImpl.updateData(this.getFlattenedServers(), oldServers);
    }

    public void dispose() {
    }

    private static void collectOldData(WebServersConfigManagerBaseImpl<?> manager, Map<String, WebServerGroupingWrap> oldWraps, Map<String, WebServerConfig> oldServers) {
        List<WebServerGroupingWrap> wraps = manager.getGroupedServers();
        for (WebServerGroupingWrap wrap : wraps) {
            oldWraps.put(wrap.getName(), wrap);
        }
        List<WebServerConfig> servers = manager.getServers();
        for (WebServerConfig server : servers) {
            oldServers.put(server.getId(), server);
        }
        manager.clearServersAndGroups();
    }

    @Override
    public void addServer(WebServerConfig newServer) {
        assert (this.myProjectManager != null || !newServer.isProjectLevel());
        if (newServer.isProjectLevel()) {
            Objects.requireNonNull(this.myProjectManager).addServer(newServer.clone());
        } else {
            this.myAppManager.addServer(newServer.clone());
        }
        ((WebServerConfigsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.WEB_SERVER_CONFIGS)).serverConfigsChanged();
    }

    @Override
    public void addServerToPredefinedGroup(@NotNull WebServerConfig server, @NlsSafe @NotNull String groupName, boolean mayChangeLevel) {
        if (server == null) {
            GroupedServersConfigManagerImpl.$$$reportNull$$$0(3);
        }
        if (groupName == null) {
            GroupedServersConfigManagerImpl.$$$reportNull$$$0(4);
        }
        assert (this.myProjectManager != null || !server.isProjectLevel());
        Pair<String, @Nullable WebServerGroupingWrap> nameAndGroup = this.findSuitableGroupName(groupName, server.isProjectLevel(), mayChangeLevel);
        if (server.isProjectLevel()) {
            Objects.requireNonNull(this.myProjectManager).addServerToSuitableGroup(server.clone(), (String)nameAndGroup.getFirst(), (WebServerGroupingWrap)nameAndGroup.getSecond(), mayChangeLevel);
        } else {
            this.myAppManager.addServerToSuitableGroup(server.clone(), (String)nameAndGroup.getFirst(), (WebServerGroupingWrap)nameAndGroup.getSecond(), mayChangeLevel);
        }
        ((WebServerConfigsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.WEB_SERVER_CONFIGS)).serverConfigsChanged();
    }

    @NotNull
    private Pair<String, WebServerGroupingWrap> findSuitableGroupName(String groupName, boolean isProjectLevel, boolean mayChangeLevel) {
        List<WebServerGroupingWrap> groupedServers = this.getGroupedServers();
        @Nullable Pair<String, WebServerGroupingWrap> groupAndName = GroupedServersConfigManagerImpl.findSuitableGroupByName(groupName, isProjectLevel, mayChangeLevel, groupedServers);
        if (groupAndName != null) {
            Pair<String, WebServerGroupingWrap> pair = groupAndName;
            if (pair == null) {
                GroupedServersConfigManagerImpl.$$$reportNull$$$0(5);
            }
            return pair;
        }
        int i = 1;
        while (true) {
            String name;
            if ((groupAndName = GroupedServersConfigManagerImpl.findSuitableGroupByName(name = groupName + " " + i, isProjectLevel, mayChangeLevel, groupedServers)) != null) {
                Pair<String, WebServerGroupingWrap> pair = groupAndName;
                if (pair == null) {
                    GroupedServersConfigManagerImpl.$$$reportNull$$$0(6);
                }
                return pair;
            }
            ++i;
        }
    }

    @Nullable
    private static Pair<String, WebServerGroupingWrap> findSuitableGroupByName(String name, boolean isProjectLevel, boolean mayChangeLevel, List<WebServerGroupingWrap> groupedServers) {
        for (WebServerGroupingWrap groupingWrap : groupedServers) {
            if (groupingWrap.isSingleServer() || !name.equals(groupingWrap.getName())) continue;
            if (groupingWrap.isProjectLevel() == isProjectLevel && groupingWrap.mayChangeLevel() == mayChangeLevel) {
                return new Pair((Object)name, (Object)groupingWrap);
            }
            return null;
        }
        return new Pair((Object)name, null);
    }

    @Override
    public boolean removeServer(@Nullable String serverId) {
        if (serverId == null) {
            return false;
        }
        WebServerConfig server = this.findServer(serverId);
        if (server == null) {
            return false;
        }
        boolean found = false;
        if (this.myProjectManager != null) {
            found = this.myProjectManager.removeServer(server);
        }
        if (!found) {
            found = this.myAppManager.removeServer(server);
        }
        if (found) {
            ((WebServerConfigsChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.WEB_SERVER_CONFIGS)).serverConfigsChanged();
        }
        return found;
    }

    @Override
    public WebServerConfig moveServer(WebServerConfig config) {
        LOG.assertTrue(this.myProjectManager != null);
        if (config.isProjectLevel()) {
            boolean remove = this.myProjectManager.removeServer(config);
            LOG.assertTrue(remove, (Object)("Can't find server '" + config.getName() + "'"));
            config.setIsProjectLevel(false);
        } else {
            boolean remove = this.myAppManager.removeServer(config);
            LOG.assertTrue(remove, (Object)("Can't find server '" + config.getName() + "'"));
            config.setIsProjectLevel(true);
        }
        this.addServer(config);
        return config;
    }

    @Override
    public boolean hasServers(boolean remoteOnly) {
        return this.myProjectManager != null && GroupedServersConfigManagerImpl.hasServers(this.myProjectManager.getServers(), remoteOnly) || GroupedServersConfigManagerImpl.hasServers(this.myAppManager.getServers(), remoteOnly);
    }

    private static boolean hasServers(List<WebServerConfig> servers, boolean remoteOnly) {
        for (WebServerConfig server : servers) {
            if (remoteOnly && !server.needsTransfer()) continue;
            return true;
        }
        return false;
    }

    private static void updateData(@NotNull List<WebServerConfig> servers, @NotNull Map<String, WebServerConfig> oldServers) {
        if (servers == null) {
            GroupedServersConfigManagerImpl.$$$reportNull$$$0(7);
        }
        if (oldServers == null) {
            GroupedServersConfigManagerImpl.$$$reportNull$$$0(8);
        }
        for (WebServerConfig server : servers) {
            oldServers.remove(server.getId());
        }
        if (oldServers.isEmpty()) {
            return;
        }
        for (WebServerConfig server : oldServers.values()) {
            WebDeploymentCredentialHelper.saveCredentials(server, false, null);
        }
    }

    @NotNull
    private static String getNewName(Set<String> globalGroupAndServerNames, Set<String> projectGroupAndServerNames, String baseName) {
        String serverNameBase = WDBundle.message("0.project.level", baseName);
        int i = 1;
        Object serverName = serverNameBase;
        while (globalGroupAndServerNames.contains(serverName) || projectGroupAndServerNames.contains(serverName)) {
            serverName = serverNameBase + " (" + i + ")";
            ++i;
        }
        Object object = serverName;
        if (object == null) {
            GroupedServersConfigManagerImpl.$$$reportNull$$$0(9);
        }
        return object;
    }

    @Override
    @NotNull
    public List<WebServerGroupingWrap> getGroupedServers() {
        if (this.myProjectManager == null) {
            List<WebServerGroupingWrap> list = Collections.unmodifiableList(this.myAppManager.getGroupedServers());
            if (list == null) {
                GroupedServersConfigManagerImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        return new UnmodifiableWrapper<WebServerGroupingWrap>(this.myProjectManager.getGroupedServers(), this.myAppManager.getGroupedServers());
    }

    @Override
    @NotNull
    public List<WebServerConfig> getFlattenedServers() {
        if (this.myProjectManager == null) {
            List<WebServerConfig> list = Collections.unmodifiableList(this.myAppManager.getServers());
            if (list == null) {
                GroupedServersConfigManagerImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        return new UnmodifiableWrapper<WebServerConfig>(this.myProjectManager.getServers(), this.myAppManager.getServers());
    }

    @NotNull
    public static List<WebServerConfig> getServersFromAllOpenProjects(boolean remoteOnly) {
        ArrayList<WebServerConfig> result = new ArrayList<WebServerConfig>();
        GroupedServersConfigManagerImpl.addServers(remoteOnly, result, WebServersConfigManagerBaseImpl.App.getInstance().getServers());
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            GroupedServersConfigManagerImpl.addServers(remoteOnly, result, WebServersConfigManagerBaseImpl.ProjectInstance.getInstance(project).getServers());
        }
        ArrayList<WebServerConfig> arrayList = result;
        if (arrayList == null) {
            GroupedServersConfigManagerImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static void addServers(boolean remoteOnly, List<WebServerConfig> result, List<WebServerConfig> servers) {
        if (remoteOnly) {
            for (WebServerConfig server : servers) {
                if (!server.needsTransfer()) continue;
                result.add(server);
            }
        } else {
            result.addAll(servers);
        }
    }

    @NotNull
    public static @NotNull List<@NotNull Pair<@NotNull WebServerConfig, @Nullable Project>> getServersWithProjectsFromAllOpenProjects(boolean remoteOnly) {
        ArrayList<@NotNull Pair<@NotNull WebServerConfig, @Nullable Project>> result = new ArrayList<Pair<WebServerConfig, Project>>();
        GroupedServersConfigManagerImpl.addServersWithProjects(remoteOnly, result, WebServersConfigManagerBaseImpl.App.getInstance().getServers(), null);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            GroupedServersConfigManagerImpl.addServersWithProjects(remoteOnly, result, WebServersConfigManagerBaseImpl.ProjectInstance.getInstance(project).getServers(), project);
        }
        ArrayList<Pair<WebServerConfig, Project>> arrayList = result;
        if (arrayList == null) {
            GroupedServersConfigManagerImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static void addServersWithProjects(boolean remoteOnly, List<@NotNull Pair<@NotNull WebServerConfig, @Nullable Project>> result, List<WebServerConfig> servers, @Nullable Project project) {
        for (WebServerConfig server : servers) {
            if (remoteOnly && !server.needsTransfer()) continue;
            result.add((Pair<WebServerConfig, Project>)new Pair((Object)server, (Object)project));
        }
    }

    @Deprecated
    @NotNull
    static Map<String, WebServerConfig> collectUnpatchedServers(@Nullable Project project) {
        HashMap<String, WebServerConfig> result = new HashMap<String, WebServerConfig>();
        WebServersConfigManagerBaseImpl.App appService = WebServersConfigManagerBaseImpl.App.getInstance();
        for (WebServerConfig server : appService.getServers()) {
            result.put(server.getId(), server);
        }
        if (project != null && !project.isDefault()) {
            WebServersConfigManagerBaseImpl.ProjectInstance projectService = WebServersConfigManagerBaseImpl.ProjectInstance.getInstance(project);
            for (WebServerConfig server : projectService.getServers()) {
                result.put(server.getId(), server);
            }
        }
        HashMap<String, WebServerConfig> hashMap = result;
        if (hashMap == null) {
            GroupedServersConfigManagerImpl.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/GroupedServersConfigManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldServers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/GroupedServersConfigManagerImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuitableGroupName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupedServers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlattenedServers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getServersFromAllOpenProjects";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getServersWithProjectsFromAllOpenProjects";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnpatchedServers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolvePossibleServerCollisions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setGroupedServers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addServerToPredefinedGroup";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UnmodifiableWrapper<T>
    extends AbstractList<T> {
        private final List<T> myFirstList;
        private final List<T> mySecondList;

        private UnmodifiableWrapper(List<T> firstList, List<T> secondList) {
            this.myFirstList = firstList;
            this.mySecondList = secondList;
        }

        @Override
        public T get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Negative index " + index);
            }
            if (index < this.myFirstList.size()) {
                return this.myFirstList.get(index);
            }
            if (index < this.myFirstList.size() + this.mySecondList.size()) {
                return this.mySecondList.get(index - this.myFirstList.size());
            }
            throw new IndexOutOfBoundsException("Too large index " + index + " for size " + this.size());
        }

        @Override
        public int size() {
            return this.myFirstList.size() + this.mySecondList.size();
        }
    }
}

