/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManagerImpl;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface WebServerGroupingWrap {
    @NotNull
    @NlsSafe
    public String getName();

    public boolean isSingleServer();

    @NotNull
    public WebServerConfig getAsSingleServer();

    @NotNull
    public List<WebServerConfig> getServers();

    public boolean addServer(@NotNull WebServerConfig var1);

    public boolean removeServer(@NotNull WebServerConfig var1);

    public boolean isProjectLevel();

    public void setName(@NotNull String var1);

    public boolean mayChangeLevel();

    @NotNull
    public WebServerGroupingWrap copy();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public String validateFileTransferFast();

    default public String getPresentableName() {
        return this.isSingleServer() ? WDBundle.message("web.server", new Object[0]) : WDBundle.message("group", new Object[0]);
    }

    @NotNull
    public static WebServerGroupingWrap wrap(final WebServerConfig config) {
        return new WebServerGroupingWrap(){

            @Override
            @NotNull
            @NlsSafe
            public String getName() {
                String string = StringUtil.notNullize((String)config.getName());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean isSingleServer() {
                return true;
            }

            @Override
            @NotNull
            public WebServerConfig getAsSingleServer() {
                WebServerConfig webServerConfig = config;
                if (webServerConfig == null) {
                    1.$$$reportNull$$$0(1);
                }
                return webServerConfig;
            }

            @Override
            @NotNull
            public List<WebServerConfig> getServers() {
                List<WebServerConfig> list = Collections.singletonList(config);
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            public boolean addServer(@NotNull WebServerConfig config2) {
                if (config2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                throw new IllegalStateException("This is wrap with a server, check isSingleServer()");
            }

            @Override
            public boolean removeServer(@NotNull WebServerConfig config2) {
                if (config2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                throw new IllegalStateException("This is wrap with a server, check isSingleServer()");
            }

            @Override
            public boolean mayChangeLevel() {
                return true;
            }

            @Override
            public boolean isProjectLevel() {
                return config.isProjectLevel();
            }

            @Override
            public void setName(@NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(5);
                }
                throw new IllegalStateException("This is wrap with a server, check isSingleServer()");
            }

            @Override
            @NotNull
            public WebServerGroupingWrap copy() {
                WebServerGroupingWrap webServerGroupingWrap = WebServerGroupingWrap.wrap(config.clone());
                if (webServerGroupingWrap == null) {
                    1.$$$reportNull$$$0(6);
                }
                return webServerGroupingWrap;
            }

            @Override
            @Nullable
            public String validateFileTransferFast() {
                return config.getFileTransferConfig().validateFast();
            }

            @NonNls
            public String toString() {
                return "WebServerGroupingWrap{server=\"" + config.getName() + "\"}";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/WebServerGroupingWrap$1";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAsSingleServer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getServers";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServerGroupingWrap$1";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "copy";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "addServer";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "removeServer";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "setName";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public static WebServerGroupingWrap create(final @NotNull String groupName, List<WebServerConfig> servers, final boolean isProjectLevel, final boolean mayChangeLevel) {
        if (groupName == null) {
            WebServerGroupingWrap.$$$reportNull$$$0(0);
        }
        for (WebServerConfig server : servers) {
            GroupedServersConfigManagerImpl.LOG.assertTrue(isProjectLevel == server.isProjectLevel());
        }
        final ArrayList<WebServerConfig> configs = new ArrayList<WebServerConfig>(servers);
        return new WebServerGroupingWrap(){
            @NotNull
            private String myName;
            {
                this.myName = groupName;
            }

            @Override
            @NotNull
            @NlsSafe
            public String getName() {
                String string = this.myName;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public void setName(@NotNull String name) {
                if (name == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.myName = name;
            }

            @Override
            @NotNull
            public WebServerGroupingWrap copy() {
                ArrayList<WebServerConfig> newConfigs = new ArrayList<WebServerConfig>(configs.size());
                for (WebServerConfig config : configs) {
                    newConfigs.add(config.clone());
                }
                WebServerGroupingWrap webServerGroupingWrap = WebServerGroupingWrap.create(this.myName, newConfigs, isProjectLevel, this.mayChangeLevel());
                if (webServerGroupingWrap == null) {
                    2.$$$reportNull$$$0(2);
                }
                return webServerGroupingWrap;
            }

            @Override
            @Nullable
            public String validateFileTransferFast() {
                for (WebServerConfig config : configs) {
                    String validateFast = config.getFileTransferConfig().validateFast();
                    if (validateFast == null) continue;
                    return validateFast;
                }
                return null;
            }

            @Override
            public boolean isSingleServer() {
                return false;
            }

            @Override
            public boolean mayChangeLevel() {
                return mayChangeLevel;
            }

            @Override
            @NotNull
            public WebServerConfig getAsSingleServer() {
                throw new IllegalStateException("This is a group, check isSingleServer()");
            }

            @Override
            @NotNull
            public List<WebServerConfig> getServers() {
                ArrayList arrayList = configs;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            @Override
            public boolean addServer(@NotNull WebServerConfig config) {
                if (config == null) {
                    2.$$$reportNull$$$0(4);
                }
                return configs.add(config);
            }

            @Override
            public boolean removeServer(@NotNull WebServerConfig config) {
                if (config == null) {
                    2.$$$reportNull$$$0(5);
                }
                return configs.remove(config);
            }

            @Override
            public boolean isProjectLevel() {
                return isProjectLevel;
            }

            @NonNls
            public String toString() {
                return "WebServerGroupingWrap{groupName='" + this.myName + "'}";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/WebServerGroupingWrap$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "config";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServerGroupingWrap$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "copy";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getServers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setName";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "addServer";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "removeServer";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/jetbrains/plugins/webDeployment/config/WebServerGroupingWrap", "create"));
    }
}

