/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections.platform;

import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SftpChannelNoSuchFileException;
import com.intellij.ssh.SshTransportException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.connections.platform.PlatformSftpFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.PosixPermissions;
import org.jetbrains.annotations.NotNull;

class PlatformSftpFileObject
extends AbstractFileObject<PlatformSftpFileSystem> {
    @NotNull
    private final Function<String, RemoteFileObject> myRemoteFileObjectFactory;
    @NotNull
    private final String myPath;
    @NotNull
    private RemoteFileObject myRemoteFileObject;

    PlatformSftpFileObject(@NotNull Function<String, RemoteFileObject> remoteFileObjectFactory, @NotNull String path, @NotNull PlatformSftpFileSystem fs) {
        if (remoteFileObjectFactory == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(0);
        }
        if (path == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(1);
        }
        if (fs == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(2);
        }
        this(remoteFileObjectFactory, path, fs, remoteFileObjectFactory.apply(fs.getPathPrefix() + path));
    }

    PlatformSftpFileObject(@NotNull Function<String, RemoteFileObject> remoteFileObjectFactory, @NotNull String path, @NotNull PlatformSftpFileSystem fs, @NotNull RemoteFileObject fileObject) {
        if (remoteFileObjectFactory == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(3);
        }
        if (path == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(4);
        }
        if (fs == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(5);
        }
        if (fileObject == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(6);
        }
        this(remoteFileObjectFactory, path, fs, fileObject, fs.getFileType(fileObject));
    }

    private PlatformSftpFileObject(@NotNull Function<String, RemoteFileObject> remoteFileObjectFactory, @NotNull String path, @NotNull PlatformSftpFileSystem fs, @NotNull RemoteFileObject fileObject, @NotNull FileType fileType) {
        if (remoteFileObjectFactory == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(7);
        }
        if (path == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(8);
        }
        if (fs == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(9);
        }
        if (fileObject == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(10);
        }
        if (fileType == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(11);
        }
        super((AbstractFileName)PlatformSftpFileObject.makeFileName(path, fs, fileType), (AbstractFileSystem)fs);
        this.myRemoteFileObjectFactory = remoteFileObjectFactory;
        this.myPath = path;
        this.myRemoteFileObject = fileObject;
    }

    @NotNull
    private static URLFileName makeFileName(@NotNull String path, @NotNull PlatformSftpFileSystem fs, @NotNull FileType fileType) {
        if (path == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(12);
        }
        if (fs == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(13);
        }
        if (fileType == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(14);
        }
        GenericFileName root = (GenericFileName)fs.getRootName();
        return new URLFileName(root.getScheme(), root.getHostName(), root.getPort(), 22, path, fileType, null);
    }

    PlatformSftpFileSystem getPlatformSftpFileSystem() {
        return (PlatformSftpFileSystem)this.getFileSystem();
    }

    void updateFileObject(@NotNull RemoteFileObject fileObject) throws FileSystemException {
        if (fileObject == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(15);
        }
        this.myRemoteFileObject = fileObject;
        this.refresh();
    }

    protected long doGetContentSize() {
        return this.myRemoteFileObject.size();
    }

    protected InputStream doGetInputStream() throws IOException {
        try {
            return this.myRemoteFileObject.inputStream();
        }
        catch (SftpChannelNoSuchFileException err) {
            throw new FileNotFoundException((Object)err);
        }
        catch (SshTransportException err) {
            throw new FileSystemException("vfs.provider/read.error", (Object)this.getName(), (Throwable)err);
        }
    }

    protected FileType doGetType() {
        return this.getPlatformSftpFileSystem().getFileType(this.myRemoteFileObject);
    }

    protected String[] doListChildren() throws IOException {
        try {
            return ArrayUtil.toStringArray((Collection)ContainerUtil.map((Collection)this.myRemoteFileObject.list(), RemoteFileObject::name));
        }
        catch (SshTransportException err) {
            throw new FileSystemException("vfs.provider/list-children.error", (Throwable)err, new Object[]{this.getName()});
        }
    }

    protected void doCreateFolder() throws IOException {
        try {
            this.myRemoteFileObject.mkdir();
        }
        catch (SshTransportException err) {
            throw new FileSystemException("vfs.provider/create-folder.error", (Object)this.getName(), (Throwable)err);
        }
    }

    protected void doDelete() throws IOException {
        try {
            this.myRemoteFileObject.rm();
        }
        catch (SshTransportException err) {
            throw new FileSystemException("vfs.provider/delete.error", (Throwable)err, new Object[]{this.getName()});
        }
    }

    protected long doGetLastModifiedTime() {
        return Duration.ofSeconds(this.myRemoteFileObject.getLastModifiedTime()).toMillis();
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws IOException {
        try {
            return this.myRemoteFileObject.outputStream(bAppend);
        }
        catch (SshTransportException err) {
            throw new FileSystemException("vfs.provider/write.error", (Throwable)err, new Object[]{this.getName()});
        }
    }

    protected boolean doIsExecutable() throws IOException {
        return this.getPosixPermissions().isExecutable();
    }

    protected int doGetPermissions() {
        return this.myRemoteFileObject.getPermissions();
    }

    @NotNull
    private PosixPermissions getPosixPermissions() throws IOException {
        boolean isOwner = this.myRemoteFileObject.getUId() == this.getPlatformSftpFileSystem().getUId();
        boolean isInGroup = this.getPlatformSftpFileSystem().getGroupsIds().contains(this.myRemoteFileObject.getGroupId());
        return new PosixPermissions(this.myRemoteFileObject.getPermissions(), isOwner, isInGroup);
    }

    protected boolean doIsHidden() {
        return this.myRemoteFileObject.name().startsWith(".");
    }

    protected boolean doIsReadable() throws IOException {
        return this.getPosixPermissions().isReadable();
    }

    protected boolean doIsSameFile(FileObject destFile) {
        return this.getName().equals(destFile.getName());
    }

    protected boolean doIsWriteable() throws IOException {
        return this.getPosixPermissions().isWritable();
    }

    protected FileObject[] doListChildrenResolved() throws FileSystemException {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (RemoteFileObject child : this.myRemoteFileObject.list()) {
            FileSystem fs = this.getFileSystem();
            FileName fileName = fs.getFileSystemManager().resolveChildName(this.getName(), UriParser.encode((String)child.name()));
            this.getPlatformSftpFileSystem().createFileAndCacheIt(child, fileName);
            FileObject fileObject = fs.resolveFile(fileName);
            result.add(fileObject);
        }
        return result.toArray(new FileObject[0]);
    }

    protected void doRename(FileObject newFile) throws IOException {
        String newPath = newFile.getName().getPath();
        try {
            this.myRemoteFileObject.moveTo(this.getPlatformSftpFileSystem().getPathPrefix() + newPath);
        }
        catch (SshTransportException err) {
            throw new FileSystemException("vfs.provider/rename.error", (Throwable)err, new Object[]{this.getName(), newFile.getName()});
        }
        this.myRemoteFileObject = this.myRemoteFileObjectFactory.apply(newPath);
    }

    protected void onChange() throws FileSystemException {
        String rootPath = this.getFileSystem().getRootName().getPath();
        PlatformSftpFileObject target = this;
        PlatformSftpFileSystem fs = this.getPlatformSftpFileSystem();
        do {
            target.myRemoteFileObject = target.myRemoteFileObjectFactory.apply(fs.getPathPrefix() + target.myPath);
            String parentPath = PathUtil.getParentPath((String)target.myPath);
            target = (PlatformSftpFileObject)fs.resolveFile(parentPath);
        } while (!target.myPath.equals(rootPath));
    }

    protected boolean doSetExecutable(boolean executable, boolean ownerOnly) throws IOException {
        PosixPermissions permissions = this.getPosixPermissions();
        permissions.makeExecutable(executable, ownerOnly);
        this.myRemoteFileObject.setPermissions(permissions.getPermissions());
        return true;
    }

    protected boolean doSetLastModifiedTime(long modtime) {
        this.myRemoteFileObject.setLastModifiedTime(Duration.ofMillis(modtime).getSeconds());
        return true;
    }

    protected boolean doSetReadable(boolean readable, boolean ownerOnly) throws IOException {
        PosixPermissions permissions = this.getPosixPermissions();
        permissions.makeReadable(readable, ownerOnly);
        this.myRemoteFileObject.setPermissions(permissions.getPermissions());
        return true;
    }

    protected boolean doSetWritable(boolean writable, boolean ownerOnly) throws IOException {
        PosixPermissions permissions = this.getPosixPermissions();
        permissions.makeWritable(writable, ownerOnly);
        this.myRemoteFileObject.setPermissions(permissions.getPermissions());
        return true;
    }

    protected boolean doSetPermissions(int mask) {
        this.myRemoteFileObject.setPermissions(mask);
        return true;
    }

    protected String doGetCurrentDir() {
        String pathPrefix = this.getPlatformSftpFileSystem().getPathPrefix();
        if (pathPrefix.isEmpty()) {
            return "/";
        }
        return pathPrefix;
    }

    protected boolean doIsSymbolicLink() {
        return this.myRemoteFileObject.isSymbolicLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getLinkDestination() throws Exception {
        try {
            FileSystem fileSystem = this.getFileSystem();
            synchronized (fileSystem) {
                String canonicalPath = DeploymentPathUtils.getPathRemainder(this.getPlatformSftpFileSystem().getPathPrefix(), this.myRemoteFileObject.canonicalPath(), true);
                return this.getFileSystem().resolveFile(canonicalPath);
            }
        }
        catch (Exception err) {
            throw new CustomFileSystemException("Could not get link destination for \"" + this.getName() + "\"", err);
        }
    }

    protected void doDetach() {
        this.myRemoteFileObject.clearCachedData();
    }

    @NotNull
    protected FileObject createImaginaryFile(AbstractFileName fileName) throws FileSystemException {
        PlatformSftpFileObject platformSftpFileObject = this.getPlatformSftpFileSystem().createImaginaryFile((FileName)fileName);
        if (platformSftpFileObject == null) {
            PlatformSftpFileObject.$$$reportNull$$$0(16);
        }
        return platformSftpFileObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFileObjectFactory";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 6: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileObject";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/connections/platform/PlatformSftpFileObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/connections/platform/PlatformSftpFileObject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createImaginaryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "makeFileName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateFileObject";
                break;
            }
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

