/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EventDispatcher;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.DefaultServerTreeContentListener;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeViewOptions;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.WebServerTreeBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.EventListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.Nullable;

public class ServerBrowserForm
implements Disposable {
    private JPanel myContentPane;
    private JTextField myPathField;
    private ServerTree myTree;
    private WebServerTreeBuilder myTreeBuider;
    @Nullable
    private Project myProject;
    private final EventDispatcher<SelectionListener> myEventDispatcher;

    private void createUIComponents() {
        this.myTree = new ServerTree(this.myProject, null, null);
        PopupHandler.installPopupMenu((JComponent)((Object)this.myTree), (String)"RemoteHostViewPopupMenu", (String)"RemoteHostDialogPopup");
    }

    public ServerBrowserForm() {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(SelectionListener.class);
    }

    public ServerBrowserForm(Deployable server, boolean foldersOnly, FileTransferConfig.Origin origin, @Nullable WebServerConfig.RemotePath initialPath, @Nullable Project project, boolean modal) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(SelectionListener.class);
        this.initialize(server, foldersOnly, origin, initialPath, project, modal);
    }

    public void initialize(Deployable server, boolean foldersOnly, FileTransferConfig.Origin origin, @Nullable WebServerConfig.RemotePath initialPath, @Nullable Project project, boolean modal) {
        ServerTreeNode selection;
        ConnectionOwner owner = modal ? ConnectionOwnerFactory.createConnectionOwner(this.myContentPane) : ConnectionOwnerFactory.createConnectionOwner(project, this.myContentPane);
        ServerTreeNode root = new ServerTreeNode(project, owner, server, null, foldersOnly, origin, ServerTreeViewOptions.DEFAULT);
        this.myTreeBuider = WebServerTreeBuilder.createInstance(root, (JTree)((Object)this.myTree));
        this.myTree.setServer(server);
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                WebServerConfig.RemotePath path = ServerBrowserForm.this.getSelectedPath();
                ServerBrowserForm.this.myPathField.setText(path != null ? path.path : null);
                ((SelectionListener)ServerBrowserForm.this.myEventDispatcher.getMulticaster()).selectionChanged();
            }
        });
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.registerActionShortcut("$Delete");
        this.registerActionShortcut("$Cut");
        this.registerActionShortcut("$Paste");
        if (initialPath != null && (selection = root.createForSelection(initialPath)) != null) {
            this.myTreeBuider.select((Object)selection);
        }
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.SERVER_TREE, (Object)new DefaultServerTreeContentListener(this.myTree, this.myTreeBuider, server));
    }

    private void registerActionShortcut(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        action.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)((Object)this.myTree), (Disposable)this);
    }

    public JPanel getContentPane() {
        return this.myContentPane;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Nullable
    private WebServerConfig.RemotePath getSelectedPath() {
        Set selection = this.myTreeBuider.getSelectedElements();
        if (selection.isEmpty()) {
            return null;
        }
        Object o = selection.iterator().next();
        return o instanceof ServerTreeNode ? ((ServerTreeNode)((Object)o)).getPath() : null;
    }

    @Nullable
    public WebServerConfig.RemotePath getSelection() {
        return new WebServerConfig.RemotePath(this.myPathField.getText());
    }

    public void dispose() {
        if (this.myTreeBuider == null || this.myTreeBuider.isDisposed()) {
            return;
        }
        ((ServerTreeNode)((Object)this.myTreeBuider.getTreeStructure().getRootElement())).releaseConnection();
        Disposer.dispose((Disposable)this.myTreeBuider);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        ServerTree serverTree = this.myTree;
        jBScrollPane.setViewportView((Component)((Object)serverTree));
        this.myPathField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static interface SelectionListener
    extends EventListener {
        public void selectionChanged();
    }
}

