/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.ValidatingTableEditor;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.WebServerCombo;
import com.jetbrains.plugins.webDeployment.ui.config.ServerOrGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadBeforeRunTaskForm
implements Disposable {
    private JPanel myContentPane;
    private JPanel myTablePanel;
    private WebServerCombo myServerCombo;
    private final ValidatingTableEditor<PathWrapper> myTableEditor;
    private final Project myProject;

    private void createUIComponents() {
        this.myServerCombo = new WebServerCombo(true, -1, true, true);
        this.myServerCombo.setPreferredSize(new Dimension(200, this.myServerCombo.getPreferredSize().height));
    }

    public UploadBeforeRunTaskForm(Project project, List<String> paths, @Nullable ServerOrGroup serverOrGroup) {
        this.$$$setupUI$$$();
        this.myServerCombo.setProject(project);
        this.myServerCombo.resetToServerOrGroup(serverOrGroup);
        this.myServerCombo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UploadBeforeRunTaskForm.this.updateUi();
            }
        });
        ArrayList<PathWrapper> items = new ArrayList<PathWrapper>(paths.size());
        for (String path : paths) {
            items.add(new PathWrapper(path));
        }
        this.myProject = project;
        this.myTableEditor = new ValidatingTableEditor<PathWrapper>(){

            protected PathWrapper cloneOf(PathWrapper item) {
                return item.clone();
            }

            protected PathWrapper createItem() {
                return new PathWrapper("");
            }

            @Nullable
            protected Pair<String, ValidatingTableEditor.Fix> validate(List<? extends PathWrapper> current, List<? super String> warnings) {
                return UploadBeforeRunTaskForm.this.validate(current, warnings);
            }
        };
        this.myTablePanel.add(this.myTableEditor.getContentPane(), "Center");
        this.myTableEditor.setModel(new ColumnInfo[]{new LocalPathColumn()}, items);
        this.myTableEditor.setTableHeader(null);
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    @Nullable
    private Pair<String, ValidatingTableEditor.Fix> validate(List<? extends PathWrapper> current, List<? super String> warnings) {
        PublishConfig config = PublishConfig.getInstance(this.myProject);
        ServerOrGroup serverOrGroup = this.getServerOrGroup();
        if (!serverOrGroup.hasServer() && !serverOrGroup.hasGroup()) {
            return Pair.create((Object)WDBundle.message("server.is.not.specified", new Object[0]), null);
        }
        if (serverOrGroup.hasGroup()) {
            Pair<WebServerGroupingWrap, WebServerConfig> groupAndServer = GroupedServersConfigManager.getInstance(this.myProject).findByName(serverOrGroup.getGroupName());
            if (groupAndServer == null || groupAndServer.first == null) {
                return Pair.create((Object)WDBundle.message("group.0.not.found", serverOrGroup.getGroupName()), null);
            }
            return null;
        }
        WebServerConfig server = GroupedServersConfigManager.getInstance(this.myProject).findServer(serverOrGroup.getServerId());
        if (server == null) {
            return Pair.create((Object)WDBundle.message("server.not.exists", serverOrGroup.getServerName()), null);
        }
        String error = server.validateFast();
        if (error != null) {
            return Pair.create((Object)WDBundle.message("server.invalid", server.getName(), error), null);
        }
        HashMap<String, PathWrapper> existing = new HashMap<String, PathWrapper>();
        String pathsMessage = null;
        for (int i = 0; i < current.size(); ++i) {
            PathWrapper existingItem;
            PathWrapper item = current.get(i);
            String message = UploadBeforeRunTaskForm.validate(item.path, config, server);
            warnings.set(i, message);
            if (pathsMessage == null) {
                pathsMessage = message;
            }
            if (!StringUtil.isNotEmpty((String)item.path) || (existingItem = existing.put(StringUtil.toLowerCase((String)item.path).replace(File.separatorChar, '/'), item)) == null) continue;
            int otherIndex = current.indexOf(existingItem);
            if (warnings.get(otherIndex) == null) {
                warnings.set(otherIndex, WDBundle.message("duplicate.local.path", new Object[0]));
            }
            if (warnings.get(i) != null) continue;
            warnings.set(i, WDBundle.message("duplicate.local.path", new Object[0]));
        }
        if (pathsMessage != null) {
            return Pair.create(pathsMessage, null);
        }
        return null;
    }

    @Nullable
    private static String validate(String path, PublishConfig config, WebServerConfig server) {
        if (StringUtil.isEmpty((String)path)) {
            return WDBundle.message("upload.path.is.empty", new Object[0]);
        }
        if (!new File(path).isAbsolute()) {
            return WDBundle.message("path.is.not.absolute", path);
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            return WDBundle.message("local.item.not.found", path);
        }
        if (!PublishActionUtil.checkMapping(config, server, path, true)) {
            return WDBundle.message("no.relevant.mapping.for.0", path);
        }
        return null;
    }

    public List<String> getPaths() {
        List items = this.myTableEditor.getItems();
        ArrayList<String> result = new ArrayList<String>(items.size());
        for (PathWrapper item : items) {
            if (!StringUtil.isNotEmpty((String)item.path)) continue;
            result.add(item.path);
        }
        return result;
    }

    @NotNull
    public ServerOrGroup getServerOrGroup() {
        ServerOrGroup serverOrGroup = this.myServerCombo.getSelected();
        if (serverOrGroup == null) {
            UploadBeforeRunTaskForm.$$$reportNull$$$0(0);
        }
        return serverOrGroup;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTableEditor.getPreferredFocusedComponent();
    }

    public void updateUi() {
        this.myTableEditor.updateMessage(-1, null);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myServerCombo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/UploadBeforeRunTaskForm", "getServerOrGroup"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/WDBundle", UploadBeforeRunTaskForm.class).getString("upload.before.run.local.roots.to.upload"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        WebServerCombo webServerCombo = this.myServerCombo;
        jPanel3.add((Component)((Object)webServerCombo), new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/WDBundle", UploadBeforeRunTaskForm.class).getString("UploadBeforeRunTaskForm.server"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel2.setLabelFor((Component)((Object)webServerCombo));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private final class LocalPathColumn
    extends ColumnInfo<PathWrapper, String>
    implements ValidatingTableEditor.RowHeightProvider {
        private LocalPathColumn() {
            super(WDBundle.message("local.path.column.name", new Object[0]));
        }

        public String valueOf(PathWrapper item) {
            return item.path;
        }

        public void setValue(PathWrapper item, String value) {
            item.path = value;
        }

        public TableCellEditor getEditor(PathWrapper item) {
            return new LocalPathCellEditor(UploadBeforeRunTaskForm.this.myProject);
        }

        public int getRowHeight() {
            return new JTextField().getPreferredSize().height + 1;
        }

        public boolean isCellEditable(PathWrapper pathWrapper) {
            return true;
        }
    }

    private static final class PathWrapper
    implements Cloneable {
        public String path;

        private PathWrapper(String s) {
            this.path = s;
        }

        public PathWrapper clone() {
            try {
                return (PathWrapper)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

