/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.AuthType;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.ConfigMigrationUtil;
import com.jetbrains.plugins.webDeployment.config.ServerDeployableWithTempCredentials;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MyServerWithCredentials
extends ServerDeployableWithTempCredentials
implements SettingsDeployable {
    private boolean myInGroup;

    MyServerWithCredentials(@NotNull WebServerConfig server, @Nullable SshUiData sshUiData) {
        if (server == null) {
            MyServerWithCredentials.$$$reportNull$$$0(0);
        }
        super(server, sshUiData);
        this.myInGroup = false;
        this.updateCredentialsFromPasswordSafe();
    }

    @Override
    public void setId(String id) {
        this.myServer.setId(id);
    }

    @Override
    public void setName(String name) {
        this.myServer.setName(name);
    }

    @Override
    public void setInGroup(boolean inGroup) {
        this.myInGroup = inGroup;
    }

    @Override
    public boolean isInGroup() {
        return this.myInGroup;
    }

    @Override
    @NotNull
    public MyServerWithCredentials clone() {
        MyServerWithCredentials myServerWithCredentials = (MyServerWithCredentials)super.clone();
        if (myServerWithCredentials == null) {
            MyServerWithCredentials.$$$reportNull$$$0(1);
        }
        return myServerWithCredentials;
    }

    @Override
    public void eraseCredentialsFromPasswordSafe() {
        WebDeploymentCredentialHelper.saveCredentials(this.myServer, false, null);
    }

    @Override
    public void updateCredentialsFromPasswordSafe() {
        Pair<Credentials, Boolean> credentialsAndMemoryOnlyStatus = WebDeploymentCredentialHelper.getCredentialsAndMemoryOnlyStatus(this.myServer, false);
        this.myCredentials = (Credentials)credentialsAndMemoryOnlyStatus.getFirst();
        this.isPassMemoryOnly = (Boolean)credentialsAndMemoryOnlyStatus.getSecond();
    }

    @Override
    public String getMountedFolder() {
        return this.myServer.getFileTransferConfig().getMountedFolder();
    }

    @Override
    @NlsSafe
    public String getRootFolder() {
        return this.myServer.getFileTransferConfig().getRootFolder();
    }

    @Override
    public AdvancedOptionsConfig getAdvancedOptions() {
        return this.myServer.getFileTransferConfig().getAdvancedOptions();
    }

    @Override
    public boolean isFtpsExplicit() {
        return this.myServer.getFileTransferConfig().isFtpsExplicit();
    }

    @Override
    public void setAccessType(@NotNull AccessType type) {
        if (type == null) {
            MyServerWithCredentials.$$$reportNull$$$0(2);
        }
        this.myServer.getFileTransferConfig().setAccessType(type);
    }

    @Override
    public void setUrl(String url) {
        this.myServer.setUrl(url);
    }

    @Override
    public void setIsProjectLevel(boolean projectLevel) {
        this.myServer.setIsProjectLevel(projectLevel);
    }

    @Override
    public void setHost(String host) {
        this.myServer.getFileTransferConfig().setHost(host);
    }

    @Override
    public void setLiteralPort(String literalPort) {
        this.myServer.getFileTransferConfig().setLiteralPort(literalPort);
    }

    @Override
    public void setAnonymous(boolean anonymous) {
        this.myServer.getFileTransferConfig().setAnonymous(anonymous);
    }

    @Override
    public void setAuthType(@NotNull AuthType authType) {
        if (authType == null) {
            MyServerWithCredentials.$$$reportNull$$$0(3);
        }
        this.myServer.getFileTransferConfig().setAuthType(authType);
    }

    @Override
    public void setPort(int port) {
        this.myServer.getFileTransferConfig().setPort(port);
    }

    @Override
    public void setRootFolder(String rootFolder) {
        this.myServer.getFileTransferConfig().setRootFolder(rootFolder);
    }

    @Override
    public void setAdvancedOptions(AdvancedOptionsConfig config) {
        this.myServer.getFileTransferConfig().setAdvancedOptions(config);
    }

    @Override
    public void setMountedFolder(String mountedFolder) {
        this.myServer.getFileTransferConfig().setMountedFolder(mountedFolder);
    }

    @Override
    public void setFtpsExplicit(boolean explicit) {
        this.myServer.getFileTransferConfig().setFtpsExplicit(explicit);
    }

    @Override
    @Nullable
    public PresentableId getSshPresentableId() {
        return this.myServer.getFileTransferConfig().getSshPresentableId();
    }

    @Override
    public void setSshUiData(@Nullable PresentableId presentableId, @Nullable SshUiData data) {
        this.mySshData = data;
        if (data != null) {
            ConfigMigrationUtil.transfer(data.getConfig(), this.myServer.getFileTransferConfig().getAdvancedOptions());
            this.myServer.getFileTransferConfig().setSshConfig(presentableId, data.getConfig());
        } else {
            this.myServer.getFileTransferConfig().setSshConfig(presentableId, null);
        }
    }

    @Override
    public void updateSshConfig(@NotNull SshConfigManager manager) {
        if (manager == null) {
            MyServerWithCredentials.$$$reportNull$$$0(4);
        }
        this.myServer.loadDataFromSshConfig(manager);
        PresentableId presentableId = this.myServer.getFileTransferConfig().getSshPresentableId();
        if (presentableId != null && presentableId.hasId()) {
            this.mySshData = manager.findCurrentDataById(presentableId.getId());
            if (this.mySshData != null) {
                ConfigMigrationUtil.transfer((MutableRemoteCredentials)this.mySshData, this.myServer.getFileTransferConfig().getAdvancedOptions());
            }
        }
    }

    @Override
    @Nullable
    public String getNonBlockingWarnings() {
        return this.myServer.getFileTransferConfig().getNonBlockingWarnings();
    }

    @Override
    public String toString() {
        return "MyServerWithCredentials{myServer.name=" + this.myServer.getName() + "myServer.id=" + this.myServer.getId() + ", myCredentials=" + (this.myCredentials == null ? "null" : "***:***") + ", isPassMemoryOnly=" + this.isPassMemoryOnly + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/MyServerWithCredentials";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/MyServerWithCredentials";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setAccessType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAuthType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateSshConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

