/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.gradle.execution;

import com.intellij.build.BuildViewManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.cpp.gradle.execution.GradleAppRunConfiguration;
import com.jetbrains.cidr.cpp.gradle.execution.GradleNativeConfiguration;
import com.jetbrains.cidr.execution.BuildConfigurationProblems;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.build.CidrBuildEvent;
import com.jetbrains.cidr.execution.build.CidrBuildId;
import com.jetbrains.cidr.execution.build.CidrBuildListener;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.execution.build.CidrBuildTaskType;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleNativeBuild {
    public static boolean build(Project project, ExecutionEnvironment environment, GradleAppRunConfiguration configuration) {
        ExecutionTarget target = environment.getExecutionTarget();
        GradleAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = GradleNativeBuild.getBuildAndRunConfigurations(configuration, environment, target);
        if (buildAndRunConfigurations == null) {
            return false;
        }
        return GradleNativeBuild.build(project, buildAndRunConfigurations);
    }

    public static boolean build(Project project, GradleAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations) {
        String compileTaskName;
        GradleNativeConfiguration buildConfiguration = buildAndRunConfigurations.buildConfiguration;
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        String linkTaskName = buildConfiguration.getLinkTaskName();
        String taskName = (String)ObjectUtils.chooseNotNull((Object)linkTaskName, (Object)(compileTaskName = buildConfiguration.getCompileTaskName()));
        if (taskName == null) {
            return false;
        }
        String executionName = linkTaskName != null ? CidrExecutionBundle.message((String)"task.execution.build.0", (Object[])new Object[]{buildConfiguration.getName()}) : CidrExecutionBundle.message((String)"task.execution.compile.0", (Object[])new Object[]{buildConfiguration.getName()});
        settings.setExecutionName(executionName);
        settings.setExternalProjectPath(buildConfiguration.getProjectPath());
        settings.setTaskNames(Collections.singletonList(taskName));
        settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
        UserDataHolderBase userData = new UserDataHolderBase();
        userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, BuildViewManager.class);
        final Ref result = Ref.create((Object)false);
        final Ref finishedAt = Ref.create((Object)0L);
        final Semaphore finished = new Semaphore(1);
        TaskCallback taskCallback = new TaskCallback(){

            public void onSuccess() {
                result.set((Object)true);
                finishedAt.set((Object)System.currentTimeMillis());
                finished.up();
            }

            public void onFailure() {
                result.set((Object)false);
                finishedAt.set((Object)System.currentTimeMillis());
                finished.up();
            }
        };
        CidrBuildTaskType taskType = linkTaskName != null ? CidrBuildTaskType.BUILD : CidrBuildTaskType.COMPILE;
        CidrBuildId buildId = CidrBuildId.create();
        ((CidrBuildListener)project.getMessageBus().syncPublisher(CidrBuildListener.TOPIC)).beforeStarted(new CidrBuildEvent((CidrBuildConfiguration)buildConfiguration, taskType, buildId));
        long startedAt = System.currentTimeMillis();
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)"Run", (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)taskCallback, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC, (boolean)false, (UserDataHolderBase)userData);
        finished.waitFor();
        boolean success = (Boolean)result.get();
        ((CidrBuildListener)project.getMessageBus().syncPublisher(CidrBuildListener.TOPIC)).afterFinished(new CidrBuildEvent((CidrBuildConfiguration)buildConfiguration, taskType, buildId), new CidrBuildResult(success, false, startedAt, (Long)finishedAt.get() - startedAt, success ? 0 : 1, 0, ""));
        return success;
    }

    @Nullable
    private static GradleAppRunConfiguration.BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull GradleAppRunConfiguration configuration, @NotNull ExecutionEnvironment environment, @NotNull ExecutionTarget target) {
        BuildConfigurationProblems problems;
        GradleAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations;
        if (configuration == null) {
            GradleNativeBuild.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            GradleNativeBuild.$$$reportNull$$$0(1);
        }
        if (target == null) {
            GradleNativeBuild.$$$reportNull$$$0(2);
        }
        if ((buildAndRunConfigurations = configuration.getBuildAndRunConfigurations(target, problems = new BuildConfigurationProblems(), false)) == null) {
            if (problems.hasProblems()) {
                ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException(problems.getHtmlProblems()));
            }
            return null;
        }
        return buildAndRunConfigurations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "environment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/cpp/gradle/execution/GradleNativeBuild";
        objectArray[2] = "getBuildAndRunConfigurations";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

