/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.nativeplatform.tooling.builder;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Provider;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.CppStaticLibrary;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.cpp.plugins.CppPlugin;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.nativeplatform.ComponentWithExecutable;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithExecutable;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingScheme;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.toolchain.Clang;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.VisualCpp;
import org.gradle.nativeplatform.toolchain.internal.NativeLanguageTools;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolSearchResult;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolSearchPath;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CppProject;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.SourceFile;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CompilationDetailsImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppBinaryImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppComponentImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppExecutableImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppProjectImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppSharedLibraryImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppStaticLibraryImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.CppTestSuiteImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.LinkageDetailsImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.SourceFileImpl;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

@Deprecated
public class CppModelBuilder
implements ModelBuilderService {
    private static final boolean IS_51_OR_BETTER = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"5.1")) >= 0;
    private static final boolean IS_410_OR_BETTER = IS_51_OR_BETTER || GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"4.10")) >= 0;
    private static final boolean IS_48_OR_BETTER = IS_410_OR_BETTER || GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"4.8")) >= 0;
    private static final boolean IS_47_OR_BETTER = IS_48_OR_BETTER || GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"4.7")) >= 0;
    private static final boolean IS_41_OR_BETTER = IS_47_OR_BETTER || GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"4.1")) >= 0;

    public boolean canBuild(String modelName) {
        return CppProject.class.getName().equals(modelName);
    }

    @Nullable
    public Object buildAll(String modelName, Project project) {
        if (!IS_41_OR_BETTER || IS_410_OR_BETTER) {
            return null;
        }
        PluginContainer pluginContainer = project.getPlugins();
        if (!pluginContainer.hasPlugin(CppBasePlugin.class)) {
            if (pluginContainer.hasPlugin(CppPlugin.class)) {
                project.getLogger().error("[sync warning] The IDE doesn't support 'cpp' gradle plugin. Consider to use new gradle C++ plugins, see details at https://blog.gradle.org/introducing-the-new-cpp-plugins");
            }
            return null;
        }
        CppProjectImpl cppProject = new CppProjectImpl();
        for (SoftwareComponent component : project.getComponents()) {
            CppComponentImpl ideCppComponent;
            if (!(component instanceof CppComponent)) continue;
            CppComponent cppComponent = (CppComponent)component;
            String cppComponentName = cppComponent.getName();
            String cppComponentBaseName = (String)cppComponent.getBaseName().get();
            LinkedHashSet<File> headerDirs = new LinkedHashSet<File>(cppComponent.getPrivateHeaderDirs().getFiles());
            if (cppComponent instanceof ProductionCppComponent) {
                ideCppComponent = new CppComponentImpl(cppComponentName, cppComponentBaseName);
                cppProject.setMainComponent(ideCppComponent);
            } else {
                if (!(cppComponent instanceof CppTestSuite)) continue;
                CppTestSuiteImpl cppTestSuite = new CppTestSuiteImpl(cppComponentName, cppComponentBaseName);
                ideCppComponent = cppTestSuite;
                cppProject.setTestComponent(cppTestSuite);
            }
            for (CppBinary cppBinary : cppComponent.getBinaries().get()) {
                Provider fileProvider;
                CppBinaryImpl binary;
                String binaryName = cppBinary.getName();
                String baseName = (String)cppBinary.getBaseName().getOrElse((Object)"");
                String variantName = StringUtils.uncapitalize((String)StringUtils.removeStart((String)binaryName, (String)"main"));
                boolean isExecutable = cppBinary instanceof ComponentWithExecutable;
                if (cppBinary instanceof CppSharedLibrary) {
                    binary = new CppSharedLibraryImpl(binaryName, baseName, variantName);
                } else if (cppBinary instanceof CppStaticLibrary) {
                    binary = new CppStaticLibraryImpl(binaryName, baseName, variantName);
                } else {
                    if (!isExecutable) continue;
                    binary = new CppExecutableImpl(binaryName, baseName, variantName);
                }
                ideCppComponent.addBinary(binary);
                Provider cppCompileProvider = cppBinary.getCompileTask();
                if (cppCompileProvider.isPresent()) {
                    CppCompile cppCompile = (CppCompile)cppCompileProvider.get();
                    CompilationDetailsImpl compilationDetails = new CompilationDetailsImpl();
                    binary.setCompilationDetails(compilationDetails);
                    String compileTaskName = cppCompile.getPath();
                    DefaultExternalTask compileTask = new DefaultExternalTask();
                    compileTask.setName(compileTaskName);
                    compileTask.setQName(compileTaskName);
                    compilationDetails.setCompileTask((ExternalTask)compileTask);
                    LinkedHashSet compileIncludePath = new LinkedHashSet(cppBinary.getCompileIncludePath().getFiles());
                    LinkedHashSet systemIncludes = new LinkedHashSet();
                    if (IS_48_OR_BETTER) {
                        compileIncludePath.addAll(cppCompile.getIncludes().getFiles());
                        systemIncludes.addAll(cppCompile.getSystemIncludes().getFiles());
                    } else {
                        systemIncludes.addAll(cppCompile.getIncludes().getFiles());
                    }
                    compilationDetails.setSystemHeaderSearchPaths(new ArrayList<File>(systemIncludes));
                    compilationDetails.setUserHeaderSearchPaths(new ArrayList<File>(compileIncludePath));
                    compilationDetails.setHeaderDirs(headerDirs);
                    Set<SourceFile> sources = CppModelBuilder.getSources(project, cppBinary, cppCompile);
                    compilationDetails.setSources(sources);
                    File compilerWorkingDir = ((Directory)cppCompile.getObjectFileDir().get()).getAsFile();
                    compilationDetails.setCompileWorkingDir(compilerWorkingDir);
                    File cppCompilerExecutable = CppModelBuilder.findCppCompilerExecutable(project, cppBinary);
                    compilationDetails.setCompilerExecutable(cppCompilerExecutable);
                    ArrayList<String> compilerArgs = new ArrayList<String>((Collection)cppCompile.getCompilerArgs().getOrElse(Collections.emptyList()));
                    compilationDetails.setAdditionalArgs(compilerArgs);
                }
                LinkageDetailsImpl linkageDetails = new LinkageDetailsImpl();
                binary.setLinkageDetails(linkageDetails);
                DefaultExternalTask linkTask = new DefaultExternalTask();
                linkageDetails.setLinkTask((ExternalTask)linkTask);
                linkTask.setName("");
                linkTask.setQName("");
                if (!isExecutable || !(fileProvider = ((ComponentWithExecutable)cppBinary).getLinkTask()).isPresent()) continue;
                LinkExecutable linkExecutable = (LinkExecutable)fileProvider.get();
                String linkTaskName = linkExecutable.getPath();
                linkTask.setName(linkTaskName);
                linkTask.setQName(linkTaskName);
                File executableFile = CppModelBuilder.getExecutableFile(linkExecutable);
                linkageDetails.setOutputLocation(executableFile);
            }
        }
        return cppProject;
    }

    private static Set<SourceFile> getSources(Project project, CppBinary cppBinary, CppCompile cppCompile) {
        LinkedHashSet<SourceFile> sources = new LinkedHashSet<SourceFile>();
        for (File file : cppBinary.getCppSource().getFiles()) {
            sources.add(new SourceFileImpl(file, null));
        }
        if (cppCompile.getObjectFileDir().isPresent()) {
            File objectFileDir = ((Directory)cppCompile.getObjectFileDir().get()).getAsFile();
            Iterator it = ((DefaultProject)project).getServices().getAll(CompilerOutputFileNamingSchemeFactory.class).iterator();
            if (it.hasNext()) {
                CompilerOutputFileNamingSchemeFactory outputFileNamingSchemeFactory = (CompilerOutputFileNamingSchemeFactory)it.next();
                boolean isTargetWindows = IS_51_OR_BETTER ? cppBinary.getTargetPlatform().getTargetMachine().getOperatingSystemFamily().isWindows() : CppModelBuilder.isWindowsOld(cppBinary.getTargetPlatform());
                String objectFileExtension = isTargetWindows ? ".obj" : ".o";
                CompilerOutputFileNamingScheme outputFileNamingScheme = outputFileNamingSchemeFactory.create();
                outputFileNamingScheme.withOutputBaseFolder(objectFileDir).withObjectFileNameSuffix(objectFileExtension);
                for (SourceFile sourceFile : sources) {
                    File objectFile = outputFileNamingScheme.map(sourceFile.getSourceFile());
                    ((SourceFileImpl)sourceFile).setObjectFile(objectFile);
                }
            }
        }
        return sources;
    }

    private static boolean isWindowsOld(CppPlatform platform) {
        Object operatingSystem = CppModelBuilder.callByReflection(platform, "getOperatingSystem");
        if (operatingSystem == null) {
            return false;
        }
        Object isWindowsNullable = CppModelBuilder.callByReflection(operatingSystem, "isWindows");
        return Boolean.TRUE.equals(isWindowsNullable);
    }

    @Nullable
    private static File getExecutableFile(LinkExecutable linkExecutable) {
        RegularFileProperty binaryFile = null;
        if (IS_47_OR_BETTER) {
            binaryFile = linkExecutable.getLinkedFile();
        } else {
            try {
                Object linkedFile = linkExecutable.getClass().getMethod("getBinaryFile", new Class[0]).invoke((Object)linkExecutable, new Object[0]);
                if (linkedFile instanceof RegularFileProperty) {
                    binaryFile = (RegularFileProperty)linkedFile;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        File executableFile = binaryFile != null ? (File)binaryFile.getAsFile().getOrNull() : null;
        return executableFile;
    }

    @Nullable
    private static File findCppCompilerExecutable(Project project, CppBinary cppBinary) {
        ToolSearchPath toolSearchPath;
        CommandLineToolSearchResult searchResult;
        Throwable throwable = null;
        try {
            if (cppBinary instanceof ConfigurableComponentWithExecutable) {
                CommandLineToolSearchResult toolSearchResult;
                PlatformToolProvider toolProvider = ((ConfigurableComponentWithExecutable)cppBinary).getPlatformToolProvider();
                if (IS_410_OR_BETTER) {
                    toolSearchResult = toolProvider.locateTool(ToolType.CPP_COMPILER);
                } else {
                    Method isToolAvailableMethod = toolProvider.getClass().getDeclaredMethod("isToolAvailable", ToolType.class);
                    isToolAvailableMethod.setAccessible(true);
                    toolSearchResult = (ToolSearchResult)isToolAvailableMethod.invoke((Object)toolProvider, ToolType.CPP_COMPILER);
                }
                if (toolSearchResult.isAvailable()) {
                    if (toolSearchResult instanceof CommandLineToolSearchResult) {
                        return toolSearchResult.getTool();
                    }
                    if (toolProvider.getClass().getSimpleName().equals("VisualCppPlatformToolProvider")) {
                        Field visualCppField = toolProvider.getClass().getDeclaredField("visualCpp");
                        visualCppField.setAccessible(true);
                        Object visualCpp = visualCppField.get(toolProvider);
                        if (visualCpp instanceof NativeLanguageTools) {
                            return ((NativeLanguageTools)visualCpp).getCompilerExecutable();
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        NativeToolChain toolChain = cppBinary.getToolChain();
        String exeName = toolChain instanceof Gcc ? "g++" : (toolChain instanceof Clang ? "clang++" : (toolChain instanceof VisualCpp ? "cl" : null));
        if (exeName != null && (searchResult = (toolSearchPath = new ToolSearchPath(OperatingSystem.current())).locate(ToolType.CPP_COMPILER, exeName)).isAvailable()) {
            return searchResult.getTool();
        }
        if (!IS_47_OR_BETTER) {
            project.getLogger().error("[sync error] Unable to resolve compiler executable. The project uses '" + GradleVersion.current() + "' try to update the gradle version");
        } else {
            project.getLogger().error("[sync error] Unable to resolve compiler executable", throwable);
        }
        return null;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        if (project == null) {
            CppModelBuilder.$$$reportNull$$$0(0);
        }
        if (e == null) {
            CppModelBuilder.$$$reportNull$$$0(1);
        }
        ErrorMessageBuilder errorMessageBuilder = ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"C++ project import errors").withDescription("Unable to import C++ project");
        if (errorMessageBuilder == null) {
            CppModelBuilder.$$$reportNull$$$0(2);
        }
        return errorMessageBuilder;
    }

    @Nullable
    private static Object callByReflection(@NotNull Object receiver, @NotNull String methodName) {
        if (receiver == null) {
            CppModelBuilder.$$$reportNull$$$0(3);
        }
        if (methodName == null) {
            CppModelBuilder.$$$reportNull$$$0(4);
        }
        Object result = null;
        try {
            Method getMethod = receiver.getClass().getMethod(methodName, new Class[0]);
            result = getMethod.invoke(receiver, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Logging.getLogger(CppModelBuilder.class).warn("Can not find `" + methodName + "` for receiver [" + receiver + "], gradle version " + GradleVersion.current(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Logging.getLogger(CppModelBuilder.class).warn("Can not call `" + methodName + "` for receiver [" + receiver + "], gradle version " + GradleVersion.current(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Logging.getLogger(CppModelBuilder.class).warn("Can not call `" + methodName + "` for receiver [" + receiver + "], gradle version " + GradleVersion.current(), (Throwable)e);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/nativeplatform/tooling/builder/CppModelBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/nativeplatform/tooling/builder/CppModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessageBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageBuilder";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "callByReflection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

