/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.PreResolvedResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.tasks.FinalizeAction;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;

public class DefaultResolvableArtifact
implements ResolvableArtifact {
    private final ModuleVersionIdentifier owner;
    private final IvyArtifactName artifact;
    private final ComponentArtifactIdentifier artifactId;
    private final TaskDependencyContainer buildDependencies;
    private final CalculatedValue<File> fileSource;
    private final FinalizeAction resolvedArtifactDependency;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final PreResolvedResolvableArtifact publicView;

    public DefaultResolvableArtifact(@Nullable ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, TaskDependencyContainer builtBy, final CalculatedValue<File> fileSource, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.buildDependencies = builtBy;
        this.fileSource = fileSource;
        this.resolvedArtifactDependency = new FinalizeAction(){

            @Override
            public TaskDependencyContainer getDependencies() {
                return DefaultResolvableArtifact.this.buildDependencies;
            }

            @Override
            public void execute(Task task) {
                if (DefaultResolvableArtifact.this.isResolveSynchronously()) {
                    fileSource.getResourceToLock().applyToMutableState(o -> fileSource.finalizeIfNotAlready());
                }
            }
        };
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.publicView = new PreResolvedResolvableArtifact(owner, artifact, artifactId, fileSource, this.buildDependencies, calculatedValueContainerFactory);
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add(this.resolvedArtifactDependency);
    }

    public IvyArtifactName getArtifactName() {
        return this.artifact;
    }

    @Override
    public ComponentArtifactIdentifier getId() {
        return this.artifactId;
    }

    public String toString() {
        return this.artifactId.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultResolvableArtifact other = (DefaultResolvableArtifact)obj;
        return other.artifactId.equals(this.artifactId);
    }

    public int hashCode() {
        return this.artifactId.hashCode();
    }

    @Override
    public ResolvedArtifact toPublicView() {
        return this.publicView;
    }

    @Override
    public ResolvableArtifact transformedTo(File file) {
        DefaultIvyArtifactName artifactName = DefaultIvyArtifactName.forFile(file, this.artifact.getClassifier());
        ComponentFileArtifactIdentifier newId = new ComponentFileArtifactIdentifier(this.artifactId.getComponentIdentifier(), artifactName);
        return new PreResolvedResolvableArtifact(this.owner, artifactName, newId, this.calculatedValueContainerFactory.create(Describables.of(newId), file), TaskDependencyContainer.EMPTY, this.calculatedValueContainerFactory);
    }

    @Override
    public boolean isResolveSynchronously() {
        if (this.artifactId.getComponentIdentifier() instanceof ProjectComponentIdentifier) {
            return true;
        }
        return this.fileSource.isFinalized();
    }

    @Override
    public CalculatedValue<File> getFileSource() {
        return this.fileSource;
    }

    @Override
    public File getFile() {
        this.fileSource.finalizeIfNotAlready();
        return this.fileSource.get();
    }
}

