/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.BaseModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.collect.MapMaker;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class ResolvedArtifactCaches
implements Stoppable {
    private static final Logger LOG = Logging.getLogger(ResolvedArtifactCaches.class);
    private final Map<String, Map<ComponentArtifactIdentifier, ResolvableArtifact>> cachePerRepo = new MapMaker().makeMap();

    public ModuleComponentRepository provideResolvedArtifactCache(ModuleComponentRepository input) {
        Map<ComponentArtifactIdentifier, ResolvableArtifact> caches = this.getResolvedArtifactCache(input);
        return new ResolvedArtifactCacheProvidingModuleComponentRepository(caches, input);
    }

    private Map<ComponentArtifactIdentifier, ResolvableArtifact> getResolvedArtifactCache(ModuleComponentRepository input) {
        ConcurrentMap resolvedArtifactCache = this.cachePerRepo.get(input.getId());
        if (resolvedArtifactCache == null) {
            LOG.debug("Creating new in-memory cache for repo '{}' [{}].", input.getName(), input.getId());
            resolvedArtifactCache = Maps.newConcurrentMap();
            this.cachePerRepo.put(input.getId(), resolvedArtifactCache);
        } else {
            LOG.debug("Reusing in-memory cache for repo '{}' [{}].", input.getName(), input.getId());
        }
        return resolvedArtifactCache;
    }

    @Override
    public void stop() {
        this.cachePerRepo.clear();
    }

    private static class ResolvedArtifactCacheProvidingModuleComponentRepository
    extends BaseModuleComponentRepository {
        private final Map<ComponentArtifactIdentifier, ResolvableArtifact> resolvedArtifactCache;

        public ResolvedArtifactCacheProvidingModuleComponentRepository(Map<ComponentArtifactIdentifier, ResolvableArtifact> resolvedArtifactsCache, ModuleComponentRepository delegate) {
            super(delegate);
            this.resolvedArtifactCache = resolvedArtifactsCache;
        }

        @Override
        public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
            return this.resolvedArtifactCache;
        }
    }
}

