/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;

public class DesugaredAttributeContainerSerializer
extends AbstractSerializer<AttributeContainer>
implements AttributeContainerSerializer {
    private final ImmutableAttributesFactory attributesFactory;
    private final NamedObjectInstantiator instantiator;
    private static final byte STRING_ATTRIBUTE = 1;
    private static final byte BOOLEAN_ATTRIBUTE = 2;
    private static final byte INTEGER_ATTRIBUTE = 3;

    public DesugaredAttributeContainerSerializer(ImmutableAttributesFactory attributesFactory, NamedObjectInstantiator instantiator) {
        this.attributesFactory = attributesFactory;
        this.instantiator = instantiator;
    }

    @Override
    public ImmutableAttributes read(Decoder decoder) throws IOException {
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        int count = decoder.readSmallInt();
        for (int i = 0; i < count; ++i) {
            String name = decoder.readString();
            byte type = decoder.readByte();
            if (type == 2) {
                attributes = this.attributesFactory.concat(attributes, Attribute.of(name, Boolean.class), decoder.readBoolean());
                continue;
            }
            if (type == 3) {
                attributes = this.attributesFactory.concat(attributes, Attribute.of(name, Integer.class), decoder.readInt());
                continue;
            }
            String value = decoder.readString();
            attributes = this.attributesFactory.concat(attributes, Attribute.of(name, String.class), new CoercingStringValueSnapshot(value, this.instantiator));
        }
        return attributes;
    }

    @Override
    public void write(Encoder encoder, AttributeContainer container) throws IOException {
        encoder.writeSmallInt(container.keySet().size());
        for (Attribute<?> attribute : container.keySet()) {
            encoder.writeString(attribute.getName());
            if (attribute.getType().equals(Boolean.class)) {
                encoder.writeByte((byte)2);
                encoder.writeBoolean((Boolean)container.getAttribute(attribute));
                continue;
            }
            if (attribute.getType().equals(Integer.class)) {
                encoder.writeByte((byte)3);
                encoder.writeInt((Integer)container.getAttribute(attribute));
                continue;
            }
            assert (attribute.getType().equals(String.class)) : "Unexpected attribute type " + attribute.getType() + " : should be " + String.class.getSimpleName();
            encoder.writeByte((byte)1);
            encoder.writeString((String)container.getAttribute(attribute));
        }
    }
}

