/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.internal.Try;

public interface CacheableInvocation<T> {
    public Optional<Try<T>> getCachedResult();

    public Try<T> invoke();

    default public <U> CacheableInvocation<U> map(final Function<? super T, U> mapper) {
        return new CacheableInvocation<U>(){

            @Override
            public Optional<Try<U>> getCachedResult() {
                return CacheableInvocation.this.getCachedResult().map((? super T result) -> result.map(mapper));
            }

            @Override
            public Try<U> invoke() {
                return CacheableInvocation.this.invoke().map(mapper);
            }
        };
    }

    default public <U> CacheableInvocation<U> flatMap(Function<? super T, CacheableInvocation<U>> mapper) {
        return this.getCachedResult().map((? super T cachedResult) -> cachedResult.tryMap(mapper).getOrMapFailure(failure -> CacheableInvocation.cached(Try.failure(failure)))).orElseGet(() -> CacheableInvocation.nonCached(() -> this.invoke().flatMap((? super T intermediateResult) -> ((CacheableInvocation)mapper.apply(intermediateResult)).invoke())));
    }

    public static <T> CacheableInvocation<T> cached(final Try<T> result) {
        return new CacheableInvocation<T>(){

            @Override
            public Optional<Try<T>> getCachedResult() {
                return Optional.of(result);
            }

            @Override
            public Try<T> invoke() {
                return result;
            }
        };
    }

    public static <T> CacheableInvocation<T> nonCached(final Supplier<Try<T>> result) {
        return new CacheableInvocation<T>(){

            @Override
            public Optional<Try<T>> getCachedResult() {
                return Optional.empty();
            }

            @Override
            public Try<T> invoke() {
                return (Try)result.get();
            }
        };
    }
}

