/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.Iterator;
import java.util.List;
import org.gradle.api.internal.collections.AbstractIterationOrderRetainingElementSource;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;

public class IterationOrderRetainingSetElementSource<T>
extends AbstractIterationOrderRetainingElementSource<T> {
    private final Spec<AbstractIterationOrderRetainingElementSource.ValuePointer<T>> noDuplicates = new Spec<AbstractIterationOrderRetainingElementSource.ValuePointer<T>>(){

        @Override
        public boolean isSatisfiedBy(AbstractIterationOrderRetainingElementSource.ValuePointer<T> pointer) {
            return !pointer.getElement().isDuplicate(pointer.getIndex());
        }
    };

    @Override
    public Iterator<T> iterator() {
        this.realizePending();
        return new AbstractIterationOrderRetainingElementSource.RealizedElementCollectionIterator(this, this.getInserted(), this.noDuplicates);
    }

    @Override
    public Iterator<T> iteratorNoFlush() {
        return new AbstractIterationOrderRetainingElementSource.RealizedElementCollectionIterator(this, this.getInserted(), this.noDuplicates);
    }

    @Override
    public boolean add(T element) {
        ++this.modCount;
        if (!Iterators.contains(this.iteratorNoFlush(), element)) {
            this.getInserted().add(new AbstractIterationOrderRetainingElementSource.Element<T>(element));
            return true;
        }
        return false;
    }

    @Override
    public boolean addRealized(T value) {
        this.markDuplicates(value);
        return true;
    }

    @Override
    protected void clearCachedElement(AbstractIterationOrderRetainingElementSource.Element<T> element) {
        boolean wasRealized = element.isRealized();
        super.clearCachedElement(element);
        if (wasRealized) {
            for (T value : element.getValues()) {
                this.markDuplicates(value);
            }
        }
    }

    private void markDuplicates(T value) {
        boolean seen = false;
        for (AbstractIterationOrderRetainingElementSource.Element element : this.getInserted()) {
            if (!element.isRealized()) continue;
            List collected = element.getValues();
            for (int index = 0; index < collected.size(); ++index) {
                if (!Objects.equal(collected.get(index), value)) continue;
                if (seen) {
                    element.setDuplicate(index);
                    continue;
                }
                seen = true;
            }
        }
    }

    @Override
    public boolean addPending(ProviderInternal<? extends T> provider) {
        ++this.modCount;
        AbstractIterationOrderRetainingElementSource.Element<? extends T> element = this.cachingElement(provider);
        if (!this.getInserted().contains(element)) {
            this.getInserted().add(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean addPendingCollection(CollectionProviderInternal<T, ? extends Iterable<T>> provider) {
        ++this.modCount;
        AbstractIterationOrderRetainingElementSource.Element<T> element = this.cachingElement(provider);
        if (!this.getInserted().contains(element)) {
            this.getInserted().add(element);
            return true;
        }
        return false;
    }
}

