/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.util.internal.VersionNumber;

public class GroovyJarFile {
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("(groovy(?:-all)?)-(\\d.*?)(-indy)?.jar");
    private final File file;
    private final Matcher matcher;

    private GroovyJarFile(File file, Matcher matcher) {
        this.file = file;
        this.matcher = matcher;
    }

    public File getFile() {
        return this.file;
    }

    public String getBaseName() {
        return this.matcher.group(1);
    }

    public VersionNumber getVersion() {
        return VersionNumber.parse(this.matcher.group(2));
    }

    public boolean isGroovyAll() {
        return this.getBaseName().equals("groovy-all");
    }

    public boolean isIndy() {
        return this.matcher.group(3) != null;
    }

    public String getDependencyNotation() {
        String result = this.getGroupId() + ":" + this.getBaseName() + ":" + this.getVersion();
        if (this.isIndy()) {
            result = result + ":indy";
        }
        return result;
    }

    private String getGroupId() {
        return this.getVersion().getMajor() < 4 ? "org.codehaus.groovy" : "org.apache.groovy";
    }

    @Nullable
    public static GroovyJarFile parse(File file) {
        Matcher matcher = FILE_NAME_PATTERN.matcher(file.getName());
        return matcher.matches() ? new GroovyJarFile(file, matcher) : null;
    }
}

