/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;

public class ClassDependentsAccumulator {
    private final Map<String, String> dependenciesToAll = new HashMap<String, String>();
    private final Map<String, Set<String>> privateDependents = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> accessibleDependents = new HashMap<String, Set<String>>();
    private final ImmutableMap.Builder<String, IntSet> classesToConstants = ImmutableMap.builder();
    private final Map<String, HashCode> seenClasses = new HashMap<String, HashCode>();
    private String fullRebuildCause;

    public void addClass(ClassAnalysis classAnalysis, HashCode hashCode) {
        this.addClass(classAnalysis.getClassName(), hashCode, classAnalysis.getDependencyToAllReason(), classAnalysis.getPrivateClassDependencies(), classAnalysis.getAccessibleClassDependencies(), classAnalysis.getConstants());
    }

    public void addClass(String className, HashCode hash, String dependencyToAllReason, Iterable<String> privateClassDependencies, Iterable<String> accessibleClassDependencies, IntSet constants) {
        if (this.seenClasses.containsKey(className)) {
            return;
        }
        this.seenClasses.put(className, hash);
        if (!constants.isEmpty()) {
            this.classesToConstants.put((Object)className, (Object)constants);
        }
        if (dependencyToAllReason != null) {
            this.dependenciesToAll.put(className, dependencyToAllReason);
            this.privateDependents.remove(className);
            this.accessibleDependents.remove(className);
        }
        for (String dependency : privateClassDependencies) {
            if (dependency.equals(className) || this.dependenciesToAll.containsKey(dependency)) continue;
            this.addDependency(this.privateDependents, dependency, className);
        }
        for (String dependency : accessibleClassDependencies) {
            if (dependency.equals(className) || this.dependenciesToAll.containsKey(dependency)) continue;
            this.addDependency(this.accessibleDependents, dependency, className);
        }
    }

    private Set<String> rememberClass(Map<String, Set<String>> dependents, String className) {
        Set<String> d = dependents.get(className);
        if (d == null) {
            d = new HashSet<String>();
            dependents.put(className, d);
        }
        return d;
    }

    @VisibleForTesting
    Map<String, DependentsSet> getDependentsMap() {
        if (this.dependenciesToAll.isEmpty() && this.privateDependents.isEmpty() && this.accessibleDependents.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : this.dependenciesToAll.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)DependentsSet.dependencyToAll(entry.getValue()));
        }
        HashSet<String> collected = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : this.accessibleDependents.entrySet()) {
            if (!collected.add(entry.getKey())) continue;
            builder.put((Object)entry.getKey(), (Object)DependentsSet.dependentClasses(this.privateDependents.getOrDefault(entry.getKey(), Collections.emptySet()), entry.getValue()));
        }
        for (Map.Entry<String, Set<String>> entry : this.privateDependents.entrySet()) {
            if (!collected.add(entry.getKey())) continue;
            builder.put((Object)entry.getKey(), (Object)DependentsSet.dependentClasses(entry.getValue(), this.accessibleDependents.getOrDefault(entry.getKey(), Collections.emptySet())));
        }
        return builder.build();
    }

    @VisibleForTesting
    Map<String, IntSet> getClassesToConstants() {
        return this.classesToConstants.build();
    }

    private void addDependency(Map<String, Set<String>> dependentsMap, String dependency, String dependent) {
        Set<String> dependents = this.rememberClass(dependentsMap, dependency);
        dependents.add(dependent);
    }

    public void fullRebuildNeeded(String fullRebuildCause) {
        this.fullRebuildCause = fullRebuildCause;
    }

    public ClassSetAnalysisData getAnalysis() {
        if (this.fullRebuildCause == null) {
            return new ClassSetAnalysisData((Map<String, HashCode>)ImmutableMap.copyOf(this.seenClasses), this.getDependentsMap(), this.getClassesToConstants(), null);
        }
        return new ClassSetAnalysisData((Map<String, HashCode>)ImmutableMap.of(), (Map<String, DependentsSet>)ImmutableMap.of(), (Map<String, IntSet>)ImmutableMap.of(), this.fullRebuildCause);
    }
}

