/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.tooling;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.tasks.compile.CompileJavaBuildOperationType;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationType;
import org.gradle.internal.build.event.OperationResultPostProcessor;
import org.gradle.internal.build.event.types.AbstractTaskResult;
import org.gradle.internal.build.event.types.DefaultAnnotationProcessorResult;
import org.gradle.internal.build.event.types.DefaultJavaCompileTaskSuccessResult;
import org.gradle.internal.build.event.types.DefaultTaskSuccessResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.protocol.events.InternalJavaCompileTaskOperationResult;

public class JavaCompileTaskSuccessResultPostProcessor
implements OperationResultPostProcessor,
BuildOperationListener {
    private static final Object TASK_MARKER = new Object();
    private final Map<Object, CompileJavaBuildOperationType.Result> results = new ConcurrentHashMap<Object, CompileJavaBuildOperationType.Result>();
    private final Map<Object, Object> parentsOfOperationsWithJavaCompileTaskAncestor = new ConcurrentHashMap<Object, Object>();

    @Override
    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        if (buildOperation.getDetails() instanceof ExecuteTaskBuildOperationType.Details) {
            this.parentsOfOperationsWithJavaCompileTaskAncestor.put(buildOperation.getId(), TASK_MARKER);
        } else if (buildOperation.getParentId() != null && this.parentsOfOperationsWithJavaCompileTaskAncestor.containsKey(buildOperation.getParentId())) {
            this.parentsOfOperationsWithJavaCompileTaskAncestor.put(buildOperation.getId(), buildOperation.getParentId());
        }
    }

    @Override
    public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
    }

    @Override
    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        if (finishEvent.getResult() instanceof CompileJavaBuildOperationType.Result) {
            CompileJavaBuildOperationType.Result result = (CompileJavaBuildOperationType.Result)finishEvent.getResult();
            Object taskBuildOperationId = this.findTaskOperationId(buildOperation.getParentId());
            this.results.put(taskBuildOperationId, result);
        }
        this.parentsOfOperationsWithJavaCompileTaskAncestor.remove(buildOperation.getId());
    }

    private Object findTaskOperationId(Object id) {
        Object parent = this.parentsOfOperationsWithJavaCompileTaskAncestor.get(id);
        if (parent == TASK_MARKER) {
            return id;
        }
        return this.findTaskOperationId(parent);
    }

    @Override
    public AbstractTaskResult process(AbstractTaskResult taskResult, Object taskBuildOperationId) {
        CompileJavaBuildOperationType.Result compileResult = this.results.remove(taskBuildOperationId);
        if (taskResult instanceof DefaultTaskSuccessResult && compileResult != null) {
            return new DefaultJavaCompileTaskSuccessResult((DefaultTaskSuccessResult)taskResult, this.toAnnotationProcessorResults(compileResult.getAnnotationProcessorDetails()));
        }
        return taskResult;
    }

    private List<InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult> toAnnotationProcessorResults(List<CompileJavaBuildOperationType.Result.AnnotationProcessorDetails> allDetails) {
        if (allDetails == null) {
            return null;
        }
        ArrayList<InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult> results = new ArrayList<InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult>(allDetails.size());
        for (CompileJavaBuildOperationType.Result.AnnotationProcessorDetails details : allDetails) {
            results.add(this.toAnnotationProcessorResult(details));
        }
        return results;
    }

    private InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult toAnnotationProcessorResult(CompileJavaBuildOperationType.Result.AnnotationProcessorDetails details) {
        return new DefaultAnnotationProcessorResult(details.getClassName(), this.toAnnotationProcessorType(details.getType()), Duration.ofMillis(details.getExecutionTimeInMillis()));
    }

    private String toAnnotationProcessorType(CompileJavaBuildOperationType.Result.AnnotationProcessorDetails.Type type) {
        switch (type) {
            case AGGREGATING: {
                return "AGGREGATING";
            }
            case ISOLATING: {
                return "ISOLATING";
            }
            case UNKNOWN: {
                return "UNKNOWN";
            }
        }
        throw new IllegalArgumentException("Missing conversion for enum constant " + (Object)((Object)type));
    }
}

