/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;

public abstract class TestClassVisitor
extends ClassVisitor {
    protected final TestFrameworkDetector detector;
    private boolean isAbstract;
    private String className;
    private String superClassName;
    private boolean test;

    protected TestClassVisitor(TestFrameworkDetector detector) {
        super(524288);
        if (detector == null) {
            throw new IllegalArgumentException("detector == null!");
        }
        this.detector = detector;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public boolean isTest() {
        return this.test;
    }

    protected void setTest(boolean test) {
        this.test = test;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isAbstract = (access & 0x400) != 0;
        this.className = name;
        this.superClassName = superName;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.ignoreNonStaticInnerClass() && this.innerClassIsNonStatic(name, access)) {
            this.isAbstract = true;
        }
    }

    protected abstract boolean ignoreNonStaticInnerClass();

    private boolean innerClassIsNonStatic(String name, int access) {
        return name.equals(this.getClassName()) && (access & 8) == 0;
    }
}

