/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.HashSet;
import java.util.Map;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.impl.AbstractFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Interner;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class RelativePathFingerprintingStrategy
extends AbstractFingerprintingStrategy {
    public static final String IDENTIFIER = "RELATIVE_PATH";
    private final DirectorySensitivity directorySensitivity;
    private final Interner<String> stringInterner;

    public RelativePathFingerprintingStrategy(Interner<String> stringInterner, DirectorySensitivity directorySensitivity) {
        super(IDENTIFIER);
        this.stringInterner = stringInterner;
        this.directorySensitivity = directorySensitivity;
    }

    @Override
    public String normalizePath(FileSystemLocationSnapshot snapshot) {
        if (snapshot.getType() == FileType.Directory) {
            return "";
        }
        return snapshot.getName();
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot roots) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet processedEntries = new HashSet();
        roots.accept(new RelativePathTracker(), (snapshot, relativePath) -> {
            String absolutePath = snapshot.getAbsolutePath();
            if (processedEntries.add(absolutePath) && this.directorySensitivity.shouldFingerprint(snapshot)) {
                FileSystemLocationFingerprint fingerprint = relativePath.isRoot() ? (snapshot.getType() == FileType.Directory ? IgnoredPathFileSystemLocationFingerprint.DIRECTORY : new DefaultFileSystemLocationFingerprint(snapshot.getName(), snapshot)) : new DefaultFileSystemLocationFingerprint((String)this.stringInterner.intern((Object)relativePath.toRelativePath()), snapshot);
                builder.put((Object)absolutePath, (Object)fingerprint);
            }
            return SnapshotVisitResult.CONTINUE;
        });
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.SORT;
    }

    @Override
    public DirectorySensitivity getDirectorySensitivity() {
        return this.directorySensitivity;
    }
}

