/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.PrimitiveHasher;

class ChecksumHasher
implements FileHasher {
    private final HashFunction hashFunction;

    public ChecksumHasher(HashFunction hashFunction) {
        this.hashFunction = hashFunction;
    }

    @Override
    public HashCode hash(File file) {
        try {
            PrimitiveHasher hasher = this.hashFunction.newPrimitiveHasher();
            byte[] buffer = new byte[4096];
            try (FileInputStream in = new FileInputStream(file);){
                int len;
                while ((len = ((InputStream)in).read(buffer)) >= 0) {
                    hasher.putBytes(buffer, 0, len);
                }
            }
            return hasher.hash();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public HashCode hash(File file, long length, long lastModified) {
        return this.hash(file);
    }
}

