/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationConstraint;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationQueueFactory;
import org.gradle.internal.operations.BuildOperationQueueFailure;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.BuildOperationState;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.DefaultBuildOperationRunner;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.operations.UnmanagedBuildOperationWrapper;
import org.gradle.internal.time.Clock;

public class DefaultBuildOperationExecutor
implements BuildOperationExecutor,
Stoppable {
    private static final String LINE_SEPARATOR = SystemProperties.getInstance().getLineSeparator();
    private final BuildOperationRunner runner;
    private final BuildOperationQueueFactory buildOperationQueueFactory;
    private final Map<BuildOperationConstraint, ManagedExecutor> managedExecutors = new HashMap<BuildOperationConstraint, ManagedExecutor>();
    private final CurrentBuildOperationRef currentBuildOperationRef = CurrentBuildOperationRef.instance();
    private final UnmanagedBuildOperationWrapper wrapper;

    public DefaultBuildOperationExecutor(BuildOperationListener listener, Clock clock, ProgressLoggerFactory progressLoggerFactory, BuildOperationQueueFactory buildOperationQueueFactory, ExecutorFactory executorFactory, ParallelismConfiguration parallelismConfiguration, BuildOperationIdFactory buildOperationIdFactory) {
        this.runner = new DefaultBuildOperationRunner(this.currentBuildOperationRef, clock::getCurrentTime, buildOperationIdFactory, () -> new ListenerAdapter(listener, progressLoggerFactory, clock));
        this.wrapper = new UnmanagedBuildOperationWrapper(listener, clock, this.currentBuildOperationRef);
        this.buildOperationQueueFactory = buildOperationQueueFactory;
        this.managedExecutors.put(BuildOperationConstraint.MAX_WORKERS, executorFactory.create("Build operations", parallelismConfiguration.getMaxWorkerCount()));
        this.managedExecutors.put(BuildOperationConstraint.UNCONSTRAINED, executorFactory.create("Unconstrained build operations", parallelismConfiguration.getMaxWorkerCount() * 10));
    }

    @Override
    public void run(RunnableBuildOperation buildOperation) {
        this.wrapper.runWithUnmanagedSupport(this.getCurrentBuildOperation(), parent -> this.runner.run(buildOperation));
    }

    @Override
    public <T> T call(CallableBuildOperation<T> buildOperation) {
        return (T)this.wrapper.callWithUnmanagedSupport(this.getCurrentBuildOperation(), parent -> this.runner.call(buildOperation));
    }

    @Override
    public <O extends BuildOperation> void execute(O buildOperation, BuildOperationWorker<O> worker, @Nullable BuildOperationState defaultParent) {
        this.wrapper.runWithUnmanagedSupport(defaultParent, parent -> this.runner.execute(buildOperation, worker, (BuildOperationState)parent));
    }

    @Override
    public BuildOperationContext start(BuildOperationDescriptor.Builder descriptor) {
        return this.runner.start(descriptor);
    }

    @Override
    public BuildOperationRef getCurrentOperation() {
        BuildOperationState current = this.getCurrentBuildOperation();
        if (current == null) {
            throw new IllegalStateException("No operation is currently running.");
        }
        return current;
    }

    @Override
    public <O extends RunnableBuildOperation> void runAll(Action<BuildOperationQueue<O>> schedulingAction) {
        this.runAll(schedulingAction, BuildOperationConstraint.MAX_WORKERS);
    }

    @Override
    public <O extends RunnableBuildOperation> void runAll(Action<BuildOperationQueue<O>> schedulingAction, BuildOperationConstraint buildOperationConstraint) {
        this.wrapper.runWithUnmanagedSupport(this.getCurrentBuildOperation(), parent -> this.executeInParallel(false, new QueueWorker((BuildOperationState)parent, RunnableBuildOperation::run), schedulingAction, buildOperationConstraint));
    }

    @Override
    public <O extends RunnableBuildOperation> void runAllWithAccessToProjectState(Action<BuildOperationQueue<O>> schedulingAction) {
        this.runAllWithAccessToProjectState(schedulingAction, BuildOperationConstraint.MAX_WORKERS);
    }

    @Override
    public <O extends RunnableBuildOperation> void runAllWithAccessToProjectState(Action<BuildOperationQueue<O>> schedulingAction, BuildOperationConstraint buildOperationConstraint) {
        this.wrapper.runWithUnmanagedSupport(this.getCurrentBuildOperation(), parent -> this.executeInParallel(true, new QueueWorker((BuildOperationState)parent, RunnableBuildOperation::run), schedulingAction, buildOperationConstraint));
    }

    @Override
    public <O extends BuildOperation> void runAll(BuildOperationWorker<O> worker, Action<BuildOperationQueue<O>> schedulingAction) {
        this.runAll(worker, schedulingAction, BuildOperationConstraint.MAX_WORKERS);
    }

    @Override
    public <O extends BuildOperation> void runAll(BuildOperationWorker<O> worker, Action<BuildOperationQueue<O>> schedulingAction, BuildOperationConstraint buildOperationConstraint) {
        this.wrapper.runWithUnmanagedSupport(this.getCurrentBuildOperation(), parent -> this.executeInParallel(false, new QueueWorker((BuildOperationState)parent, worker), schedulingAction, buildOperationConstraint));
    }

    @Nullable
    private BuildOperationState getCurrentBuildOperation() {
        return (BuildOperationState)this.currentBuildOperationRef.get();
    }

    private <O extends BuildOperation> void executeInParallel(boolean allowAccessToProjectState, BuildOperationQueue.QueueWorker<O> worker, Action<BuildOperationQueue<O>> queueAction, BuildOperationConstraint buildOperationConstraint) {
        ManagedExecutor executor = this.managedExecutors.get((Object)buildOperationConstraint);
        BuildOperationQueue<O> queue = this.buildOperationQueueFactory.create(executor, allowAccessToProjectState, worker);
        ArrayList failures = Lists.newArrayList();
        try {
            queueAction.execute(queue);
        }
        catch (Exception e) {
            failures.add(new BuildOperationQueueFailure("There was a failure while populating the build operation queue: " + e.getMessage(), e));
            queue.cancel();
        }
        try {
            queue.waitForCompletion();
        }
        catch (MultipleBuildOperationFailures e) {
            failures.add(e);
        }
        if (failures.size() == 1) {
            throw (GradleException)failures.get(0);
        }
        if (failures.size() > 1) {
            throw new DefaultMultiCauseException(DefaultBuildOperationExecutor.formatMultipleFailureMessage(failures), (Iterable<? extends Throwable>)failures);
        }
    }

    private static String formatMultipleFailureMessage(List<GradleException> failures) {
        return failures.stream().map(Throwable::getMessage).collect(Collectors.joining(LINE_SEPARATOR + "AND" + LINE_SEPARATOR));
    }

    @Override
    public void stop() {
        for (ManagedExecutor pool : this.managedExecutors.values()) {
            pool.stop();
        }
    }

    private class QueueWorker<O extends BuildOperation>
    implements BuildOperationQueue.QueueWorker<O> {
        private final BuildOperationState parent;
        private final BuildOperationWorker<? super O> worker;

        private QueueWorker(BuildOperationState parent, BuildOperationWorker<? super O> worker) {
            this.parent = parent;
            this.worker = worker;
        }

        @Override
        public String getDisplayName() {
            return "runnable worker";
        }

        @Override
        public void execute(O buildOperation) {
            DefaultBuildOperationExecutor.this.runner.execute(buildOperation, this.worker, this.parent);
        }
    }

    private static class ListenerAdapter
    implements DefaultBuildOperationRunner.BuildOperationExecutionListener {
        private final BuildOperationListener buildOperationListener;
        private final ProgressLoggerFactory progressLoggerFactory;
        private final Clock clock;
        private ProgressLogger progressLogger;

        public ListenerAdapter(BuildOperationListener buildOperationListener, ProgressLoggerFactory progressLoggerFactory, Clock clock) {
            this.buildOperationListener = buildOperationListener;
            this.progressLoggerFactory = progressLoggerFactory;
            this.clock = clock;
        }

        @Override
        public void start(BuildOperationDescriptor descriptor, BuildOperationState operationState) {
            this.buildOperationListener.started(descriptor, new OperationStartEvent(operationState.getStartTime()));
            ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(DefaultBuildOperationExecutor.class, descriptor);
            this.progressLogger = progressLogger.start(descriptor.getDisplayName(), descriptor.getProgressDisplayName());
        }

        @Override
        public void stop(BuildOperationDescriptor descriptor, BuildOperationState operationState, @Nullable BuildOperationState parent, DefaultBuildOperationRunner.ReadableBuildOperationContext context) {
            this.progressLogger.completed(context.getStatus(), context.getFailure() != null);
            this.buildOperationListener.finished(descriptor, new OperationFinishEvent(operationState.getStartTime(), this.clock.getCurrentTime(), context.getFailure(), context.getResult()));
        }

        @Override
        public void close(BuildOperationDescriptor descriptor, BuildOperationState operationState) {
        }
    }
}

