/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import java.io.File;
import java.nio.charset.Charset;
import org.gradle.api.NonNullApi;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationFailure;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.ExecException;
import org.gradle.util.internal.GFileUtils;

@NonNullApi
public class DefaultCommandLineToolInvocationWorker
implements CommandLineToolInvocationWorker {
    private final String name;
    private final File executable;
    private final ExecActionFactory execActionFactory;

    public DefaultCommandLineToolInvocationWorker(String name, File executable, ExecActionFactory execActionFactory) {
        this.name = name;
        this.executable = executable;
        this.execActionFactory = execActionFactory;
    }

    @Override
    public String getDisplayName() {
        return "command line tool '" + this.name + "'";
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public void execute(CommandLineToolInvocation invocation, BuildOperationContext context) {
        BuildOperationDescriptor description = invocation.description().build();
        ExecAction toolExec = this.execActionFactory.newExecAction();
        toolExec.executable(this.executable);
        if (invocation.getWorkDirectory() != null) {
            GFileUtils.mkdirs(invocation.getWorkDirectory());
            toolExec.workingDir(invocation.getWorkDirectory());
        }
        toolExec.args(invocation.getArgs());
        if (!invocation.getPath().isEmpty()) {
            String pathVar = OperatingSystem.current().getPathVar();
            String toolPath = Joiner.on((String)File.pathSeparator).join(invocation.getPath());
            toolPath = toolPath + File.pathSeparator + System.getenv(pathVar);
            toolExec.environment(pathVar, toolPath);
            if (OperatingSystem.current().isWindows() && toolExec.getEnvironment().containsKey(pathVar.toUpperCase())) {
                toolExec.getEnvironment().remove(pathVar.toUpperCase());
            }
        }
        toolExec.environment(invocation.getEnvironment());
        StreamByteBuffer errOutput = new StreamByteBuffer();
        StreamByteBuffer stdOutput = new StreamByteBuffer();
        toolExec.setErrorOutput(errOutput.getOutputStream());
        toolExec.setStandardOutput(stdOutput.getOutputStream());
        try {
            toolExec.execute();
            invocation.getLogger().operationSuccess(description.getDisplayName(), this.combineOutput(stdOutput, errOutput));
        }
        catch (ExecException e) {
            invocation.getLogger().operationFailed(description.getDisplayName(), this.combineOutput(stdOutput, errOutput));
            throw new CommandLineToolInvocationFailure(invocation, String.format("%s failed while %s.", this.name, description.getDisplayName()));
        }
    }

    private String combineOutput(StreamByteBuffer stdOutput, StreamByteBuffer errOutput) {
        return stdOutput.readAsString(Charset.defaultCharset()) + errOutput.readAsString(Charset.defaultCharset());
    }
}

