/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.PlatformContainer;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.util.internal.CollectionUtils;

public class DefaultPlatformResolvers
implements PlatformResolvers {
    private final List<PlatformResolver<?>> platformResolvers = Lists.newArrayList();
    private final PlatformContainer platforms;

    public DefaultPlatformResolvers(PlatformContainer platforms) {
        this.platforms = platforms;
    }

    @Override
    public void register(PlatformResolver<?> platformResolver) {
        this.platformResolvers.add(platformResolver);
    }

    @Override
    public <T extends Platform> T resolve(Class<T> type, PlatformRequirement platformRequirement) {
        for (PlatformResolver<?> platformResolver : this.platformResolvers) {
            PlatformResolver<?> pr;
            Object resolved;
            if (!platformResolver.getType().equals(type) || (resolved = (pr = platformResolver).resolve(platformRequirement)) == null) continue;
            return (T)resolved;
        }
        return this.resolveFromContainer(type, platformRequirement);
    }

    private <T extends Platform> T resolveFromContainer(Class<T> type, PlatformRequirement platformRequirement) {
        final String target = platformRequirement.getPlatformName();
        NamedDomainObjectCollection allWithType = this.platforms.withType(type);
        Platform matching = (Platform)CollectionUtils.findFirst(allWithType, new Spec<T>(){

            @Override
            public boolean isSatisfiedBy(T element) {
                return element.getName().equals(target);
            }
        });
        if (matching == null) {
            throw new InvalidUserDataException(String.format("Invalid %s: %s", type.getSimpleName(), target));
        }
        return (T)matching;
    }
}

