/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.initialization.GradlePropertiesController;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.invocation.DefaultGradle;

public class TestBuildScopeServices
extends BuildScopeServices {
    private final File homeDir;
    private final StartParameterInternal startParameter;

    public TestBuildScopeServices(ServiceRegistry parent, File homeDir, StartParameterInternal startParameter) {
        super(parent);
        this.homeDir = homeDir;
        this.startParameter = startParameter;
    }

    @Override
    protected GradleProperties createGradleProperties(GradlePropertiesController gradlePropertiesController) {
        return new EmptyGradleProperties();
    }

    protected BuildDefinition createBuildDefinition(StartParameterInternal startParameter) {
        return BuildDefinition.fromStartParameter(startParameter, null);
    }

    protected BuildCancellationToken createBuildCancellationToken() {
        return new DefaultBuildCancellationToken();
    }

    protected BuildClientMetaData createClientMetaData() {
        return new GradleLauncherMetaData();
    }

    protected CurrentGradleInstallation createCurrentGradleInstallation() {
        return new CurrentGradleInstallation(new GradleInstallation(this.homeDir));
    }

    protected GradleInternal createGradle(InstantiatorFactory instantiatorFactory, ServiceRegistryFactory serviceRegistryFactory) {
        return instantiatorFactory.decorateLenient().newInstance(DefaultGradle.class, null, this.startParameter, serviceRegistryFactory);
    }

    private static class EmptyGradleProperties
    implements GradleProperties {
        private EmptyGradleProperties() {
        }

        @Override
        @Nullable
        public String find(String propertyName) {
            return null;
        }

        @Override
        public Map<String, String> mergeProperties(Map<String, String> properties) {
            return properties;
        }
    }
}

