/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.base.plugins;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.testing.AbstractTestTask;

public class TestingBasePlugin
implements Plugin<Project> {
    public static final String TEST_RESULTS_DIR_NAME = "test-results";
    public static final String TESTS_DIR_NAME = "tests";
    private static final Transformer<File, Directory> TO_FILE_TRANSFORMER = new Transformer<File, Directory>(){

        @Override
        public File transform(Directory directory) {
            return directory.getAsFile();
        }
    };

    @Override
    public void apply(final Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        project.getTasks().withType(AbstractTestTask.class, new Action<AbstractTestTask>(){

            @Override
            public void execute(AbstractTestTask test) {
                test.getReports().getHtml().setDestination(TestingBasePlugin.this.getTestReportsDir(project, test).map(TO_FILE_TRANSFORMER));
                test.getReports().getJunitXml().setDestination(TestingBasePlugin.this.getTestResultsDir(project, test).map(TO_FILE_TRANSFORMER));
                test.getBinaryResultsDirectory().set(TestingBasePlugin.this.getTestResultsDir(project, test).map(new Transformer<Directory, Directory>(){

                    @Override
                    public Directory transform(Directory directory) {
                        return directory.dir("binary");
                    }
                }));
            }
        });
    }

    private Provider<Directory> getTestResultsDir(Project project, AbstractTestTask test) {
        return project.getLayout().getBuildDirectory().dir("test-results/" + test.getName());
    }

    private Provider<Directory> getTestReportsDir(Project project, AbstractTestTask test) {
        DirectoryProperty baseDirectory = project.getExtensions().getByType(ReportingExtension.class).getBaseDirectory();
        return baseDirectory.dir("tests/" + test.getName());
    }
}

