/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.Collection;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.ProvidesWorkResult;
import org.gradle.workers.internal.SimpleActionExecutionSpec;
import org.gradle.workers.internal.Worker;

public class DefaultWorkerServer
implements Worker {
    private final ServiceRegistry internalServices;
    private final InstantiatorFactory instantiatorFactory;
    private final IsolationScheme<WorkAction<?>, WorkParameters> isolationScheme;
    private final Collection<? extends Class<?>> additionalWhitelistedServices;

    public DefaultWorkerServer(ServiceRegistry internalServices, InstantiatorFactory instantiatorFactory, IsolationScheme<WorkAction<?>, WorkParameters> isolationScheme, Collection<? extends Class<?>> additionalWhitelistedServices) {
        this.internalServices = internalServices;
        this.instantiatorFactory = instantiatorFactory;
        this.isolationScheme = isolationScheme;
        this.additionalWhitelistedServices = additionalWhitelistedServices;
    }

    @Override
    public DefaultWorkResult execute(SimpleActionExecutionSpec<?> spec) {
        try {
            Class implementationClass = (Class)Cast.uncheckedCast(spec.getImplementationClass());
            Spec<Class<Object>> whiteListPolicy = spec.isInternalServicesRequired() ? element -> true : element -> false;
            ServiceLookup instantiationServices = this.isolationScheme.servicesForImplementation((WorkParameters)spec.getParameters(), this.internalServices, (Collection<Class<?>>)this.additionalWhitelistedServices, whiteListPolicy);
            InstanceGenerator instantiator = this.instantiatorFactory.inject(instantiationServices);
            WorkAction execution = ProvidesWorkResult.class.isAssignableFrom(implementationClass) ? (WorkAction)instantiator.newInstance(implementationClass, spec.getParameters(), instantiator) : (WorkAction)instantiator.newInstance(implementationClass, new Object[0]);
            execution.execute();
            if (execution instanceof ProvidesWorkResult) {
                return ((ProvidesWorkResult)((Object)execution)).getWorkResult();
            }
            return DefaultWorkResult.SUCCESS;
        }
        catch (Throwable t) {
            return new DefaultWorkResult(true, t);
        }
    }

    public String toString() {
        return "DefaultWorkerServer{}";
    }
}

