/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.editor.CssFormattingElementVisitor;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.psi.SASSElementTypes;
import org.jetbrains.plugins.scss.SCSSElementTypes;
import org.jetbrains.plugins.scss.SCSSLanguage;
import org.jetbrains.plugins.scss.formatter.SCSSRulesetBlock;
import org.jetbrains.plugins.scss.formatter.ScssIncludeBlock;
import org.jetbrains.plugins.scss.formatter.ScssRootBlock;
import org.jetbrains.plugins.scss.formatter.ScssVariableDeclarationBlock;
import org.jetbrains.plugins.scss.lexer.SCSSTokenTypes;
import org.jetbrains.plugins.scss.psi.SCSSInterpolationImpl;
import org.jetbrains.plugins.scss.psi.SCSSOperationImpl;
import org.jetbrains.plugins.scss.psi.SassScssForwardAtRule;
import org.jetbrains.plugins.scss.psi.SassScssFunctionBodyImpl;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssPropertyRuleset;
import org.jetbrains.plugins.scss.psi.SassScssRuleset;
import org.jetbrains.plugins.scss.psi.SassScssStatement;
import org.jetbrains.plugins.scss.psi.SassScssUseAtRule;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;
import org.jetbrains.plugins.scss.settings.ScssCodeStyleSettings;

public class SCSSFormattingModelBuilder
extends CssFormattingModelBuilder {
    private static final TokenSet CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_DECLARATION_BLOCK, CssElementTypes.CSS_PAGE_BLOCK, CssElementTypes.CSS_KEYFRAMES_RULE, SASSElementTypes.DECLARATION_BLOCK, SCSSElementTypes.SCSS_FUNCTION_BODY, SCSSElementTypes.SCSS_PROPERTY_RULESET});

    protected ScssFormattingExtension createExtension(CodeStyleSettings settings) {
        return new ScssFormattingExtension(settings.getCommonSettings((Language)SCSSLanguage.INSTANCE), (CssCodeStyleSettings)settings.getCustomSettings(ScssCodeStyleSettings.class));
    }

    private static class SassScssMapEntryFormatterBlock
    extends CssFormattingModelBuilder.CssFormatterBlock {
        SassScssMapEntryFormatterBlock(PsiElement element, CssFormattingModelBuilder.CssFormattingExtension extension) {
            super(element.getNode(), Indent.getContinuationIndent(), extension);
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                SassScssMapEntryFormatterBlock.$$$reportNull$$$0(0);
            }
            return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)true, (int)this.getKeepBlankLines());
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/scss/formatter/SCSSFormattingModelBuilder$SassScssMapEntryFormatterBlock", "getSpacing"));
        }
    }

    private static class SassScssMapFormatterBlock
    extends CssFormattingModelBuilder.CssFormatterBlock {
        SassScssMapFormatterBlock(PsiElement element, CssFormattingModelBuilder.CssFormattingExtension extension) {
            super(element.getNode(), Indent.getNoneIndent(), extension);
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                SassScssMapFormatterBlock.$$$reportNull$$$0(0);
            }
            if (!(child1 instanceof CssFormattingModelBuilder.CssFormatterBlock) || !(child2 instanceof CssFormattingModelBuilder.CssFormatterBlock)) {
                return null;
            }
            CssFormattingModelBuilder.CssFormatterBlock formatterBlock = (CssFormattingModelBuilder.CssFormatterBlock)child1;
            CssFormattingModelBuilder.CssFormatterBlock formatterBlock2 = (CssFormattingModelBuilder.CssFormatterBlock)child2;
            if (formatterBlock2.myType == CssElementTypes.CSS_COMMA) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (formatterBlock.myType == CssElementTypes.CSS_LPAREN || formatterBlock2.myType == CssElementTypes.CSS_RPAREN) {
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)0);
            }
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
        }

        public boolean shouldIndentContent() {
            return true;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(Indent.getContinuationIndent(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/scss/formatter/SCSSFormattingModelBuilder$SassScssMapFormatterBlock", "getSpacing"));
        }
    }

    private static final class SassScssForwardFormatterBlock
    extends CssFormattingModelBuilder.CssPropertyBlock {
        private SassScssForwardFormatterBlock(ASTNode _node, CssFormattingModelBuilder.CssFormattingExtension extension) {
            super(_node, Indent.getNoneIndent(), extension, null, null);
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                SassScssForwardFormatterBlock.$$$reportNull$$$0(0);
            }
            if (child1 instanceof CssFormattingModelBuilder.CssFormatterBlock && child2 instanceof CssFormattingModelBuilder.CssFormatterBlock) {
                if (((CssFormattingModelBuilder.CssFormatterBlock)child1).getNode().getElementType() == CssElementTypes.CSS_IDENT && ((CssFormattingModelBuilder.CssFormatterBlock)child2).getNode().getElementType() == CssElementTypes.CSS_ASTERISK) {
                    return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
                }
                if (((CssFormattingModelBuilder.CssFormatterBlock)child1).getNode().getElementType() == CssElementTypes.CSS_ASTERISK && ((CssFormattingModelBuilder.CssFormatterBlock)child2).getNode().getElementType() == CssElementTypes.CSS_IDENT) {
                    return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
                }
            }
            return super.getSpacing(child1, child2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/scss/formatter/SCSSFormattingModelBuilder$SassScssForwardFormatterBlock", "getSpacing"));
        }
    }

    protected static class ScssFormattingExtension
    extends CssFormattingModelBuilder.CssFormattingExtension {
        public ScssFormattingExtension(CommonCodeStyleSettings commonSettings, CssCodeStyleSettings customSettings) {
            super(commonSettings, customSettings);
        }

        public boolean isComment(IElementType elementType) {
            return SCSSTokenTypes.COMMENTS.contains(elementType) || super.isComment(elementType);
        }

        public boolean isLineComment(IElementType elementType) {
            return SCSSTokenTypes.COMMENT == elementType || super.isComment(elementType);
        }

        public boolean addSubBlocks(PsiElement element, List<Block> result) {
            if (element instanceof SassScssPropertyRuleset) {
                result.add((Block)this.createRulesetBlock(element.getNode(), Indent.getNormalIndent(), this, null));
                return true;
            }
            return false;
        }

        public boolean addSubBlocksOfExtendedLanguage(PsiElement element, Alignment childAlignment, List<Block> result) {
            Indent indent;
            Indent indent2 = indent = this.isContainer(element.getParent().getNode().getElementType()) ? Indent.getNormalIndent() : Indent.getNoneIndent();
            if (element instanceof SassScssVariableDeclaration) {
                result.add((Block)new ScssVariableDeclarationBlock(element.getNode(), indent, this, null, childAlignment));
                return true;
            }
            if (element instanceof SassScssVariableImpl) {
                result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), Indent.getNoneIndent(), (CssFormattingModelBuilder.CssFormattingExtension)this));
                return true;
            }
            if (element.getNode().getElementType() == SCSSElementTypes.MAP) {
                result.add((Block)new SassScssMapFormatterBlock(element, this));
                return true;
            }
            if (element.getNode().getElementType() == SCSSElementTypes.MAP_ENTRY) {
                result.add((Block)new SassScssMapEntryFormatterBlock(element, this));
                return true;
            }
            if (element instanceof SassScssInclude) {
                if (PsiTreeUtil.getNextSiblingOfType((PsiElement)element, CssBlock.class) != null) {
                    indent = Indent.getNoneIndent();
                }
                result.add((Block)new ScssIncludeBlock(element.getNode(), indent, this));
                return true;
            }
            if (element instanceof SassScssRuleset) {
                result.add((Block)this.createRulesetBlock(element.getNode(), indent, this, null));
                return true;
            }
            if (element instanceof SassScssFunctionBodyImpl) {
                element.acceptChildren((PsiElementVisitor)new CssFormattingElementVisitor(result, this.myCustomSettings, (CssFormattingModelBuilder.CssFormattingExtension)this, null, null, (IElementType)SCSSElementTypes.SCSS_FUNCTION_BODY, true));
                return true;
            }
            if (element instanceof SassScssStatement) {
                result.add((Block)this.createPropertyBlock(element.getNode(), this, null, null));
                return true;
            }
            if (element instanceof SassScssUseAtRule) {
                result.add((Block)this.createPropertyBlock(element.getNode(), this, null, null));
                return true;
            }
            if (element instanceof SassScssForwardAtRule) {
                result.add((Block)new SassScssForwardFormatterBlock(element.getNode(), this));
                return true;
            }
            if (element instanceof SCSSInterpolationImpl) {
                result.add((Block)new CssFormattingModelBuilder.LeafBlock(element.getNode(), Indent.getNoneIndent()));
                return true;
            }
            if (element instanceof SCSSOperationImpl) {
                result.add((Block)new CssFormattingModelBuilder.CssSimpleBlock(element.getNode(), Indent.getNoneIndent(), (CssFormattingModelBuilder.CssFormattingExtension)this));
                return true;
            }
            if (element.getNode().getElementType() == SCSSElementTypes.SCSS_PARENTHESIS_EXPRESSION) {
                result.add((Block)this.createTermListBlock(element.getNode(), Indent.getContinuationIndent(), null, true));
                return true;
            }
            return false;
        }

        protected boolean isContainer(@Nullable IElementType elementType) {
            return CONTAINERS.contains(elementType);
        }

        public CssFormattingModelBuilder.CssRootBlock createRootBlock(ASTNode _node, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return new ScssRootBlock(_node, extension);
        }

        public CssFormattingModelBuilder.CssRulesetBlock createRulesetBlock(ASTNode _node, Indent indent, CssFormattingModelBuilder.CssFormattingExtension extension, @Nullable Alignment alignment) {
            return new SCSSRulesetBlock(_node, indent, extension, alignment);
        }

        public CssFormattingModelBuilder.CssPropertyBlock createPropertyBlock(ASTNode _node, CssFormattingModelBuilder.CssFormattingExtension extension, @Nullable Alignment alignment, Alignment childAlignment) {
            Indent indent = _node.getTreeParent().getElementType() == SASSElementTypes.PROPERTY_RULESET || PsiTreeUtil.getParentOfType((PsiElement)_node.getPsi(), CssBlock.class) == null && PsiTreeUtil.getParentOfType((PsiElement)_node.getPsi(), SassScssFunctionBodyImpl.class) == null ? Indent.getNoneIndent() : Indent.getNormalIndent();
            return super.createPropertyBlock(_node, indent, extension, alignment, childAlignment);
        }

        public CssFormattingModelBuilder.CssFormatterBlock createMediaBlock(ASTNode node, Indent indent, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return this.createRulesetBlock(node, indent, extension, null);
        }

        public CssFormattingModelBuilder.CssFormatterBlock createSupportsBlock(ASTNode node, Indent indent, CssFormattingModelBuilder.CssFormattingExtension extension) {
            return this.createRulesetBlock(node, indent, extension, null);
        }
    }
}

