/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ContinuationOption;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartIndentOptionsEditor
extends IndentOptionsEditor {
    private JCheckBox myCbSmartTabs;
    private final ContinuationOption myContinuationOption;
    private final ContinuationOption myDeclarationParameterIndentOption;
    private final ContinuationOption myGenericTypeParameterIndentOption;
    private final ContinuationOption myCallParameterIndentOption;
    private final ContinuationOption myChainedCallIndentOption;
    private final ContinuationOption myArrayElementIndentOption;
    private final List<ContinuationOption> myContinuationOptions = new ArrayList<ContinuationOption>();
    private JCheckBox myCbKeepIndentsOnEmptyLines;

    public SmartIndentOptionsEditor() {
        this((LanguageCodeStyleSettingsProvider)null);
    }

    public SmartIndentOptionsEditor(@Nullable LanguageCodeStyleSettingsProvider provider) {
        super(provider);
        this.myContinuationOption = this.createContinuationOption(SmartIndentOptionsEditor.getContinuationIndentLabel(), options -> options.CONTINUATION_INDENT_SIZE, (options, value2) -> {
            options.CONTINUATION_INDENT_SIZE = value2;
        }, 8);
        this.myContinuationOption.setSupported(true);
        this.myDeclarationParameterIndentOption = this.createContinuationOption(ApplicationBundle.message("editbox.indent.declaration.parameter", new Object[0]), options -> options.DECLARATION_PARAMETER_INDENT, (options, value2) -> {
            options.DECLARATION_PARAMETER_INDENT = value2;
        }, -1);
        this.myGenericTypeParameterIndentOption = this.createContinuationOption(ApplicationBundle.message("editbox.indent.generic.type", new Object[0]), options -> options.GENERIC_TYPE_PARAMETER_INDENT, (options, value2) -> {
            options.GENERIC_TYPE_PARAMETER_INDENT = value2;
        }, -1);
        this.myCallParameterIndentOption = this.createContinuationOption(ApplicationBundle.message("editbox.indent.call.parameter", new Object[0]), options -> options.CALL_PARAMETER_INDENT, (options, value2) -> {
            options.CALL_PARAMETER_INDENT = value2;
        }, -1);
        this.myChainedCallIndentOption = this.createContinuationOption(ApplicationBundle.message("editbox.indent.chained.call", new Object[0]), options -> options.CHAINED_CALL_INDENT, (options, value2) -> {
            options.CHAINED_CALL_INDENT = value2;
        }, -1);
        this.myArrayElementIndentOption = this.createContinuationOption(ApplicationBundle.message("editbox.indent.array.element", new Object[0]), options -> options.ARRAY_ELEMENT_INDENT, (options, value2) -> {
            options.ARRAY_ELEMENT_INDENT = value2;
        }, -1);
    }

    private ContinuationOption createContinuationOption(@NotNull @NlsContexts.Label String labelText, Function<? super CommonCodeStyleSettings.IndentOptions, Integer> getter2, BiConsumer<? super CommonCodeStyleSettings.IndentOptions, ? super Integer> setter2, int defaultValue) {
        if (labelText == null) {
            SmartIndentOptionsEditor.$$$reportNull$$$0(0);
        }
        ContinuationOption option = new ContinuationOption(labelText, getter2, setter2, defaultValue);
        this.myContinuationOptions.add(option);
        return option;
    }

    @Override
    protected void addTabOptions() {
        super.addTabOptions();
        this.myCbSmartTabs = new JCheckBox(ApplicationBundle.message("checkbox.indent.smart.tabs", new Object[0]));
        this.add((JComponent)this.myCbSmartTabs, true);
    }

    @Override
    protected void addComponents() {
        super.addComponents();
        for (ContinuationOption option : this.myContinuationOptions) {
            option.addToEditor(this);
        }
        this.myContinuationOption.addListener(newValue -> this.updateDefaults((Integer)newValue));
        this.myCbKeepIndentsOnEmptyLines = new JCheckBox(ApplicationBundle.message("checkbox.indent.keep.indents.on.empty.lines", new Object[0]));
        this.add(this.myCbKeepIndentsOnEmptyLines);
    }

    private void updateDefaults(@NotNull Integer value2) {
        if (value2 == null) {
            SmartIndentOptionsEditor.$$$reportNull$$$0(1);
        }
        for (ContinuationOption option : this.myContinuationOptions) {
            if (option == this.myContinuationOption) continue;
            option.setDefaultValueToDisplay(value2);
        }
    }

    @Override
    public boolean isModified(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        boolean isModified = super.isModified(settings, options);
        isModified |= SmartIndentOptionsEditor.isFieldModified(this.myCbSmartTabs, options.SMART_TABS);
        for (ContinuationOption continuationOption : this.myContinuationOptions) {
            isModified |= continuationOption.isModified(options);
        }
        return isModified |= SmartIndentOptionsEditor.isFieldModified(this.myCbKeepIndentsOnEmptyLines, options.KEEP_INDENTS_ON_EMPTY_LINES);
    }

    @Override
    public void apply(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options) {
        super.apply(settings, options);
        for (ContinuationOption continuationOption : this.myContinuationOptions) {
            continuationOption.apply(options);
        }
        options.SMART_TABS = SmartIndentOptionsEditor.isSmartTabValid(options.INDENT_SIZE, options.TAB_SIZE) && this.myCbSmartTabs.isSelected();
        options.KEEP_INDENTS_ON_EMPTY_LINES = this.myCbKeepIndentsOnEmptyLines.isSelected();
    }

    @Override
    public void reset(@NotNull CodeStyleSettings settings, @NotNull CommonCodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            SmartIndentOptionsEditor.$$$reportNull$$$0(2);
        }
        if (options == null) {
            SmartIndentOptionsEditor.$$$reportNull$$$0(3);
        }
        super.reset(settings, options);
        for (ContinuationOption continuationOption : this.myContinuationOptions) {
            continuationOption.reset(options);
        }
        this.myCbSmartTabs.setSelected(options.SMART_TABS);
        this.myCbKeepIndentsOnEmptyLines.setSelected(options.KEEP_INDENTS_ON_EMPTY_LINES);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean smartTabsChecked = enabled && this.isUseTabsSelected();
        boolean smartTabsValid = smartTabsChecked && SmartIndentOptionsEditor.isSmartTabValid(this.getUIIndent(), this.getUITabSize());
        this.myCbSmartTabs.setEnabled(smartTabsValid);
        this.myCbSmartTabs.setToolTipText(smartTabsChecked && !smartTabsValid ? ApplicationBundle.message("tooltip.indent.must.be.multiple.of.tab.size.for.smart.tabs.to.operate", new Object[0]) : null);
        this.myContinuationOption.setEnabled(enabled);
        this.myCbKeepIndentsOnEmptyLines.setEnabled(enabled);
    }

    private static boolean isSmartTabValid(int indent, int tabSize) {
        return indent / tabSize * tabSize == indent;
    }

    public SmartIndentOptionsEditor withDeclarationParameterIndent() {
        this.myDeclarationParameterIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withGenericTypeParameterIndent() {
        this.myGenericTypeParameterIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withCallParameterIndent() {
        this.myCallParameterIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withChainedCallIndent() {
        this.myChainedCallIndentOption.setSupported(true);
        return this;
    }

    public SmartIndentOptionsEditor withArrayElementIndent() {
        this.myArrayElementIndentOption.setSupported(true);
        return this;
    }

    @Override
    public void showStandardOptions(String ... optionNames) {
        super.showStandardOptions(optionNames);
        for (String optionName : optionNames) {
            if (CodeStyleSettingsCustomizable.IndentOption.SMART_TABS.toString().equals(optionName)) {
                this.myCbSmartTabs.setVisible(true);
                continue;
            }
            if (CodeStyleSettingsCustomizable.IndentOption.CONTINUATION_INDENT_SIZE.toString().equals(optionName)) {
                this.myContinuationOption.setVisible(true);
                continue;
            }
            if (!CodeStyleSettingsCustomizable.IndentOption.KEEP_INDENTS_ON_EMPTY_LINES.toString().equals(optionName)) continue;
            this.myCbKeepIndentsOnEmptyLines.setVisible(true);
        }
    }

    @Override
    protected void setVisible(boolean visible2) {
        super.setVisible(visible2);
        this.myCbSmartTabs.setVisible(visible2);
        this.myContinuationOption.setVisible(visible2);
        this.myCbKeepIndentsOnEmptyLines.setVisible(visible2);
    }

    @NlsContexts.Label
    public static String getContinuationIndentLabel() {
        return ApplicationBundle.message("editbox.indent.continuation.indent", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/SmartIndentOptionsEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createContinuationOption";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDefaults";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

